/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.oslc.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.oslc.core.IOslcConnector;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceDescriptor;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProvider;
import org.eclipse.mylyn.internal.oslc.core.OslcServiceProviderCatalog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class OslcServiceDiscoveryProvider
implements ITreeContentProvider {
    private final IOslcConnector connector;
    private final TaskRepository repository;
    private OslcServiceProvider selectedPovider;
    private DeferredTreeContentManager manager;

    OslcServiceDiscoveryProvider(IOslcConnector connector, TaskRepository repository, String base) {
        this.connector = connector;
        this.repository = repository;
    }

    public Object[] getChildren(Object parentElement) {
        return this.manager.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public OslcServiceProvider getOSLServiceProvider() {
        return this.selectedPovider;
    }

    public boolean hasChildren(Object element) {
        return this.manager.mayHaveChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            List rootProviders = (List)inputElement;
            Object[] result = new Object[rootProviders.size()];
            int x = 0;
            while (x < rootProviders.size()) {
                result[x] = new ServiceProviderCatalogWrapper(rootProviders.get(x));
                ++x;
            }
            return result;
        }
        Object[] result = new Object[]{inputElement};
        return result;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof AbstractTreeViewer) {
            this.manager = new DeferredTreeContentManager(null, (AbstractTreeViewer)viewer);
        }
    }

    protected class ServiceProviderCatalogWrapper
    implements IDeferredWorkbenchAdapter {
        private final Object element;

        public ServiceProviderCatalogWrapper(Object catalog) {
            this.element = catalog;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            try {
                try {
                    monitor.beginTask("Loading...", -1);
                    ServiceProviderCatalogWrapper wrapper = (ServiceProviderCatalogWrapper)object;
                    Object parentElement = wrapper.getServiceObject();
                    if (parentElement instanceof OslcServiceProviderCatalog) {
                        OslcServiceProviderCatalog remoteFolder = (OslcServiceProviderCatalog)parentElement;
                        List providers = OslcServiceDiscoveryProvider.this.connector.getAvailableServices(OslcServiceDiscoveryProvider.this.repository, remoteFolder.getUrl(), monitor);
                        for (OslcServiceProvider oslcServiceProvider : providers) {
                            collector.add((Object)new ServiceProviderCatalogWrapper(oslcServiceProvider), monitor);
                        }
                    } else if (parentElement instanceof OslcServiceProvider) {
                        OslcServiceDiscoveryProvider.this.selectedPovider = (OslcServiceProvider)parentElement;
                        OslcServiceDescriptor serviceDescriptor = OslcServiceDiscoveryProvider.this.connector.getServiceDescriptor(OslcServiceDiscoveryProvider.this.repository, OslcServiceDiscoveryProvider.this.selectedPovider, monitor);
                        collector.add((Object)new ServiceProviderCatalogWrapper(serviceDescriptor), monitor);
                    }
                }
                catch (CoreException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.oslc.core", "Error occurred during service discovery", (Throwable)e));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return this.element instanceof OslcServiceProviderCatalog || this.element instanceof OslcServiceProvider;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return null;
        }

        public Object getParent(Object o) {
            return null;
        }

        public Object getServiceObject() {
            return this.element;
        }
    }
}

