/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.bugs.AbstractSupportElement;
import org.eclipse.mylyn.internal.tasks.bugs.Messages;
import org.eclipse.mylyn.internal.tasks.bugs.ProductRepositoryMapping;
import org.eclipse.mylyn.internal.tasks.bugs.SupportCategory;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProduct;
import org.eclipse.mylyn.internal.tasks.bugs.SupportProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupportProviderManager {
    private static final String ATTRIBUTE_CATEGORY_ID = "categoryId";
    private static final String ATTRIBUTE_DESCRIPTION = "description";
    private static final String ATTRIBUTE_FEATURE_ID = "featureId";
    private static final String ATTRIBUTE_ICON = "icon";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_NAMESPACE = "namespace";
    private static final String ATTRIBUTE_PLUGIN_ID = "pluginId";
    private static final String ATTRIBUTE_PRODUCT_ID = "productId";
    private static final String ATTRIBUTE_PROVIDER_ID = "providerId";
    private static final String ATTRIBUTE_REPOSITORY_KIND = "kind";
    private static final String ATTRIBUTE_REPOSITORY_URL = "url";
    private static final String ATTRIBUTE_URL = "url";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    private static final String ELEMENT_CATEGORY = "category";
    private static final String ELEMENT_MAPPING = "mapping";
    private static final String ELEMENT_PRODUCT = "product";
    private static final String ELEMENT_PROPERTY = "property";
    private static final String ELEMENT_PROVIDER = "provider";
    private static final String ELEMENT_REPOSITORY = "repository";
    private static final String EXTENSION_ID_PLUGIN_SUPPORT = "org.eclipse.mylyn.tasks.bugs.support";
    private HashMap<String, IBundleGroup> bundleGroupById;
    private List<SupportCategory> categories;
    private SupportProduct defaultProduct;
    private Map<String, SupportProduct> productById;
    private Map<String, SupportProvider> providerById;

    public SupportProviderManager() {
        this.readExtensions();
    }

    public void addCategory(SupportCategory category) {
        this.categories.add(category);
    }

    public boolean addProduct(SupportProduct product) {
        if (this.providerById.containsKey(product.getId())) {
            return false;
        }
        this.productById.put(product.getId(), product);
        return true;
    }

    public boolean addProvider(SupportProvider provider) {
        if (this.providerById.containsKey(provider.getId())) {
            return false;
        }
        this.providerById.put(provider.getId(), provider);
        return true;
    }

    private IBundleGroup getBundleGroup(String featureId) {
        if (this.bundleGroupById == null) {
            this.bundleGroupById = new HashMap();
            IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
            if (providers != null) {
                IBundleGroupProvider[] iBundleGroupProviderArray = providers;
                int n = providers.length;
                int n2 = 0;
                while (n2 < n) {
                    IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                    IBundleGroup[] iBundleGroupArray = provider.getBundleGroups();
                    int n3 = iBundleGroupArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IBundleGroup bundleGroup = iBundleGroupArray[n4];
                        this.bundleGroupById.put(bundleGroup.getIdentifier(), bundleGroup);
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        return this.bundleGroupById.get(featureId);
    }

    public Collection<SupportCategory> getCategories() {
        return Collections.unmodifiableList(this.categories);
    }

    public SupportCategory getCategory(String categoryId) {
        for (SupportCategory category : this.categories) {
            if (!category.getId().equals(categoryId)) continue;
            return category;
        }
        return null;
    }

    public SupportProduct getDefaultProduct() {
        return this.defaultProduct;
    }

    public SupportProduct getProduct(String productId) {
        return this.productById.get(productId);
    }

    public Collection<SupportProduct> getProducts() {
        return Collections.unmodifiableCollection(this.productById.values());
    }

    public SupportProvider getProvider(String providerId) {
        return this.providerById.get(providerId);
    }

    public Collection<SupportProvider> getProviders() {
        return Collections.unmodifiableCollection(this.providerById.values());
    }

    private boolean readAttributes(IConfigurationElement element, AbstractSupportElement item) {
        ImageDescriptor descriptor;
        item.setId(element.getAttribute(ATTRIBUTE_ID));
        item.setName(element.getAttribute(ATTRIBUTE_NAME));
        item.setDescription(element.getAttribute(ATTRIBUTE_DESCRIPTION));
        item.setUrl(element.getAttribute("url"));
        String iconPath = element.getAttribute(ATTRIBUTE_ICON);
        if (iconPath != null && (descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)iconPath)) != null) {
            item.setIcon(descriptor);
        }
        boolean available = true;
        String featureId = element.getAttribute(ATTRIBUTE_FEATURE_ID);
        if (featureId != null) {
            IBundleGroup bundleGroup = this.getBundleGroup(featureId);
            if (bundleGroup == null) {
                available = false;
            } else {
                String imageUrl;
                if (item.getName() == null) {
                    item.setName(bundleGroup.getName());
                }
                if (item.getDescription() == null) {
                    item.setDescription(bundleGroup.getDescription());
                }
                if (item.getIcon() == null && (imageUrl = bundleGroup.getProperty("featureImage")) != null) {
                    try {
                        item.setIcon(ImageDescriptor.createFromURL((URL)new URL(imageUrl)));
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                if (item instanceof SupportProduct) {
                    ((SupportProduct)item).setBundleGroup(bundleGroup);
                }
            }
        }
        if (item.getName() == null) {
            item.setName(Messages.SupportProviderManager_Product_Unknown);
        }
        return available;
    }

    private void readCategory(IConfigurationElement element) {
        SupportCategory category = new SupportCategory();
        this.readAttributes(element, category);
        String weight = element.getAttribute(ATTRIBUTE_WEIGHT);
        if (weight != null) {
            try {
                category.setWeight(Integer.parseInt(weight));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.categories.add(category);
    }

    private void readExtensions() {
        IConfigurationElement element;
        int n;
        int n2;
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] elements;
        IExtension extension;
        IExtension[] extensions;
        this.categories = new ArrayList<SupportCategory>();
        this.productById = new HashMap<String, SupportProduct>();
        this.providerById = new HashMap<String, SupportProvider>();
        this.defaultProduct = new SupportProduct();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_PLUGIN_SUPPORT);
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n3 = extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = elements = extension.getConfigurationElements();
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals(ELEMENT_CATEGORY)) {
                    this.readCategory(element);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = elements = extension.getConfigurationElements();
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals(ELEMENT_PROVIDER)) {
                    this.readProvider(element);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = elements = extension.getConfigurationElements();
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals(ELEMENT_PRODUCT)) {
                    this.readProduct(element);
                }
                ++n;
            }
            ++n4;
        }
        iExtensionArray = extensions;
        n3 = extensions.length;
        n4 = 0;
        while (n4 < n3) {
            extension = iExtensionArray[n4];
            iConfigurationElementArray = elements = extension.getConfigurationElements();
            n2 = elements.length;
            n = 0;
            while (n < n2) {
                element = iConfigurationElementArray[n];
                if (element.getName().equals(ELEMENT_MAPPING)) {
                    this.readMapping(element);
                }
                ++n;
            }
            ++n4;
        }
        this.bundleGroupById = null;
    }

    private ProductRepositoryMapping readMapping(IConfigurationElement element) {
        IConfigurationElement attributeElement;
        String namespace = element.getAttribute(ATTRIBUTE_NAMESPACE);
        String productId = element.getAttribute(ATTRIBUTE_PRODUCT_ID);
        HashMap<String, String> attributes = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ELEMENT_REPOSITORY);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            attributeElement = iConfigurationElementArray[n2];
            String repositoryUrl = attributeElement.getAttribute("url");
            attributes.put("repositoryUrl", repositoryUrl);
            String connectorKind = attributeElement.getAttribute(ATTRIBUTE_REPOSITORY_KIND);
            attributes.put("repositoryKind", connectorKind);
            ++n2;
        }
        iConfigurationElementArray = element.getChildren(ELEMENT_PROPERTY);
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            attributeElement = iConfigurationElementArray[n2];
            String name = attributeElement.getAttribute(ATTRIBUTE_NAME);
            String value = attributeElement.getAttribute(ATTRIBUTE_VALUE);
            attributes.put(name, value);
            ++n2;
        }
        if (!attributes.isEmpty()) {
            SupportProduct product;
            ProductRepositoryMapping mapping = new ProductRepositoryMapping(namespace);
            mapping.addAttributes(attributes);
            if (productId == null) {
                product = this.defaultProduct;
            } else {
                product = this.getProduct(productId);
                if (product == null) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Mapping contributed by {0} with namespace ''{1}'' ignored, invalid product id ''{1}'' specified", (Object[])new String[]{element.getNamespaceIdentifier(), namespace, productId})));
                    return null;
                }
            }
            product.addRepositoryMapping(mapping);
            return mapping;
        }
        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Mapping contributed by {0} with namespace ''{1}'' ignored, no attributes specified", (Object[])new String[]{element.getNamespaceIdentifier(), namespace})));
        return null;
    }

    private SupportProduct readProduct(IConfigurationElement element) {
        String id = element.getAttribute(ATTRIBUTE_ID);
        String providerId = element.getAttribute(ATTRIBUTE_PROVIDER_ID);
        SupportProvider provider = this.getProvider(providerId);
        if (provider == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Product contributed by {0} with id ''{1}'' ignored, product id ''{2}'' is invalid", (Object[])new String[]{element.getNamespaceIdentifier(), id, providerId})));
            return null;
        }
        boolean enabled = true;
        String pluginId = element.getAttribute(ATTRIBUTE_PLUGIN_ID);
        if (pluginId != null) {
            enabled &= Platform.getBundle((String)pluginId) != null;
        }
        SupportProduct product = new SupportProduct();
        product.setInstalled(enabled &= this.readAttributes(element, product));
        product.setProvider(provider);
        if (!this.addProduct(product)) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Product contributed by {0} ignored, id ''{1}'' already present", (Object)element.getNamespaceIdentifier(), (Object)id)));
            return null;
        }
        provider.add(product);
        this.productById.put(id, product);
        return product;
    }

    private SupportProvider readProvider(IConfigurationElement element) {
        String id = element.getAttribute(ATTRIBUTE_ID);
        SupportProvider provider = new SupportProvider();
        this.readAttributes(element, provider);
        if (!this.addProvider(provider)) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Provider contributed by {0} ignored, id ''{1}'' already present", (Object)element.getNamespaceIdentifier(), (Object)id)));
            return null;
        }
        String categoryId = element.getAttribute(ATTRIBUTE_CATEGORY_ID);
        SupportCategory category = this.getCategory(categoryId);
        if (category == null) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.bugs", NLS.bind((String)"Provider contributed by {0} ignored with id ''{1}'' ignored, category id ''{2}'' is invalid", (Object[])new String[]{element.getNamespaceIdentifier(), id, categoryId})));
            return null;
        }
        this.providerById.put(id, provider);
        category.add(provider);
        provider.setCategory(category);
        return provider;
    }
}

