/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.tasks.core.ITaskJobFactory;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;

public class TaskListSynchronizationScheduler
implements IUserAttentionListener {
    private static final boolean TRACE_ENABLED = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.tasks.ui/debug/synchronization"));
    private long interval;
    private long incactiveInterval;
    private final ITaskJobFactory jobFactory;
    private SynchronizationJob refreshJob;
    private boolean userActive;
    private long scheduledTime;
    private long lastSyncTime;
    private final JobChangeAdapter jobListener;

    public TaskListSynchronizationScheduler(ITaskJobFactory jobFactory) {
        this.jobFactory = jobFactory;
        this.userActive = true;
        this.jobListener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                TaskListSynchronizationScheduler.this.scheduledTime = 0L;
                TaskListSynchronizationScheduler.this.lastSyncTime = System.currentTimeMillis();
                TaskListSynchronizationScheduler.this.reschedule();
            }
        };
    }

    private SynchronizationJob createRefreshJob() {
        SynchronizationJob job = this.jobFactory.createSynchronizeRepositoriesJob(null);
        job.setSystem(true);
        job.setUser(false);
        job.setFullSynchronization(true);
        return job;
    }

    public synchronized SynchronizationJob getRefreshJob() {
        return this.refreshJob;
    }

    private synchronized void reschedule() {
        long delay = this.interval;
        if (delay != 0L) {
            if (!this.userActive) {
                this.incactiveInterval *= 3L;
                delay = this.incactiveInterval;
                if (TRACE_ENABLED) {
                    this.trace("Set inactive interval to " + DateUtil.getFormattedDurationShort((long)this.incactiveInterval));
                }
            }
            if (this.scheduledTime != 0L) {
                if (this.scheduledTime < System.currentTimeMillis() + delay) {
                    if (TRACE_ENABLED) {
                        this.trace("Synchronization already scheduled in " + DateUtil.getFormattedDurationShort((long)(this.scheduledTime - System.currentTimeMillis())));
                    }
                    return;
                }
                this.cancel();
            }
            this.schedule(delay);
        }
    }

    private synchronized void cancel() {
        if (TRACE_ENABLED) {
            this.trace("Canceling synchronization scheduled to run in " + DateUtil.getFormattedDurationShort((long)(this.scheduledTime - System.currentTimeMillis())));
        }
        this.refreshJob.removeJobChangeListener((IJobChangeListener)this.jobListener);
        this.refreshJob.cancel();
        this.refreshJob.addJobChangeListener((IJobChangeListener)this.jobListener);
    }

    private void schedule(long interval) {
        if (TRACE_ENABLED) {
            this.trace("Scheduling synchronization in " + DateUtil.getFormattedDurationShort((long)interval));
        }
        this.scheduledTime = System.currentTimeMillis() + interval;
        this.refreshJob.schedule(interval);
    }

    public synchronized void setInterval(long interval) {
        this.setInterval(interval, interval);
    }

    public synchronized void setInterval(long delay, long interval) {
        if (this.interval != interval) {
            this.interval = interval;
            this.incactiveInterval = interval;
            this.scheduledTime = 0L;
            if (this.refreshJob != null) {
                this.cancel();
                this.refreshJob.removeJobChangeListener((IJobChangeListener)this.jobListener);
                this.refreshJob = null;
            }
            if (interval > 0L) {
                this.refreshJob = this.createRefreshJob();
                this.refreshJob.addJobChangeListener((IJobChangeListener)this.jobListener);
                this.schedule(delay);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAttentionGained() {
        TaskListSynchronizationScheduler taskListSynchronizationScheduler = this;
        synchronized (taskListSynchronizationScheduler) {
            if (!this.userActive) {
                if (TRACE_ENABLED) {
                    this.trace("User activity detected");
                }
                this.userActive = true;
                this.incactiveInterval = this.interval;
                if (this.interval != 0L && System.currentTimeMillis() - this.lastSyncTime > this.interval) {
                    this.cancel();
                    this.schedule(0L);
                } else {
                    this.reschedule();
                }
            }
        }
    }

    private void trace(String message) {
        System.err.println("[" + new Date() + "] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userAttentionLost() {
        TaskListSynchronizationScheduler taskListSynchronizationScheduler = this;
        synchronized (taskListSynchronizationScheduler) {
            this.userActive = false;
        }
    }
}

