/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.confluence.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.confluence.core.ConfluenceLanguage;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.DocBookDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class ConfluenceLanguageTest
extends TestCase {
    private MarkupParser parser;

    public void setUp() throws Exception {
        super.setUp();
        this.initParser();
    }

    private void initParser() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new ConfluenceLanguage());
    }

    public void testIsDetectingRawHyperlinks() {
        ConfluenceLanguageTest.assertTrue((boolean)this.parser.getMarkupLanguage().isDetectingRawHyperlinks());
    }

    public void testParagraph() throws Exception {
        String html = this.parser.parseToHtml("a paragraph\n\nanother paragraph\nwith\n2 lines");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a paragraph</p><p>another paragraph<br/>\\s*with<br/>\\s*2 lines</p></body>", 8).matcher(html).find());
    }

    public void testHeadings() {
        int x = 1;
        while (x <= 6) {
            this.initParser();
            String html = this.parser.parseToHtml("h" + x + ". a heading\n\nwith a para");
            System.out.println("HTML:" + html);
            ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml("h" + x + ". a heading\nwith a para");
            System.out.println("HTML:" + html);
            ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            html = this.parser.parseToHtml("  h" + x + ". a heading\n\nwith a para");
            System.out.println("HTML:" + html);
            ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><h" + x + " id=\"aheading\">a heading</h" + x + "><p>with a para</p></body>", 8).matcher(html).find());
            ++x;
        }
    }

    public void testBlockQuote() {
        String html = this.parser.parseToHtml("bq. a multiline\nblock quote\n\nwith a para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p></blockquote><p>with a para</p></body>", 8).matcher(html).find());
    }

    public void testBlockQuoteExtended() {
        String html = this.parser.parseToHtml("{quote}\na multiline\nblock quote\n\nwith two paras\n{quote}\nanother para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p><p>with two paras</p></blockquote><p>another para</p></body>", 8).matcher(html).find());
    }

    public void testBlockQuoteExtended2() {
        String html = this.parser.parseToHtml("{quote}this is a quote{quote}\nsome more text");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><blockquote><p>this is a quote</p></blockquote><p>some more text</p></body>"));
    }

    public void testBlockQuoteExtendedUnclosed() {
        String html = this.parser.parseToHtml("{quote}\na multiline\nblock quote\n\nwith two paras\n");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><blockquote><p>a multiline<br/>\\s*block quote</p><p>with two paras</p></blockquote></body>", 8).matcher(html).find());
    }

    public void testBlockQuoteExtendedLeadingSpaces() {
        String html = this.parser.parseToHtml("     {quote}\na multiline\nblock quote\n    {quote}\nmore text");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><blockquote><p>a multiline<br/>block quote</p></blockquote><p>more text</p></body>"));
    }

    public void testBlockQuoteExtendedBreaksPara() {
        String html = this.parser.parseToHtml("a para\n{quote}quoted{quote}new para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a para</p><blockquote><p>quoted</p></blockquote><p>new para</p></body>"));
    }

    public void testBlockQuoteWithBulletedList() {
        String html = this.parser.parseToHtml("{quote}\ntext\n* a list\n* second item\nmore text\n{quote}\nanother para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><blockquote><p>text</p><ul><li>a list</li><li>second item</li></ul><p>more text</p></blockquote><p>another para</p></body>"));
    }

    public void testSimplePhraseModifiers() throws IOException {
        Object[][] pairs;
        Object[][] objectArrayArray = pairs = new Object[][]{{"*", "strong"}, {"_", "em"}, {"??", "cite"}, {"-", "del"}, {"+", "u"}, {"^", "sup"}, {"~", "sub"}};
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] pair = objectArrayArray[n2];
            this.initParser();
            String html = this.parser.parseToHtml("a paragraph with " + pair[0] + "content foo bar baz" + pair[0]);
            System.out.println("HTML: \n" + html);
            ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>a paragraph with <" + pair[1] + ">content foo bar baz</" + pair[1] + "></p>"));
            ++n2;
        }
    }

    public void testMonospaced() {
        String html = this.parser.parseToHtml("a paragraph with {{content foo bar baz}}");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>a paragraph with <tt>content foo bar baz</tt></p>"));
    }

    public void testLineBreak() {
        String html = this.parser.parseToHtml("a paragraph with an arbitrary\\\\line break");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<body><p>a paragraph with an arbitrary<br/>\\s*line break</p></body>", 8).matcher(html).find());
    }

    public void testEndash() {
        String html = this.parser.parseToHtml("an endash -- foo");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("endash &#8211; foo"));
    }

    public void testEmdash() {
        String html = this.parser.parseToHtml("an emdash --- foo");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("emdash &#8212; foo"));
    }

    public void testHorizontalRule() {
        String html = this.parser.parseToHtml("an hr ---- foo");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("hr <hr/> foo"));
    }

    public void testHorizontalRule2() {
        String html = this.parser.parseToHtml("---- an hr foo");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<hr/> an hr foo"));
    }

    public void testHorizontalRule3() {
        String html = this.parser.parseToHtml("an hr foo ----");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("an hr foo <hr/>"));
    }

    public void testHorizontalRule4() {
        String html = this.parser.parseToHtml("text\n----\nmore text");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<hr/>"));
    }

    public void testHyperlink() {
        String html = this.parser.parseToHtml("a [http://example.com] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    public void testHyperlinkPartiallyExpressed() {
        String html = this.parser.parseToHtml("a [ |] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a  hyperlink</p></body>"));
    }

    public void testHyperlinkWithTitle() {
        String html = this.parser.parseToHtml("a [Example|http://example.com] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example</a> hyperlink</p></body>"));
    }

    public void testHyperlinkWithTitle2() {
        String html = this.parser.parseToHtml("a [Example Two | http://example.com] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example Two</a> hyperlink</p></body>"));
    }

    public void testHyperlinkHash() {
        String html = this.parser.parseToHtml("a [Example|#example] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"#example\">Example</a> hyperlink</p></body>"));
    }

    public void testHyperlinkHash2() {
        String html = this.parser.parseToHtml("a [#example] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"#example\">example</a> hyperlink</p></body>"));
    }

    public void testHyperlinkWithTip() {
        String html = this.parser.parseToHtml("a [example | http://example.com | title is here] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\" title=\"title is here\">example</a> hyperlink</p></body>"));
    }

    public void testHyperlinkImplied() {
        String html = this.parser.parseToHtml("a http://example.com hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    public void testHyperlinkImpliedNegativeMatch() {
        String html = this.parser.parseToHtml("a http://example.com. hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a>. hyperlink</p></body>"));
    }

    public void testHyperlinkImpliedNegativeMatch2() {
        String html = this.parser.parseToHtml("a http://example.com) hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a>) hyperlink</p></body>"));
    }

    public void testHyperlinkWithSpaces() {
        String html = this.parser.parseToHtml("a [ http://example.com ] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">http://example.com</a> hyperlink</p></body>"));
    }

    public void testHyperlinkWithTitleAndSpace() {
        String html = this.parser.parseToHtml("a [Example Two | http://example.com ] hyperlink");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <a href=\"http://example.com\">Example Two</a> hyperlink</p></body>"));
    }

    public void testHyperlinkMailtoNoBase() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setBase(null);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("[test|mailto:foo@bar.com]");
        System.out.println(out.toString());
        ConfluenceLanguageTest.assertTrue((boolean)out.toString().contains("<a href=\"mailto:foo@bar.com\">test</a>"));
    }

    public void testHyperlinkMailtoWithBase() throws URISyntaxException {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setBase(new URI("/"));
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("[test|mailto:foo@bar.com]");
        System.out.println(out.toString());
        ConfluenceLanguageTest.assertTrue((boolean)out.toString().contains("<a href=\"mailto:foo@bar.com\">test</a>"));
    }

    public void testNamedAnchor() {
        String html = this.parser.parseToHtml("a {anchor:a23423} named anchor");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a <span id=\"a23423\"></span> named anchor</p></body>"));
    }

    public void testListUnordered() throws IOException {
        String html = this.parser.parseToHtml("* a list\n* with two lines");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ul>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>a list</li>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</ul>"));
    }

    public void testListOrdered() throws IOException {
        String html = this.parser.parseToHtml("# a list\n# with two lines");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>a list</li>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListNested() throws IOException {
        String html = this.parser.parseToHtml("# a list\n## nested\n## nested2\n# level1\n\npara");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ol>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>a list"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<li>nested"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</ol>"));
    }

    public void testListMixed() throws IOException {
        String html = this.parser.parseToHtml("# first\n* second");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ol><li>first</li></ol><ul><li>second</li></ul>"));
    }

    public void testListNestedMixed() throws IOException {
        String html = this.parser.parseToHtml("# a list\n#* nested\n#* nested2\n# level1\n\npara");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ol><li>a list<ul><li>nested</li><li>nested2</li></ul></li><li>level1</li></ol>"));
    }

    public void testListWithHrPattern() throws IOException {
        String html = this.parser.parseToHtml("- first\n-- second\n--- third\n---- fourth");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<ul style=\"list-style: square\"><li>first<ul><li>second<ul><li>third<ul><li>fourth</li></ul></li></ul></li></ul></li></ul>"));
    }

    public void testImage() {
        String html = this.parser.parseToHtml("an !image.png! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithFullUrl() {
        String html = this.parser.parseToHtml("an !http://www.foo.com/bin/image.png! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"http://www.foo.com/bin/image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesAlignRight() {
        String html = this.parser.parseToHtml("an !image.png|align=right! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img align=\"right\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesAlignLeft() {
        String html = this.parser.parseToHtml("an !image.png|align=left! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img align=\"left\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesAlignMiddle() {
        String html = this.parser.parseToHtml("an !image.png|align=middle! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img align=\"middle\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesAlignCenter() {
        String html = this.parser.parseToHtml("an !image.png|align=center! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img align=\"center\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesAlt() {
        String html = this.parser.parseToHtml("an !image.png|alt= some alt text! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img alt=\"some alt text\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesBorder() {
        String html = this.parser.parseToHtml("an !image.png|border=5! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img border=\"5\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesWidth() {
        String html = this.parser.parseToHtml("an !image.png|width=5! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img width=\"5\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesHeight() {
        String html = this.parser.parseToHtml("an !image.png|height=5! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img height=\"5\" border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageWithAttributesHeightBadValue() {
        String html = this.parser.parseToHtml("an !image.png|height=5a! image");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>an <img border=\"0\" src=\"image.png\"/> image</p></body>"));
    }

    public void testImageNegativeMatch() {
        String html = this.parser.parseToHtml("I really like ice cream! Yay!");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>I really like ice cream! Yay!</p></body>"));
    }

    public void testTable() {
        String html = this.parser.parseToHtml("|a|row|not header|");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td>a</td><td>row</td><td>not header</td></tr></table></body>"));
    }

    public void testTableWithHeader() {
        String html = this.parser.parseToHtml("||a||header||row||\n|a|row|not header|");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><th>a</th><th>header</th><th>row</th></tr><tr><td>a</td><td>row</td><td>not header</td></tr></table></body>"));
    }

    public void testTableNestedWithHeader() {
        String html = this.parser.parseToHtml("a para\n||a||header||row||\n|a|row|not header|\ntail");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a para</p><table><tr><th>a</th><th>header</th><th>row</th></tr><tr><td>a</td><td>row</td><td>not header</td></tr></table><p>tail</p></body>"));
    }

    public void testTableWithLinkAndPipes() {
        String html = this.parser.parseToHtml("| [Website|https://textile-j.dev.java.net/] |");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td> <a href=\"https://textile-j.dev.java.net/\">Website</a> </td></tr></table></body>"));
    }

    public void testTableWithLinkAndPipes2() {
        String html = this.parser.parseToHtml("| [Website|https://textile-j.dev.java.net/] | another cell | [Eclipse|http://www.eclipse.org] |");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><table><tr><td> <a href=\"https://textile-j.dev.java.net/\">Website</a> </td><td> another cell </td><td> <a href=\"http://www.eclipse.org\">Eclipse</a> </td></tr></table></body>"));
    }

    public void testPreformattedExtended() {
        String html = this.parser.parseToHtml("{noformat}\na multiline\n\tpreformatted\n\nwith two paras\n{noformat}\nanother para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("body><pre>a multiline\\s+preformatted\\s+with two paras\\s+</pre><p>another para</p></body>", 8).matcher(html).find());
    }

    public void testPreformattedExtended2() {
        String html = this.parser.parseToHtml("{noformat}\na multiline\n\tpreformatted\n\nwith two paras{noformat}another para");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><pre>a multiline"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</pre><p>another para</p></body>"));
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("with two paras\\s*</pre>", 8).matcher(html).find());
    }

    public void testBlockCode() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{code:language=Java}\npublic class Foo {\n}\n{code}\nMore text...");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)Pattern.compile("<p>Some text</p><pre><code>", 8).matcher(html).find());
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<code>\npublic class Foo {\n"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</code></pre><p>More text...</p>"));
    }

    public void testBlockCode2() {
        String html = this.parser.parseToHtml("{code}some code{code}more text");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><pre><code>some code"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</code></pre><p>more text</p></body>"));
    }

    public void testBlockCodeJava() {
        String html = this.parser.parseToHtml("{code:Java}some code{code}more text");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><pre><code class=\"java code-java\">some code"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</code></pre><p>more text</p></body>"));
    }

    public void testNote() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{note:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{note}\nMore text...");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"note\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        ConfluenceLanguageTest.assertFalse((boolean)html.contains("{note"));
    }

    public void testNote2() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("{note}this is a note {note}\n\n* one thing\n* two things");
        String html = out.toString();
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>this is a note </p></div><ul><li>one thing</li><li>two things</li></ul></body>"));
    }

    public void testNote3() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("{note}this is a note {note}*bold* text\nfoo\n\nbar");
        String html = out.toString();
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>this is a note </p></div><p><strong>bold</strong> text<br/>foo</p><p>bar</p></body>"));
    }

    public void testNote4() {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("abc{note}this is a note {note}*bold* text\nfoo\n\nbar");
        String html = out.toString();
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>abc</p><div class=\"note\"><p>this is a note </p></div><p><strong>bold</strong> text<br/>foo</p><p>bar</p></body>"));
    }

    public void testInfo() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{info:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{info}\nMore text...");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"info\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        ConfluenceLanguageTest.assertFalse((boolean)html.contains("{info"));
    }

    public void testWarning() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{warning:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{warning}\nMore text...");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"warning\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        ConfluenceLanguageTest.assertFalse((boolean)html.contains("{warning"));
    }

    public void testTip() {
        String html = this.parser.parseToHtml("h1. a header\n\nSome text\n{tip:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{tip}\nMore text...");
        System.out.println("HTML:" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<p>Some text</p><div class=\"tip\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("</p></div><p>More text...</p>"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("or <strong>other</strong> <em>textile</em> <cite>markup</cite>"));
        ConfluenceLanguageTest.assertFalse((boolean)html.contains("{tip"));
    }

    public void testTipToDocBook() {
        StringWriter out = new StringWriter();
        this.parser.setBuilder((DocumentBuilder)new DocBookDocumentBuilder((Writer)out));
        this.parser.parse("h1. a header\n\nSome text\n{tip:title=A Title}\nthe body of the note\nwhich may span multiple lines\n\nAnd may even have multiple paragraphs or *other* _textile_ ??markup??\n{tip}\nMore text...");
        String docbook = out.toString();
        System.out.println("DocBook: " + docbook);
        ConfluenceLanguageTest.assertTrue((boolean)docbook.contains("<tip><title>A Title</title><para>the body of"));
        ConfluenceLanguageTest.assertTrue((boolean)docbook.contains("paragraphs or <emphasis role=\"bold\">other</emphasis> <emphasis>textile</emphasis> <citation>markup</citation></para></tip>"));
    }

    public void testTableOfContents() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("href=\"#Subhead4\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    public void testTableOfContentsWithMaxLevel() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc:maxLevel=2}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        System.out.println("HTML: \n" + html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        ConfluenceLanguageTest.assertFalse((boolean)html.contains("href=\"#Subhead4\""));
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    public void testBoldItalicsBold() {
        String html = this.parser.parseToHtml("*bold _ital ics_ bold*");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<strong>bold <em>ital ics</em> bold</strong>"));
    }

    public void testItalicsBold() {
        String html = this.parser.parseToHtml("_italics *bol d* italics_");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<em>italics <strong>bol d</strong> italics</em>"));
    }

    public void testBoldItalics() {
        String html = this.parser.parseToHtml("*_bold and italic_ not just bold*");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<strong><em>bold and italic</em> not just bold</strong>"));
    }

    public void testInlineQuote() {
        String html = this.parser.parseToHtml("a paragraph {quote}with inline{quote} quote");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a paragraph <q>with inline</q> quote</p></body>"));
    }

    public void testInlineQuoteWithBullets() {
        String html = this.parser.parseToHtml("* a bullet {quote}with inline{quote} quote");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><ul><li>a bullet <q>with inline</q> quote</li></ul></body>"));
    }

    public void testInlineQuoteWithBullets2() {
        String html = this.parser.parseToHtml("* {quote}a bullet with inline{quote} quote");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><ul><li><q>a bullet with inline</q> quote</li></ul></body>"));
    }

    public void testInlineQuoteNegativeMatch() {
        String html = this.parser.parseToHtml("a paragraph {quote}with inline quote");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>a paragraph {quote}with inline quote</p></body>"));
    }

    public void testInlineQuoteNegativeMatch2() {
        String html = this.parser.parseToHtml("{quote}a paragraph with {quote}inline quote{quote}");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><blockquote><p>a paragraph with </p></blockquote><p>inline quote{quote}</p></body>"));
    }

    public void testColor() {
        String html = this.parser.parseToHtml("{color:red}\na paragraph\n\nanother paragraph\n{color}\ntext");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><div style=\"color: red;\"><p>a paragraph</p><p>another paragraph</p></div><p>text</p></body>"));
    }

    public void testColor2() {
        String html = this.parser.parseToHtml("{color:red}a paragraph\n\nanother paragraph{color}text");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><div style=\"color: red;\"><p>a paragraph</p><p>another paragraph</p></div><p>text</p></body>"));
    }

    public void testColor3() {
        String html = this.parser.parseToHtml("text {color:red}more text{color} text");
        System.out.println(html);
        ConfluenceLanguageTest.assertTrue((boolean)html.contains("<body><p>text </p><div style=\"color: red;\"><p>more text</p></div><p> text</p></body>"));
    }
}

