/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class HtmlDocumentBuilderTest
extends TestCase {
    private MarkupParser parser;
    private StringWriter out;
    private HtmlDocumentBuilder builder;
    private final Map<File, URL> fileToUrl = new HashMap<File, URL>();

    public void setUp() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        this.builder = new HtmlDocumentBuilder(this.out){

            protected void checkFileReadable(File file) {
                if (!HtmlDocumentBuilderTest.this.fileToUrl.containsKey(file)) {
                    super.checkFileReadable(file);
                }
            }

            protected Reader getReader(File inputFile) throws FileNotFoundException {
                URL url = (URL)HtmlDocumentBuilderTest.this.fileToUrl.get(inputFile);
                if (url != null) {
                    try {
                        return new InputStreamReader(url.openStream());
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException(String.format("%s (%s)", inputFile, url));
                    }
                }
                return super.getReader(inputFile);
            }
        };
        this.parser.setBuilder((DocumentBuilder)this.builder);
    }

    public void testRelativeUrlWithBase() throws URISyntaxException {
        this.builder.setBase(new URI("http://www.foo.bar/baz"));
        this.parser.parse("\"An URL\":foo/bar.html");
        String html = this.out.toString();
        System.out.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar/baz/foo/bar.html\">An URL</a>"));
    }

    public void testAbsoluteUrlWithBase() throws URISyntaxException {
        this.builder.setBase(new URI("http://www.foo.bar/baz"));
        this.parser.parse("\"An URL\":http://www.baz.ca/foo/bar.html");
        String html = this.out.toString();
        System.out.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.baz.ca/foo/bar.html\">An URL</a>"));
    }

    public void testRelativeUrlWithFileBase() throws URISyntaxException {
        this.builder.setBase(new File("/base/2/with space/").toURI());
        this.parser.parse("\"An URL\":foo/bar.html");
        String html = this.out.toString();
        System.out.println("HTML: \n" + html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"file:/base/2/with%20space/foo/bar.html\">An URL</a>"));
    }

    public void testNoGratuitousWhitespace() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("some para text");
        this.builder.lineBreak();
        this.builder.characters("more para text");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("second para");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((html.indexOf(13) == -1 ? 1 : 0) != 0);
        HtmlDocumentBuilderTest.assertTrue((html.indexOf(10) == -1 ? 1 : 0) != 0);
        HtmlDocumentBuilderTest.assertEquals((String)"<?xml version='1.0' encoding='utf-8' ?><html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/></head><body><p>some para text<br/>more para text</p><p>second para</p></body></html>", (String)html);
    }

    public void testCssStylesheetAsLink() {
        this.builder.addCssStylesheet(new HtmlDocumentBuilder.Stylesheet("styles/test.css"));
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("some para text");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/><link type=\"text/css\" rel=\"stylesheet\" href=\"styles/test.css\"/></head>"));
    }

    public void testCssStylesheetEmbedded() throws Exception {
        URL cssResource = HtmlDocumentBuilderTest.class.getResource("resources/test.css");
        File cssFile = new File(cssResource.toURI().getPath());
        this.fileToUrl.put(cssFile, cssResource);
        System.out.println("loading css: " + cssFile);
        this.builder.addCssStylesheet(new HtmlDocumentBuilder.Stylesheet(cssFile));
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("some para text");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/><style type=\"text/css\">\\s*body\\s+\\{\\s+background-image: test-content.png;\\s+\\}\\s*</style></head>", 8).matcher(html).find());
    }

    public void testDefaultTargetForExternalLinks() throws Exception {
        this.builder.setDefaultAbsoluteLinkTarget("_external");
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.link("http://www.example.com", "test");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.example.com\" target=\"_external\">test</a>"));
    }

    public void testDefaultTargetForExternalLinks2() throws Exception {
        this.builder.setBase(new URI("http://www.notexample.com"));
        this.builder.setDefaultAbsoluteLinkTarget("_external");
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.link("http://www.example.com", "test");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.example.com\" target=\"_external\">test</a>"));
    }

    public void testDefaultTargetForInternalLinks() throws Exception {
        this.builder.setDefaultAbsoluteLinkTarget("_external");
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.link("foo", "test");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"foo\">test</a>"));
    }

    public void testDefaultTargetForInternalLinks2() throws Exception {
        this.builder.setBase(new URI("http://www.example.com/"));
        this.builder.setDefaultAbsoluteLinkTarget("_external");
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.link("http://www.example.com/foo.html", "test");
        this.builder.endBlock();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.example.com/foo.html\">test</a>"));
    }

    public void testSuppressInlineStyles() throws Exception {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setUseInlineStyles(false);
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.NOTE, new Attributes());
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        builder.characters("foo");
        builder.endBlock();
        builder.endBlock();
        builder.endDocument();
        String html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>foo</p></div></body>"));
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<style type=\"text/css\">"));
    }

    public void testSuppressBuiltInlineStyles() throws Exception {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.setSuppressBuiltInStyles(true);
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.NOTE, new Attributes());
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        builder.characters("foo");
        builder.endBlock();
        builder.endBlock();
        builder.endDocument();
        String html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<body><div class=\"note\"><p>foo</p></div></body>"));
        HtmlDocumentBuilderTest.assertTrue((!html.contains("<style type=\"text/css\">") ? 1 : 0) != 0);
    }

    public void testLinkRel() throws Exception {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)out);
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        LinkAttributes attributes = new LinkAttributes();
        attributes.setRel("nofollow");
        builder.link((Attributes)attributes, "http://www.foo.bar", "Foo Bar");
        builder.endBlock();
        builder.endDocument();
        String html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar\" rel=\"nofollow\">Foo Bar</a>"));
        out = new StringWriter();
        builder = new HtmlDocumentBuilder((Writer)out);
        builder.setLinkRel("nofollow");
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        attributes = new LinkAttributes();
        builder.link((Attributes)attributes, "http://www.foo.bar", "Foo Bar");
        builder.endBlock();
        builder.endDocument();
        html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar\" rel=\"nofollow\">Foo Bar</a>"));
        out = new StringWriter();
        builder = new HtmlDocumentBuilder((Writer)out);
        builder.setLinkRel("nofollow");
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        attributes = new LinkAttributes();
        attributes.setRel("foobar");
        builder.link((Attributes)attributes, "http://www.foo.bar", "Foo Bar");
        builder.endBlock();
        builder.endDocument();
        html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar\" rel=\"foobar nofollow\">Foo Bar</a>"));
        out = new StringWriter();
        builder = new HtmlDocumentBuilder((Writer)out);
        builder.beginDocument();
        builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        attributes = new LinkAttributes();
        builder.link((Attributes)attributes, "http://www.foo.bar", "Foo Bar");
        builder.endBlock();
        builder.endDocument();
        html = out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<a href=\"http://www.foo.bar\">Foo Bar</a>"));
    }

    public void testStylesheetWithAttributes() {
        HtmlDocumentBuilder.Stylesheet stylesheet = new HtmlDocumentBuilder.Stylesheet("a/test.css");
        stylesheet.getAttributes().put("foo", "bar");
        this.builder.addCssStylesheet(stylesheet);
        this.builder.beginDocument();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<link type=\"text/css\" rel=\"stylesheet\" href=\"a/test.css\" foo=\"bar\"/>"));
    }

    public void testStylesheetWithNoAttributes() {
        this.builder.addCssStylesheet(new HtmlDocumentBuilder.Stylesheet("a/test.css"));
        this.builder.beginDocument();
        this.builder.endDocument();
        String html = this.out.toString();
        System.out.println(html);
        HtmlDocumentBuilderTest.assertTrue((boolean)html.contains("<link type=\"text/css\" rel=\"stylesheet\" href=\"a/test.css\"/>"));
    }
}

