/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.tests;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.FactoryConfigurationError;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToDocbook;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewer;
import org.eclipse.mylyn.wikitext.ui.viewer.MarkupViewerConfiguration;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTestApplication {
    private boolean dirty;
    private Browser browser;
    private MarkupViewer viewer;
    private String markup;
    private TextViewer htmlSourceViewer;
    private TextViewer docbookSourceViewer;

    protected void doMain() throws IOException {
        this.markup = "";
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        CTabFolder folder = new CTabFolder((Composite)shell, 2048);
        this.createWikiTextViewer(folder);
        this.createBrowser(folder);
        this.createMarkupSourceViewer(folder);
        this.createHtmlSourceViewer(folder);
        this.createDocbookSourceViewer(folder);
        this.updateDependentViewers();
        folder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
                this.widgetSelected(selectionevent);
            }

            public void widgetSelected(SelectionEvent selectionevent) {
                if (AbstractTestApplication.this.dirty) {
                    AbstractTestApplication.this.updateViewers();
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void createHtmlSourceViewer(CTabFolder folder) {
        CTabItem viewerItem = new CTabItem(folder, 0);
        viewerItem.setText("HTML Source");
        this.htmlSourceViewer = new TextViewer((Composite)folder, 840);
        Document document = new Document("");
        this.htmlSourceViewer.setDocument((IDocument)document);
        viewerItem.setControl(this.htmlSourceViewer.getControl());
    }

    private void createDocbookSourceViewer(CTabFolder folder) {
        CTabItem viewerItem = new CTabItem(folder, 0);
        viewerItem.setText("DocBook Source");
        this.docbookSourceViewer = new TextViewer((Composite)folder, 840);
        Document document = new Document("");
        this.docbookSourceViewer.setDocument((IDocument)document);
        viewerItem.setControl(this.docbookSourceViewer.getControl());
    }

    private void createMarkupSourceViewer(CTabFolder folder) {
        CTabItem viewerItem = new CTabItem(folder, 0);
        viewerItem.setText(String.valueOf(this.createMarkupLanguage().getName()) + " Source");
        TextViewer viewer = new TextViewer((Composite)folder, 832);
        Document document = new Document(this.markup);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                AbstractTestApplication.this.dirty = true;
                AbstractTestApplication.this.markup = event.getDocument().get();
            }
        });
        viewer.setDocument((IDocument)document);
        viewerItem.setControl(viewer.getControl());
    }

    private void createBrowser(CTabFolder folder) {
        CTabItem viewerItem = new CTabItem(folder, 0);
        viewerItem.setText("Browser");
        this.browser = new Browser((Composite)folder, 0);
        viewerItem.setControl((Control)this.browser);
    }

    private void updateDependentViewers() {
        String docbook;
        MarkupParser parser = new MarkupParser();
        parser.setMarkupLanguage(this.createMarkupLanguage());
        Object html = new StringWriter();
        try {
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)html);
            parser.setBuilder((DocumentBuilder)builder);
            parser.parse(this.markup);
        }
        catch (FactoryConfigurationError e1) {
            throw new IllegalStateException(e1);
        }
        this.htmlSourceViewer.getDocument().set(((StringWriter)html).toString());
        MarkupToDocbook markupToDocbook = new MarkupToDocbook();
        markupToDocbook.setMarkupLanguage(this.createMarkupLanguage());
        markupToDocbook.setBookTitle("Book");
        try {
            docbook = markupToDocbook.parse(this.markup);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.docbookSourceViewer.getDocument().set(docbook);
        parser = new MarkupParser();
        parser.setMarkupLanguage(this.createMarkupLanguage());
        html = parser.parseToHtml(this.markup);
        this.browser.setText((String)html);
    }

    protected abstract MarkupLanguage createMarkupLanguage();

    private void createWikiTextViewer(CTabFolder folder) {
        CTabItem viewerItem = new CTabItem(folder, 0);
        viewerItem.setText("WikiText Viewer");
        this.viewer = new MarkupViewer((Composite)folder, null, 578);
        this.viewer.setMarkupLanguage(this.createMarkupLanguage());
        MarkupViewerConfiguration configuration = new MarkupViewerConfiguration(this.viewer);
        this.viewer.configure((SourceViewerConfiguration)configuration);
        this.viewer.getTextWidget().setEditable(false);
        this.viewer.setMarkup(this.markup);
        viewerItem.setControl(this.viewer.getControl());
        this.viewer.getTextWidget().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int offset = e.x;
                ArrayList<String> annotations = new ArrayList<String>();
                Iterator it = AbstractTestApplication.this.viewer.getAnnotationModel().getAnnotationIterator();
                while (it.hasNext()) {
                    Annotation annotation = (Annotation)it.next();
                    Position position = AbstractTestApplication.this.viewer.getAnnotationModel().getPosition(annotation);
                    if (Math.abs(position.getOffset() - offset) >= 5) continue;
                    annotations.add(String.format("[%s,%s] %s %s", position.getOffset(), position.getLength(), position.getOffset() - offset, annotation.getType()));
                }
                System.out.println("offset: " + offset + " annotations: " + annotations);
            }
        });
    }

    protected void updateViewers() {
        this.viewer.setMarkup(this.markup);
        this.updateDependentViewers();
        this.dirty = false;
    }
}

