/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.MonitoredRequest;
import org.eclipse.mylyn.internal.commons.net.TrustAllTrustManager;

public class PollingSslProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final String KEY_STORE = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private final boolean hasKeyManager;
    private SSLSocketFactory socketFactory;

    public PollingSslProtocolSocketFactory() {
        KeyManager[] keymanagers = null;
        if (System.getProperty(KEY_STORE) != null && System.getProperty(KEY_STORE_PASSWORD) != null) {
            try {
                String type = System.getProperty(KEY_STORE_TYPE, KeyStore.getDefaultType());
                KeyStore keyStore = KeyStore.getInstance(type);
                char[] password = System.getProperty(KEY_STORE_PASSWORD).toCharArray();
                keyStore.load(new FileInputStream(System.getProperty(KEY_STORE)), password);
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, password);
                keymanagers = keyManagerFactory.getKeyManagers();
            }
            catch (Exception e) {
                CommonsNetPlugin.log(4, "Could not initialize keystore", e);
            }
        }
        this.hasKeyManager = keymanagers != null;
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(keymanagers, new TrustManager[]{new TrustAllTrustManager()}, null);
            this.socketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            CommonsNetPlugin.log(4, "Could not initialize SSL context", e);
        }
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
        return this.getSocketFactory().createSocket(remoteHost, remotePort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        Socket socket = this.getSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(localAddress, localPort));
        MonitoredRequest.connect(socket, new InetSocketAddress(host, port), timeout);
        return socket;
    }

    public SSLSocketFactory getSocketFactory() throws IOException {
        if (this.socketFactory == null) {
            throw new IOException("Could not initialize SSL context");
        }
        return this.socketFactory;
    }

    public boolean hasKeyManager() {
        return this.hasKeyManager;
    }
}

