/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventSummarySorter;
import org.eclipse.mylyn.internal.monitor.usage.MonitorFileRolloverJob;
import org.eclipse.mylyn.internal.monitor.usage.ReportGenerator;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountContentProvider;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountLabelProvider;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountStudyParamtersFilter;
import org.eclipse.mylyn.internal.monitor.usage.editors.Messages;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageSubmissionWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class UsageDataOverviewPage
extends WizardPage {
    private ReportGenerator reportGenerator;
    private Table table;
    private TableViewer tableViewer;
    private final String[] columnNames = new String[]{Messages.UsageSummaryReportEditorPart_Kind, Messages.UsageSummaryReportEditorPart_Id, Messages.UsageSummaryReportEditorPart_Count};
    private final StudyParameters studyParameters;
    private final UsageSubmissionWizard wizard;

    public UsageDataOverviewPage(UsageSubmissionWizard wizard, StudyParameters studyParameters) {
        super(Messages.UsageDataOverviewPage_Review_Usage_Data);
        this.setTitle(Messages.UsageDataOverviewPage_Review_Usage_Data);
        this.setDescription(NLS.bind((String)Messages.UsageDataOverviewPage_Please_Review_Data_Submitted_To_X, (Object)studyParameters.getStudyName()));
        this.studyParameters = studyParameters;
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData wd = new GridData(1808);
        container.setLayoutData((Object)wd);
        this.createTable(container);
        this.createTableViewer();
        this.setControl((Control)container);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            try {
                this.getContainer().run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        UsageDataOverviewPage.this.displayUsageData(monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e.getMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void createTable(Composite parent) {
        int style = 101124;
        this.table = new Table(parent, style);
        TableLayout tlayout = new TableLayout();
        this.table.setLayout((Layout)tlayout);
        GridData wd = new GridData(1808);
        this.table.setLayoutData((Object)wd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(this.columnNames[0]);
        column.setWidth(60);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataOverviewPage.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText(this.columnNames[1]);
        column.setWidth(370);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataOverviewPage.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(3));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText(this.columnNames[2]);
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataOverviewPage.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(4));
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setContentProvider((IContentProvider)new UsageCountContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new UsageCountLabelProvider());
        this.tableViewer.addFilter((ViewerFilter)new UsageCountStudyParamtersFilter(this.studyParameters));
        this.tableViewer.setInput(null);
    }

    private void displayUsageData(IProgressMonitor monitor) {
        ArrayList<IUsageCollector> collectors = new ArrayList<IUsageCollector>();
        this.reportGenerator = new ReportGenerator(UiUsageMonitorPlugin.getDefault().getInteractionLogger(), collectors);
        ArrayList<File> files = new ArrayList<File>();
        File monitorFile = UiUsageMonitorPlugin.getDefault().getMonitorLogFile();
        files.add(monitorFile);
        List<String> backupFilesToUpload = this.wizard.getBackupFilesToUpload();
        if (backupFilesToUpload != null && backupFilesToUpload.size() > 0) {
            for (String currFilePath : backupFilesToUpload) {
                File file = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath(), currFilePath);
                if (!file.exists()) continue;
                try {
                    List unzippedFiles = ZipFileUtil.unzipFiles((File)file, (String)System.getProperty("java.io.tmpdir"), (IProgressMonitor)new NullProgressMonitor());
                    if (unzippedFiles.size() <= 0) continue;
                    for (File f : unzippedFiles) {
                        files.add(f);
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Error unzipping backup monitor log files", (Throwable)e));
                }
            }
        }
        this.reportGenerator.getStatisticsFromInteractionHistories(files, monitor);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UsageDataOverviewPage.this.tableViewer.setInput((Object)UsageDataOverviewPage.this.reportGenerator);
            }
        });
    }
}

