/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDescriptor;
import org.eclipse.mylyn.internal.discovery.ui.PrepareInstallProfileJob;
import org.eclipse.mylyn.internal.discovery.ui.wizards.Messages;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiscoveryUi {
    public static final String ID_PLUGIN = "org.eclipse.mylyn.discovery.ui";

    private DiscoveryUi() {
    }

    public static boolean install(List<ConnectorDescriptor> descriptors, IRunnableContext context) {
        try {
            PrepareInstallProfileJob runner = null;
            Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.engine");
            if (bundle != null && new VersionRange("[1.0.0,1.1.0)").isIncluded(bundle.getVersion())) {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.mylyn.internal.discovery.ui.PrepareInstallProfileJob_e_3_5");
                    Constructor<?> c = clazz.getConstructor(List.class);
                    runner = (IRunnableWithProgress)c.newInstance(descriptors);
                }
                catch (Throwable t) {
                    StatusHandler.log((IStatus)new Status(4, ID_PLUGIN, "Errors occured while initializing provisioning framework, falling back to default implementation. This make cause discovery install to fail.", t));
                }
            }
            if (runner == null) {
                runner = new PrepareInstallProfileJob(descriptors);
            }
            context.run(true, true, (IRunnableWithProgress)runner);
        }
        catch (InvocationTargetException e) {
            Status status = new Status(4, ID_PLUGIN, NLS.bind((String)Messages.ConnectorDiscoveryWizard_installProblems, (Object[])new Object[]{e.getCause().getMessage()}), e.getCause());
            StatusManager.getManager().handle((IStatus)status, 7);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

