/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.builder;

import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DitaTopicDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class DitaTopicDocumentBuilderTest
extends TestCase {
    private MarkupParser parser;
    private StringWriter out;
    private DitaTopicDocumentBuilder builder;

    public void setUp() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        this.builder = new DitaTopicDocumentBuilder((Writer)this.out);
        this.parser.setBuilder((DocumentBuilder)this.builder);
    }

    public void testDiv() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("foo");
        this.builder.endBlock();
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        this.builder.characters("bar");
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String dita = this.out.toString();
        System.out.println("DITA: \n" + dita);
        DitaTopicDocumentBuilderTest.assertTrue((boolean)Pattern.compile(".*?<topic>\\s*<title></title>\\s*<body>\\s*<p>foo</p>\\s*<p>bar</p>\\s*</body>.*", 32).matcher(dita).matches());
    }

    public void testNoFormatting() {
        this.parser = new MarkupParser();
        this.parser.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
        this.out = new StringWriter();
        DefaultXmlStreamWriter xmlStreamWriter = new DefaultXmlStreamWriter((Writer)this.out);
        this.builder = new DitaTopicDocumentBuilder((XmlStreamWriter)xmlStreamWriter, false);
        this.parser.setBuilder((DocumentBuilder)this.builder);
        this.parser.parse("h1. Title1\n\nsome content in a para");
        xmlStreamWriter.close();
        String dita = this.out.toString();
        System.out.println("DITA: \n" + dita);
        DitaTopicDocumentBuilderTest.assertTrue((boolean)dita.contains("<topic id=\"Title1\"><title>Title1</title><body><p>some content in a para</p></body></topic>"));
    }

    public void testSpanLink() {
        this.builder.beginDocument();
        this.builder.beginBlock(DocumentBuilder.BlockType.DIV, new Attributes());
        this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        LinkAttributes attributes = new LinkAttributes();
        attributes.setHref("#test1234");
        this.builder.beginSpan(DocumentBuilder.SpanType.LINK, (Attributes)attributes);
        this.builder.beginSpan(DocumentBuilder.SpanType.EMPHASIS, new Attributes());
        this.builder.characters("link text");
        this.builder.endSpan();
        this.builder.endSpan();
        this.builder.endBlock();
        this.builder.endBlock();
        this.builder.endDocument();
        String dita = this.out.toString();
        System.out.println("DITA: \n" + dita);
        DitaTopicDocumentBuilderTest.assertTrue((boolean)Pattern.compile("<xref href=\"#test1234\">\\s*<i>link text</i>\\s*</xref>").matcher(dita).find());
    }
}

