/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.wikitext.textile.core.Textile;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;

public class TextileTest
extends TestCase {
    public void testExplicitHeaderStartsNewBlock() {
        int x = 1;
        while (x <= 6) {
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("h" + x + ". "), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("h" + x + ". asfsdfds"), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("h" + x + "(#id-foo). "), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)("h" + x + "."), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)(" h" + x + ". "), (int)1));
            ++x;
        }
    }

    public void testExplicitFootnoteStartsNewBlock() {
        int x = 0;
        while (x <= 9) {
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("fn" + x + ". "), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("fn" + x + x + ". "), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)("fn" + x + ". asfsdfds"), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)("fn" + x + "."), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)("fn" + x + x + "."), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)(" fn" + x + ". "), (int)1));
            ++x;
        }
    }

    public void testExplicitOtherStartsNewBlock() {
        String[] types;
        String[] stringArray = types = new String[]{"pre", "bc", "bq", "p", "table"};
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + ". "), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + ". asfsdfds"), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + ".. "), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + ".. asfsdfds"), (int)0));
            TextileTest.assertTrue((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + "(cssClass). "), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)(String.valueOf(type) + "."), (int)0));
            TextileTest.assertFalse((boolean)Textile.explicitBlockBegins((String)(" " + type + ". "), (int)1));
            ++n2;
        }
    }

    public void testAttributes() {
        Pattern pattern = Pattern.compile("(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}");
        String[] values = new String[]{"(someClass)", "(#someId)", "{someStyle}", "[someLanguage]", "(someClass)(#someId){someStyle}", "{someStyle}(someClass)(#someId)"};
        String[][] stringArrayArray = new String[6][];
        String[] stringArray = new String[5];
        stringArray[1] = "someClass";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[5];
        stringArray2[2] = "someId";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[3] = "someStyle";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[5];
        stringArray4[4] = "someLanguage";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[5];
        stringArray5[1] = "someClass";
        stringArray5[2] = "someId";
        stringArray5[3] = "someStyle";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[5];
        stringArray6[1] = "someClass";
        stringArray6[2] = "someId";
        stringArray6[3] = "someStyle";
        stringArrayArray[5] = stringArray6;
        String[][] verify = stringArrayArray;
        int i = 0;
        String[] stringArray7 = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray7[n2];
            Matcher matcher = pattern.matcher(value);
            System.out.println("Value: '" + value + "'");
            if (matcher.matches()) {
                System.out.println("\tmatch");
                System.out.println("\tgroups " + matcher.groupCount());
                int x = 1;
                while (x <= matcher.groupCount()) {
                    System.out.println("\tgroup(" + x + "): '" + matcher.group(x) + "'");
                    TextileTest.assertEquals((String)verify[i][x], (String)matcher.group(x));
                    ++x;
                }
            } else {
                System.out.println("\tno match");
            }
            ++i;
            ++n2;
        }
    }

    public void testLeftAlignment() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1<. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"text-align: left;", (String)attributes.getCssStyle());
    }

    public void testRightAlignment() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1>. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"text-align: right;", (String)attributes.getCssStyle());
    }

    public void testCenterAlignment() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1=. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"text-align: center;", (String)attributes.getCssStyle());
    }

    public void testJustifiedAlignment() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1<>. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"text-align: justify;", (String)attributes.getCssStyle());
    }

    public void testLeftPadding() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1((. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"padding-left: 2em;", (String)attributes.getCssStyle());
    }

    public void testRightPadding() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1))). foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"padding-right: 3em;", (String)attributes.getCssStyle());
    }

    public void testLeftPaddingCssClass() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1(((foo). foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"padding-left: 2em;", (String)attributes.getCssStyle());
        TextileTest.assertEquals((String)"foo", (String)attributes.getCssClass());
    }

    public void testRightPaddingCssStyles() {
        Pattern pattern = Pattern.compile("h1(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\. (.*)?");
        Matcher matcher = pattern.matcher("h1){color: red;}. foo");
        TextileTest.assertTrue((boolean)matcher.matches());
        Attributes attributes = new Attributes();
        Textile.configureAttributes((Attributes)attributes, (Matcher)matcher, (int)1, (boolean)true);
        TextileTest.assertEquals((String)"padding-right: 1em; color: red;", (String)attributes.getCssStyle());
    }
}

