/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.internal.jira.core.IJiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.JiraClientManager;
import org.eclipse.mylyn.internal.jira.core.JiraCorePlugin;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraConfiguration;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;

public class JiraClientFactory
implements IRepositoryListener,
IRepositoryChangeListener,
IJiraClientFactory {
    private static JiraClientFactory instance = null;
    private JiraClientManager clientManager = null;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();
    private boolean forceTaskRepositoryLocationFactory;

    private JiraClientFactory() {
        this.clientManager = JiraCorePlugin.getClientManager();
    }

    public void clearClients() {
        this.clientManager.removeAllClients(false);
    }

    public void clearClientsAndConfigurationData() {
        this.clientManager.removeAllClients(true);
    }

    public synchronized JiraClient getJiraClient(TaskRepository repository) {
        JiraClient client = this.clientManager.getClient(repository.getRepositoryUrl());
        if (client == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(repository);
            client = this.clientManager.addClient(location, JiraUtil.getConfiguration(repository));
        }
        return client;
    }

    public static synchronized JiraClientFactory getDefault() {
        if (instance == null) {
            instance = new JiraClientFactory();
        }
        return instance;
    }

    public synchronized void logOutFromAll() {
        JiraClient[] clients;
        JiraClient[] jiraClientArray = clients = this.clientManager.getAllClients();
        int n = clients.length;
        int n2 = 0;
        while (n2 < n) {
            JiraClient client = jiraClientArray[n2];
            try {
                client.logout(null);
            }
            catch (JiraException jiraException) {}
            ++n2;
        }
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        if (repository.getConnectorKind().equals("jira")) {
            assert (this.clientManager.getClient(repository.getRepositoryUrl()) == null);
            this.getJiraClient(repository);
        }
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        JiraClient client;
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            this.clientManager.removeClient(client, true);
        }
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
    }

    public synchronized void repositoryChanged(TaskRepositoryChangeEvent event) {
        JiraClient client;
        TaskRepository repository = event.getRepository();
        if (repository.getConnectorKind().equals("jira") && (client = this.clientManager.getClient(repository.getRepositoryUrl())) != null) {
            if (event.getDelta().getType() == TaskRepositoryDelta.Type.ALL) {
                client.purgeSession();
                this.updateClient(client, repository);
            } else if (event.getDelta().getType() == TaskRepositoryDelta.Type.CREDENTIALS || event.getDelta().getType() == TaskRepositoryDelta.Type.PROYX) {
                client.purgeSession();
            } else {
                this.updateClient(client, repository);
            }
        }
    }

    private void updateClient(JiraClient client, TaskRepository repository) {
        JiraConfiguration configuration = JiraUtil.getConfiguration(repository);
        if (!configuration.equals(client.getConfiguration())) {
            client.setConfiguration(configuration);
        }
    }

    public ServerInfo validateConnection(AbstractWebLocation location, IProgressMonitor monitor) throws JiraException {
        return this.validateConnection(location, new JiraConfiguration(), monitor);
    }

    public ServerInfo validateConnection(AbstractWebLocation location, JiraConfiguration configuration, IProgressMonitor monitor) throws JiraException {
        ServerInfo info = this.clientManager.validateConnection(location, configuration, monitor);
        JiraVersion serverVersion = new JiraVersion(info.getVersion());
        if (JiraVersion.MIN_VERSION.compareTo(serverVersion) > 0) {
            throw new JiraException("JIRA connector requires server " + JiraVersion.MIN_VERSION + " or later");
        }
        return info;
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory, boolean force) {
        if (this.forceTaskRepositoryLocationFactory) {
            return;
        }
        this.forceTaskRepositoryLocationFactory = force;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void repositoryUrlChanged(TaskRepository repository, String oldUrl) {
    }
}

