/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.model.filter;

import java.io.Serializable;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.filter.Filter;

public class IssueTypeFilter
implements Filter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IssueType[] issueTypes;
    private final boolean standardTypes;
    private final boolean subTaskTypes;

    public IssueTypeFilter(IssueType[] issueTypes) {
        this.issueTypes = issueTypes;
        this.standardTypes = false;
        this.subTaskTypes = false;
    }

    public IssueTypeFilter(boolean standardTypes, boolean subTaskTypes) {
        assert (standardTypes ^ subTaskTypes);
        this.issueTypes = null;
        this.standardTypes = standardTypes;
        this.subTaskTypes = subTaskTypes;
    }

    public IssueType[] getIsueTypes() {
        return this.issueTypes;
    }

    public boolean isStandardTypes() {
        return this.standardTypes;
    }

    public boolean isSubTaskTypes() {
        return this.subTaskTypes;
    }

    IssueTypeFilter copy() {
        if (this.issueTypes != null) {
            return new IssueTypeFilter(this.issueTypes);
        }
        return new IssueTypeFilter(this.standardTypes, this.subTaskTypes);
    }
}

