/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.ProjectRole;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraClientData;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.service.Messages;
import org.eclipse.osgi.util.NLS;

public class JiraClientCache {
    private volatile JiraClientData data;
    private final JiraClient jiraClient;

    public JiraClientCache(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.data = new JiraClientData();
    }

    public JiraStatus getStatusById(String id) {
        return this.data.statusesById.get(id);
    }

    public JiraStatus[] getStatuses() {
        return this.data.statuses;
    }

    public IssueType getIssueTypeById(String id) {
        return this.data.issueTypesById.get(id);
    }

    public IssueType[] getIssueTypes() {
        return this.data.issueTypes;
    }

    public boolean hasDetails() {
        return this.data.lastUpdate != 0L;
    }

    private void initializeProjects(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_project_details, (int)10);
        data.projects = this.jiraClient.getProjects((IProgressMonitor)submonitor.newChild(1));
        data.projectsById = new HashMap<String, Project>(data.projects.length);
        data.projectsByKey = new HashMap<String, Project>(data.projects.length);
        submonitor.setWorkRemaining(data.projects.length);
        Project[] projectArray = data.projects;
        int n = data.projects.length;
        int n2 = 0;
        while (n2 < n) {
            Project project = projectArray[n2];
            data.projectsById.put(project.getId(), project);
            data.projectsByKey.put(project.getKey(), project);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProject(Project project, IProgressMonitor monitor) throws JiraException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.JiraClientCache_project_details_for, (Object)project.getKey()), (int)5);
        Project project2 = project;
        synchronized (project2) {
            JiraVersion version = new JiraVersion(this.data.serverInfo.getVersion());
            project.setComponents(this.jiraClient.getComponents(project.getKey(), (IProgressMonitor)subMonitor.newChild(1)));
            project.setVersions(this.jiraClient.getVersions(project.getKey(), (IProgressMonitor)subMonitor.newChild(1)));
            if (version.supportsPerProjectIssueTypes()) {
                IssueType[] subTaskIssueTypes;
                IssueType[] issueTypes = this.jiraClient.getIssueTypes(project.getId(), (IProgressMonitor)subMonitor.newChild(1));
                IssueType[] issueTypeArray = subTaskIssueTypes = this.jiraClient.getSubTaskIssueTypes(project.getId(), (IProgressMonitor)subMonitor.newChild(1));
                int n = subTaskIssueTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IssueType issueType = issueTypeArray[n2];
                    issueType.setSubTaskType(true);
                    ++n2;
                }
                IssueType[] projectIssueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
                System.arraycopy(issueTypes, 0, projectIssueTypes, 0, issueTypes.length);
                System.arraycopy(subTaskIssueTypes, 0, projectIssueTypes, issueTypes.length, subTaskIssueTypes.length);
                project.setIssueTypes(projectIssueTypes);
            }
            if (version.compareTo(JiraVersion.JIRA_3_13) >= 0) {
                try {
                    SecurityLevel[] securityLevels = this.jiraClient.getAvailableSecurityLevels(project.getKey(), (IProgressMonitor)subMonitor.newChild(1));
                    if (securityLevels.length > 0) {
                        SecurityLevel[] projectSecurityLevels = new SecurityLevel[securityLevels.length + 1];
                        projectSecurityLevels[0] = SecurityLevel.NONE;
                        System.arraycopy(securityLevels, 0, projectSecurityLevels, 1, securityLevels.length);
                        project.setSecurityLevels(projectSecurityLevels);
                    }
                }
                catch (JiraInsufficientPermissionException jiraInsufficientPermissionException) {
                    project.setSecurityLevels(null);
                }
            }
            project.setDetails(true);
        }
    }

    public Project getProjectById(String id) {
        return this.data.projectsById.get(id);
    }

    public Project getProjectByKey(String key) {
        return this.data.projectsByKey.get(key);
    }

    public Project[] getProjects() {
        return this.data.projects;
    }

    public ProjectRole[] getProjectRoles() {
        return this.data.projectRoles;
    }

    private void initializePriorities(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_priorities, (int)1);
        data.priorities = this.jiraClient.getPriorities(monitor);
        data.prioritiesById = new HashMap<String, Priority>(data.priorities.length);
        Priority[] priorityArray = data.priorities;
        int n = data.priorities.length;
        int n2 = 0;
        while (n2 < n) {
            Priority priority = priorityArray[n2];
            data.prioritiesById.put(priority.getId(), priority);
            ++n2;
        }
    }

    public Priority getPriorityById(String id) {
        return this.data.prioritiesById.get(id);
    }

    public Priority[] getPriorities() {
        return this.data.priorities;
    }

    private void initializeIssueTypes(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        IssueType issueType;
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_issue_types, (int)2);
        String version = data.serverInfo.getVersion();
        IssueType[] issueTypes = this.jiraClient.getIssueTypes((IProgressMonitor)submonitor.newChild(1));
        IssueType[] subTaskIssueTypes = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_3) >= 0 ? this.jiraClient.getSubTaskIssueTypes((IProgressMonitor)submonitor.newChild(1)) : new IssueType[]{};
        data.issueTypesById = new HashMap<String, IssueType>(issueTypes.length + subTaskIssueTypes.length);
        IssueType[] issueTypeArray = issueTypes;
        int n = issueTypes.length;
        int n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        issueTypeArray = subTaskIssueTypes;
        n = subTaskIssueTypes.length;
        n2 = 0;
        while (n2 < n) {
            issueType = issueTypeArray[n2];
            issueType.setSubTaskType(true);
            data.issueTypesById.put(issueType.getId(), issueType);
            ++n2;
        }
        data.issueTypes = new IssueType[issueTypes.length + subTaskIssueTypes.length];
        System.arraycopy(issueTypes, 0, data.issueTypes, 0, issueTypes.length);
        System.arraycopy(subTaskIssueTypes, 0, data.issueTypes, issueTypes.length, subTaskIssueTypes.length);
    }

    private void initializeStatuses(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_statuses, (int)1);
        data.statuses = this.jiraClient.getStatuses((IProgressMonitor)submonitor.newChild(1));
        data.statusesById = new HashMap<String, JiraStatus>(data.statuses.length);
        JiraStatus[] jiraStatusArray = data.statuses;
        int n = data.statuses.length;
        int n2 = 0;
        while (n2 < n) {
            JiraStatus status = jiraStatusArray[n2];
            data.statusesById.put(status.getId(), status);
            ++n2;
        }
    }

    private void initializeProjectRoles(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_project_roles, (int)1);
        ProjectRole[] projectRoles = this.jiraClient.getProjectRoles((IProgressMonitor)submonitor.newChild(1));
        if (projectRoles == null) {
            projectRoles = new ProjectRole[]{};
        }
        data.projectRoles = projectRoles;
    }

    private void initializeResolutions(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_getting_resolutions, (int)1);
        data.resolutions = this.jiraClient.getResolutions((IProgressMonitor)submonitor.newChild(0));
        data.resolutionsById = new HashMap<String, Resolution>(data.resolutions.length);
        Resolution[] resolutionArray = data.resolutions;
        int n = data.resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution resolution = resolutionArray[n2];
            data.resolutionsById.put(resolution.getId(), resolution);
            ++n2;
        }
    }

    public Resolution getResolutionById(String id) {
        return this.data.resolutionsById.get(id);
    }

    public Resolution[] getResolutions() {
        return this.data.resolutions;
    }

    public void setData(JiraClientData data) {
        this.data = data;
    }

    public JiraClientData getData() {
        return this.data;
    }

    public synchronized Project refreshProjectDetails(String projectId, IProgressMonitor monitor) throws JiraException {
        Project project = this.getProjectById(projectId);
        if (project != null) {
            this.initializeProject(project, monitor);
        } else {
            this.refreshDetails(monitor);
            project = this.getProjectById(projectId);
            if (project == null) {
                throw new JiraException(NLS.bind((String)"A project with id ''{0}'' does not exist on the repository", (Object)projectId));
            }
            this.initializeProject(project, monitor);
        }
        return project;
    }

    public synchronized void refreshDetails(IProgressMonitor monitor) throws JiraException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_Updating_repository_configuration, (int)7);
        JiraClientData newData = new JiraClientData();
        this.refreshServerInfo(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.data.serverInfo = newData.serverInfo;
        this.initializePriorities(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.initializeIssueTypes(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.initializeResolutions(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.initializeStatuses(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.initializeProjectRoles(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        this.initializeProjects(newData, (IProgressMonitor)subMonitor.newChild(1, 0));
        newData.lastUpdate = System.currentTimeMillis();
        this.data = newData;
    }

    public synchronized void refreshServerInfo(JiraClientData data, IProgressMonitor monitor) throws JiraException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.JiraClientCache_Getting_server_information, (int)1);
        data.serverInfo = this.jiraClient.getServerInfo((IProgressMonitor)submonitor.newChild(1));
    }

    public synchronized void refreshServerInfo(IProgressMonitor monitor) throws JiraException {
        this.refreshServerInfo(this.data, monitor);
    }

    public ServerInfo getServerInfo() {
        return this.data.serverInfo;
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo info = this.data.serverInfo;
        if (info == null) {
            info = this.jiraClient.getServerInfo(monitor);
        }
        this.data.serverInfo = info;
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUser(String name) {
        Map<String, User> map = this.data.usersByName;
        synchronized (map) {
            return this.data.usersByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User putUser(String name, String fullName) {
        User user = new User();
        user.setName(name);
        user.setFullName(fullName);
        Map<String, User> map = this.data.usersByName;
        synchronized (map) {
            this.data.usersByName.put(name, user);
        }
        return user;
    }
}

