/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class JiraConfiguration {
    public static final String DEFAULT_DATE_PATTERN = "dd/MMM/yy";
    public static final String DEFAULT_DATE_TIME_PATTERN = "dd/MMM/yy hh:mm a";
    public static final Locale DEFAULT_LOCALE = Locale.US;
    public static final int DEFAULT_WORK_DAYS_PER_WEEK = 7;
    public static final int DEFAULT_WORK_HOURS_PER_DAY = 24;
    private String characterEncoding;
    private boolean compressionEnabled;
    private String datePattern;
    private String dateTimePattern;
    private boolean followRedirects;
    private Locale locale;
    private int workDaysPerWeek;
    private int workHoursPerDay;
    private String defaultCharacterEncoding;

    public JiraConfiguration() {
        this.setDatePattern(DEFAULT_DATE_PATTERN);
        this.setDateTimePattern(DEFAULT_DATE_TIME_PATTERN);
        this.setLocale(DEFAULT_LOCALE);
        this.setCompressionEnabled(false);
        this.setWorkDaysPerWeek(7);
        this.setWorkHoursPerDay(24);
        this.setDefaultCharacterEncoding("UTF-8");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JiraConfiguration other = (JiraConfiguration)obj;
        if (this.characterEncoding == null ? other.characterEncoding != null : !this.characterEncoding.equals(other.characterEncoding)) {
            return false;
        }
        if (this.compressionEnabled != other.compressionEnabled) {
            return false;
        }
        if (this.datePattern == null ? other.datePattern != null : !this.datePattern.equals(other.datePattern)) {
            return false;
        }
        if (this.dateTimePattern == null ? other.dateTimePattern != null : !this.dateTimePattern.equals(other.dateTimePattern)) {
            return false;
        }
        if (this.followRedirects != other.followRedirects) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.workDaysPerWeek != other.workDaysPerWeek) {
            return false;
        }
        return this.workHoursPerDay == other.workHoursPerDay;
    }

    public synchronized String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public synchronized DateFormat getDateFormat() {
        return new SimpleDateFormat(this.getDatePattern(), this.getLocale());
    }

    public synchronized String getDatePattern() {
        return this.datePattern;
    }

    public synchronized DateFormat getDateTimeFormat() {
        return new SimpleDateFormat(this.getDateTimePattern(), this.getLocale());
    }

    public synchronized String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public synchronized String getDefaultCharacterEncoding() {
        return this.defaultCharacterEncoding;
    }

    public synchronized boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public synchronized Locale getLocale() {
        return this.locale;
    }

    public synchronized int getWorkDaysPerWeek() {
        return this.workDaysPerWeek;
    }

    public synchronized int getWorkHoursPerDay() {
        return this.workHoursPerDay;
    }

    public synchronized int hashCode() {
        int result = 1;
        result = 31 * result + (this.characterEncoding == null ? 0 : this.characterEncoding.hashCode());
        result = 31 * result + (this.compressionEnabled ? 1231 : 1237);
        result = 31 * result + (this.datePattern == null ? 0 : this.datePattern.hashCode());
        result = 31 * result + (this.dateTimePattern == null ? 0 : this.dateTimePattern.hashCode());
        result = 31 * result + (this.followRedirects ? 1231 : 1237);
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + this.workDaysPerWeek;
        result = 31 * result + this.workHoursPerDay;
        return result;
    }

    public synchronized boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public synchronized void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public synchronized void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public synchronized void setDatePattern(String dateFormat) {
        this.datePattern = dateFormat;
    }

    public synchronized void setDateTimePattern(String dateTimeFormat) {
        this.dateTimePattern = dateTimeFormat;
    }

    public synchronized void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    public synchronized void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public synchronized void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized void setWorkDaysPerWeek(int workDaysPerWeek) {
        this.workDaysPerWeek = workDaysPerWeek;
    }

    public synchronized void setWorkHoursPerDay(int workHoursPerDay) {
        this.workHoursPerDay = workHoursPerDay;
    }
}

