/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.configuration.FileProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.Group;
import org.eclipse.mylyn.internal.jira.core.model.IssueField;
import org.eclipse.mylyn.internal.jira.core.model.IssueType;
import org.eclipse.mylyn.internal.jira.core.model.JiraAction;
import org.eclipse.mylyn.internal.jira.core.model.JiraStatus;
import org.eclipse.mylyn.internal.jira.core.model.JiraVersion;
import org.eclipse.mylyn.internal.jira.core.model.JiraWorkLog;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.model.Priority;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.ProjectRole;
import org.eclipse.mylyn.internal.jira.core.model.Resolution;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.ServerInfo;
import org.eclipse.mylyn.internal.jira.core.model.User;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.service.JiraAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.service.JiraInsufficientPermissionException;
import org.eclipse.mylyn.internal.jira.core.service.JiraServiceUnavailableException;
import org.eclipse.mylyn.internal.jira.core.service.JiraTimeFormat;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraSoapConverter;
import org.eclipse.mylyn.internal.jira.core.service.soap.JiraSoapServiceLocator;
import org.eclipse.mylyn.internal.jira.core.service.soap.Messages;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteField;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteIssue;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteNamedObject;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteProjectRole;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteProjectRoleActors;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteSecurityLevel;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteServerInfo;
import org.eclipse.mylyn.internal.jira.core.wsdl.beans.RemoteWorklog;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapService;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteAuthenticationException;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemotePermissionException;
import org.eclipse.mylyn.internal.provisional.commons.soap.AbstractSoapClient;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraSoapClient
extends AbstractSoapClient {
    private static final String CONFIG_FILE = "org/eclipse/mylyn/internal/jira/core/service/soap/client-config.wsdd";
    private static final String ERROR_RPC_NOT_ENABLED = "JIRA RPC services are not enabled. Please contact your JIRA administrator.";
    private static final String REMOTE_ERROR_BAD_ID = "White spaces are required between publicId and systemId.";
    private static final String REMOTE_ERROR_BAD_ENVELOPE_TAG = "Bad envelope tag:  html";
    private static final String REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG = "Content is not allowed in prolog.";
    private static final String REMOTE_ERROR_PROCESSING_INSTRUCTIONS = "Processing instructions are not allowed within SOAP messages";
    private static final String SOAP_SERVICE_URL = "/rpc/soap/jirasoapservice-v2";
    private static final long DEFAULT_SESSION_TIMEOUT = 600000L;
    private JiraSoapService soapService;
    private final Lock soapServiceLock = new ReentrantLock();
    private final LoginToken loginToken;
    private final JiraClient jiraClient;
    private boolean reauthenticate;

    public JiraSoapClient(JiraClient jiraClient) {
        this.jiraClient = jiraClient;
        this.loginToken = new LoginToken(jiraClient.getLocation(), 600000L);
    }

    public JiraSoapService getSoapService() throws JiraException {
        this.soapServiceLock.lock();
        try {
            if (this.soapService == null) {
                JiraSoapServiceLocator locator = new JiraSoapServiceLocator((EngineConfiguration)new FileProvider(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)), this.jiraClient);
                try {
                    this.soapService = locator.getJirasoapserviceV2(new URL(String.valueOf(this.jiraClient.getBaseUrl()) + SOAP_SERVICE_URL));
                }
                catch (ServiceException e) {
                    throw new JiraException(e);
                }
                catch (MalformedURLException e) {
                    throw new JiraException(e);
                }
                if (this.soapService == null) {
                    throw new JiraException("Initialization of JIRA Soap service failed");
                }
            }
            JiraSoapService jiraSoapService = this.soapService;
            return jiraSoapService;
        }
        finally {
            this.soapServiceLock.unlock();
        }
    }

    public User getUser(IProgressMonitor monitor, final String username) throws JiraException {
        return this.call(monitor, new Callable<User>(){

            @Override
            public User call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getUser(JiraSoapClient.this.loginToken.getCurrentValue(), username));
            }
        });
    }

    public Component[] getComponents(final String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Component[]>(){

            @Override
            public Component[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getComponents(JiraSoapClient.this.loginToken.getCurrentValue(), projectKey));
            }
        });
    }

    public String login(IProgressMonitor monitor) throws JiraException {
        this.loginToken.expire();
        return this.call(monitor, new Callable<String>(){

            @Override
            public String call() throws RemoteException, JiraException {
                return JiraSoapClient.this.loginToken.getCurrentValue();
            }
        });
    }

    public Group getGroup(final String name, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Group>(){

            @Override
            public Group call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getGroup(JiraSoapClient.this.loginToken.getCurrentValue(), name));
            }
        });
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws JiraException {
        ServerInfo serverInfo = this.call(monitor, new Callable<ServerInfo>(){

            @Override
            public ServerInfo call() throws RemoteException, JiraException {
                ServerInfo serverInfo = new ServerInfo();
                serverInfo.getStatistics().mark();
                try {
                    InetAddress.getByName(WebUtil.getHost((String)JiraSoapClient.this.getLocation().getUrl()));
                    serverInfo.getStatistics().record("Resolving name took {0}");
                }
                catch (Exception exception) {}
                serverInfo.getStatistics().mark();
                String session = JiraSoapClient.this.loginToken.getCurrentValue();
                serverInfo.getStatistics().record("Login via SOAP took {0}");
                serverInfo.getStatistics().mark();
                RemoteServerInfo remoteServerInfo = JiraSoapClient.this.getSoapService().getServerInfo(session);
                serverInfo.getStatistics().record("Retrieval of server info took {0}");
                return JiraSoapConverter.convert(remoteServerInfo, serverInfo);
            }
        });
        return serverInfo;
    }

    public String getKeyFromId(final String issueId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<String>(){

            @Override
            public String call() throws RemoteException, JiraException {
                RemoteIssue issue = JiraSoapClient.this.getSoapService().getIssueById(JiraSoapClient.this.loginToken.getCurrentValue(), issueId);
                return issue != null ? issue.getKey() : null;
            }
        });
    }

    public JiraAction[] getAvailableActions(final String taskKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraAction[]>(){

            @Override
            public JiraAction[] call() throws RemoteException, JiraException {
                RemoteNamedObject[] actions = JiraSoapClient.this.getSoapService().getAvailableActions(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (actions == null) {
                    return new JiraAction[0];
                }
                JiraAction[] operations = new JiraAction[actions.length];
                int i = 0;
                while (i < actions.length) {
                    RemoteNamedObject action = actions[i];
                    operations[i] = new JiraAction(action.getId(), action.getName());
                    ++i;
                }
                return operations;
            }
        });
    }

    public String[] getActionFields(final String taskKey, final String actionId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<String[]>(){

            @Override
            public String[] call() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getFieldsForAction(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey, actionId);
                if (remoteFields == null) {
                    return new String[0];
                }
                String[] fields = new String[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    fields[i] = remoteFields[i].getId();
                    ++i;
                }
                return fields;
            }
        });
    }

    public IssueField[] getEditableAttributes(final String taskKey, final boolean workAroundBug205015, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueField[]>(){

            @Override
            public IssueField[] call() throws RemoteException, JiraException {
                RemoteField[] fields = JiraSoapClient.this.getSoapService().getFieldsForEdit(JiraSoapClient.this.loginToken.getCurrentValue(), taskKey);
                if (fields == null) {
                    return new IssueField[0];
                }
                int add = 0;
                if (workAroundBug205015) {
                    add += 2;
                }
                IssueField[] attributes = new IssueField[fields.length + add];
                int i = 0;
                while (i < fields.length) {
                    RemoteField field = fields[i];
                    attributes[i] = new IssueField(field.getId(), field.getName());
                    ++i;
                }
                if (add > 0) {
                    attributes[attributes.length - 2] = new IssueField("duedate", Messages.JiraSoapClient_Due_Date);
                    attributes[attributes.length - 1] = new IssueField("fixVersions", Messages.JiraSoapClient_Fix_Version_s);
                }
                return attributes;
            }
        });
    }

    public CustomField[] getCustomAttributes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<CustomField[]>(){

            @Override
            public CustomField[] call() throws RemoteException, JiraException {
                RemoteField[] remoteFields = JiraSoapClient.this.getSoapService().getCustomFields(JiraSoapClient.this.loginToken.getCurrentValue());
                CustomField[] fields = new CustomField[remoteFields.length];
                int i = 0;
                while (i < remoteFields.length) {
                    RemoteField remoteField = remoteFields[i];
                    fields[i] = new CustomField(remoteField.getId(), null, remoteField.getName(), Collections.<String>emptyList());
                    ++i;
                }
                return fields;
            }
        });
    }

    public RemoteIssue getIssueByKey(final String key, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<RemoteIssue>(){

            @Override
            public RemoteIssue call() throws RemoteException, JiraException {
                return JiraSoapClient.this.getSoapService().getIssue(JiraSoapClient.this.loginToken.getCurrentValue(), key);
            }
        });
    }

    public Project[] getProjects(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Project[]>(){

            @Override
            public Project[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getProjectsNoSchemes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public ProjectRole[] getProjectRoles(final IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<ProjectRole[]>(){

            @Override
            public ProjectRole[] call() throws RemoteException, JiraException {
                boolean hasApi;
                String version = JiraSoapClient.this.jiraClient.getCache().getServerInfo(monitor).getVersion();
                boolean bl = hasApi = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_7) >= 0;
                if (hasApi) {
                    RemoteProjectRole[] remoteProjectRoles = JiraSoapClient.this.getSoapService().getProjectRoles(JiraSoapClient.this.loginToken.getCurrentValue());
                    return JiraSoapConverter.convert(remoteProjectRoles);
                }
                return null;
            }
        });
    }

    public JiraStatus[] getStatuses(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraStatus[]>(){

            @Override
            public JiraStatus[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getStatuses(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getSubTaskIssueTypes(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSubTaskIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Priority[] getPriorities(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Priority[]>(){

            @Override
            public Priority[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getPriorities(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Resolution[] getResolutions(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Resolution[]>(){

            @Override
            public Resolution[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getResolutions(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public Comment[] getComments(final String issueKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Comment[]>(){

            @Override
            public Comment[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getComments(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey));
            }
        });
    }

    public Version[] getVersions(final String componentKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<Version[]>(){

            @Override
            public Version[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getVersions(JiraSoapClient.this.loginToken.getCurrentValue(), componentKey));
            }
        });
    }

    public JiraWorkLog[] getWorkLogs(final String issueKey, final IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraWorkLog[]>(){

            @Override
            public JiraWorkLog[] call() throws RemoteException, JiraException {
                boolean hasApi;
                String version = JiraSoapClient.this.jiraClient.getCache().getServerInfo(monitor).getVersion();
                boolean bl = hasApi = new JiraVersion(version).compareTo(JiraVersion.JIRA_3_10) >= 0;
                if (hasApi) {
                    return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getWorklogs(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey));
                }
                return null;
            }
        });
    }

    public void logout(IProgressMonitor monitor) throws JiraException {
        this.callOnce(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                JiraSoapClient.this.loginToken.expire();
                return null;
            }
        });
    }

    public NamedFilter[] getNamedFilters(IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<NamedFilter[]>(){

            @Override
            public NamedFilter[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSavedFilters(JiraSoapClient.this.loginToken.getCurrentValue()));
            }
        });
    }

    public IssueType[] getIssueTypes(final String projectId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                JiraSoapClient.this.getSoapService().getIssueTypes(JiraSoapClient.this.loginToken.getCurrentValue());
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getIssueTypesForProject(JiraSoapClient.this.loginToken.getCurrentValue(), projectId));
            }
        });
    }

    public IssueType[] getSubTaskIssueTypes(final String projectId, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<IssueType[]>(){

            @Override
            public IssueType[] call() throws RemoteException, JiraException {
                return JiraSoapConverter.convert(JiraSoapClient.this.getSoapService().getSubTaskIssueTypesForProject(JiraSoapClient.this.loginToken.getCurrentValue(), projectId));
            }
        });
    }

    public void purgeSession() {
        this.reauthenticate = true;
    }

    static String unwrapRemoteException(RemoteException e) {
        AxisFault fault;
        Element httpErrorElement;
        if (e instanceof AxisFault && (httpErrorElement = (fault = (AxisFault)e).lookupFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE)) != null) {
            int responseCode = Integer.parseInt(httpErrorElement.getFirstChild().getTextContent());
            switch (responseCode) {
                case 500: {
                    return Messages.JiraSoapClient_Internal_Server_Error;
                }
                case 503: {
                    return ERROR_RPC_NOT_ENABLED;
                }
                case 404: {
                    return Messages.JiraSoapClient_No_JIRA_repository_found_at_location;
                }
                case 301: {
                    return Messages.JiraSoapClient_The_location_of_the_Jira_server_has_moved;
                }
            }
        }
        if (e.getCause() != null) {
            Throwable cause = e.getCause();
            if (cause instanceof UnknownHostException) {
                return Messages.JiraSoapClient_Unknown_host;
            }
            if (cause instanceof ConnectException) {
                return Messages.JiraSoapClient_Unable_to_connect_to_server;
            }
            if (cause instanceof SAXException && (REMOTE_ERROR_BAD_ENVELOPE_TAG.equalsIgnoreCase(cause.getMessage()) || REMOTE_ERROR_BAD_ID.equals(cause.getMessage()) || REMOTE_ERROR_CONTENT_NOT_ALLOWED_IN_PROLOG.equals(cause.getMessage()) || REMOTE_ERROR_PROCESSING_INSTRUCTIONS.equals(cause.getMessage()))) {
                return ERROR_RPC_NOT_ENABLED;
            }
            return e.getCause().getLocalizedMessage();
        }
        if (e instanceof AxisFault) {
            return String.valueOf(Messages.JiraSoapClient_Server_error_) + e.getLocalizedMessage();
        }
        return e.getLocalizedMessage();
    }

    protected <T> T call(IProgressMonitor monitor, Callable<T> runnable) throws JiraException {
        try {
            return (T)super.call(monitor, runnable);
        }
        catch (JiraException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T callOnce(IProgressMonitor monitor, Callable<T> runnable) throws JiraException {
        try {
            return (T)super.callOnce(monitor, runnable);
        }
        catch (RemotePermissionException e) {
            throw new JiraInsufficientPermissionException(e.getMessage());
        }
        catch (RemoteAuthenticationException e) {
            throw new JiraAuthenticationException(e.getMessage());
        }
        catch (org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteException e) {
            String message = e.getMessage();
            if (message == null) {
                message = NLS.bind((String)"Service unavailabe: {0}", (Object)e.getFaultReason());
            }
            throw new JiraServiceUnavailableException(message);
        }
        catch (RemoteException e) {
            throw new JiraServiceUnavailableException(JiraSoapClient.unwrapRemoteException(e));
        }
        catch (JiraException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected AbstractWebLocation getLocation() {
        return this.jiraClient.getLocation();
    }

    protected boolean isAuthenticationException(Exception e) {
        return e instanceof JiraAuthenticationException;
    }

    protected boolean doLogin(IProgressMonitor monitor) {
        this.loginToken.expire();
        return true;
    }

    public SecurityLevel[] getAvailableSecurityLevels(final String projectKey, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<SecurityLevel[]>(){

            @Override
            public SecurityLevel[] call() throws RemoteException, JiraException {
                RemoteSecurityLevel[] remoteSecurityLevels = JiraSoapClient.this.getSoapService().getSecurityLevels(JiraSoapClient.this.loginToken.getCurrentValue(), projectKey);
                if (remoteSecurityLevels == null) {
                    return new SecurityLevel[0];
                }
                SecurityLevel[] securityLevels = JiraSoapConverter.convert(remoteSecurityLevels);
                return securityLevels;
            }
        });
    }

    public JiraWorkLog addWorkLog(final String issueKey, final JiraWorkLog log, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<JiraWorkLog>(){

            @Override
            public JiraWorkLog call() throws RemoteException, JiraException {
                JiraTimeFormat formatter = new JiraTimeFormat(JiraSoapClient.this.jiraClient.getConfiguration().getWorkDaysPerWeek(), JiraSoapClient.this.jiraClient.getConfiguration().getWorkHoursPerDay());
                RemoteWorklog remoteLog = JiraSoapConverter.convert(log, formatter);
                remoteLog = log.isAutoAdjustEstimate() ? JiraSoapClient.this.getSoapService().addWorklogAndAutoAdjustRemainingEstimate(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, remoteLog) : JiraSoapClient.this.getSoapService().addWorklogAndRetainRemainingEstimate(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, remoteLog);
                return remoteLog != null ? JiraSoapConverter.convert(remoteLog) : null;
            }
        });
    }

    public void addComment(final String issueKey, final Comment comment, IProgressMonitor monitor) throws JiraException {
        this.call(monitor, new Callable<Object>(){

            @Override
            public Object call() throws RemoteException, JiraException {
                JiraSoapClient.this.getSoapService().addComment(JiraSoapClient.this.loginToken.getCurrentValue(), issueKey, JiraSoapConverter.convert(comment));
                return null;
            }
        });
    }

    public User[] getProjectRoleUsers(final Project project, final ProjectRole projectRole, IProgressMonitor monitor) throws JiraException {
        return this.call(monitor, new Callable<User[]>(){

            @Override
            public User[] call() throws Exception {
                RemoteProjectRoleActors actors = JiraSoapClient.this.getSoapService().getProjectRoleActors(JiraSoapClient.this.loginToken.getCurrentValue(), JiraSoapConverter.convert(projectRole), JiraSoapConverter.convert(project));
                return JiraSoapConverter.convert(actors.getUsers());
            }
        });
    }

    private class LoginToken {
        private final long timeout;
        private String token;
        private long lastAccessed;
        private final AbstractWebLocation location;
        private AuthenticationCredentials credentials;

        public LoginToken(AbstractWebLocation location, long timeout) {
            this.location = location;
            this.timeout = timeout;
            this.lastAccessed = -1L;
        }

        public synchronized String getCurrentValue() throws JiraException, RemoteAuthenticationException, org.eclipse.mylyn.internal.jira.core.wsdl.soap.RemoteException, RemoteException {
            AuthenticationCredentials newCredentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
            if (newCredentials == null) {
                this.expire();
                return "";
            }
            if (!newCredentials.equals((Object)this.credentials) || JiraSoapClient.this.reauthenticate) {
                JiraSoapClient.this.reauthenticate = false;
                this.expire();
                this.credentials = newCredentials;
            }
            if (System.currentTimeMillis() - this.lastAccessed >= this.timeout || this.token == null) {
                this.expire();
                this.token = JiraSoapClient.this.getSoapService().login(this.credentials.getUserName(), this.credentials.getPassword());
                this.lastAccessed = System.currentTimeMillis();
            }
            return this.token;
        }

        public synchronized void expire() {
            if (this.token != null) {
                try {
                    JiraSoapClient.this.getSoapService().logout(this.token);
                }
                catch (RemoteException remoteException) {
                }
                catch (JiraException jiraException) {}
                this.token = null;
                this.lastAccessed = -1L;
            }
        }

        public synchronized boolean isValidToken() {
            return this.token != null && System.currentTimeMillis() - this.lastAccessed < this.timeout;
        }

        public String toString() {
            long expiresIn = (this.timeout - (System.currentTimeMillis() - this.lastAccessed)) / 1000L;
            return "[credentials=" + this.credentials + ", timeout=" + this.timeout + ", valid=" + this.isValidToken() + ", expires=" + expiresIn + "]";
        }
    }
}

