/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.soap;

import java.util.Hashtable;
import javax.xml.rpc.Call;
import javax.xml.rpc.ServiceException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.transport.http.HTTPConstants;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.wsdl.soap.JiraSoapServiceServiceLocator;

public class JiraSoapServiceLocator
extends JiraSoapServiceServiceLocator {
    private final JiraClient client;

    public JiraSoapServiceLocator(EngineConfiguration config, JiraClient client) {
        super(config);
        this.client = client;
    }

    public Call createCall() throws ServiceException {
        Call call = super.createCall();
        if (this.client.isCompressionEnabled()) {
            call.setProperty("transport.http.acceptGzip", (Object)Boolean.TRUE);
            call.setProperty("org.eclipse.mylyn.commons.soap.allowEmptyContentEncoding", (Object)Boolean.TRUE);
        }
        call.setProperty("org.eclipse.mylyn.commons.soap.location", (Object)this.client.getLocation());
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("User-Agent", WebUtil.getUserAgent((String)"JiraConnector Axis/1.4"));
        headers.put(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED, Boolean.FALSE.toString());
        call.setProperty("HTTP-Request-Headers", headers);
        return call;
    }
}

