/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.core.service.web.rss;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.jira.core.html.HTML2TextReader;
import org.eclipse.mylyn.internal.jira.core.model.Attachment;
import org.eclipse.mylyn.internal.jira.core.model.Comment;
import org.eclipse.mylyn.internal.jira.core.model.Component;
import org.eclipse.mylyn.internal.jira.core.model.CustomField;
import org.eclipse.mylyn.internal.jira.core.model.IssueLink;
import org.eclipse.mylyn.internal.jira.core.model.JiraIssue;
import org.eclipse.mylyn.internal.jira.core.model.Project;
import org.eclipse.mylyn.internal.jira.core.model.SecurityLevel;
import org.eclipse.mylyn.internal.jira.core.model.Subtask;
import org.eclipse.mylyn.internal.jira.core.model.Version;
import org.eclipse.mylyn.internal.jira.core.model.filter.IssueCollector;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraRssHandler
extends DefaultHandler {
    private static final String CUSTOM_FIELD_TYPE_TEXTAREA = "com.atlassian.jira.plugin.system.customfieldtypes:textarea";
    private static final String CREATED_ATTR = "created";
    private static final String LEVEL_ATTR = "level";
    private static final String AUTHOR_ATTR = "author";
    private static final String ID_ATTR = "id";
    private static final String KEY_ATTR = "key";
    private static final String USERNAME_ATTR = "username";
    private static final String SECONDS_ATTR = "seconds";
    private static final String NAME_ATTR = "name";
    private static final String SIZE_ATTR = "size";
    private static final String RSS = "rss";
    private static final String CHANNEL = "channel";
    private static final String ITEM = "item";
    private static final String COMMENTS = "comments";
    private static final String COMMENT = "comment";
    private static final String VOTES = "votes";
    private static final String ORIGINAL_ESTIMATE = "timeoriginalestimate";
    private static final String CURRENT_ESTIMATE = "timeestimate";
    private static final String ACTUAL = "timespent";
    private static final String SUBTASKS = "subtasks";
    private static final String SUBTASK = "subtask";
    private static final String ATTACHMENTS = "attachments";
    private static final String ATTACHMENT = "attachment";
    private static final String DUE = "due";
    private static final String COMPONENT = "component";
    private static final String FIX_VERSION = "fixVersion";
    private static final String VERSION = "version";
    private static final String UPDATED = "updated";
    private static final String CREATED = "created";
    private static final String REPORTER = "reporter";
    private static final String ASSIGNEE = "assignee";
    private static final String RESOLUTION = "resolution";
    private static final String STATUS = "status";
    private static final String PRIORITY = "priority";
    private static final String TYPE = "type";
    private static final String SUMMARY = "summary";
    private static final String KEY = "key";
    private static final String PARENT = "parent";
    private static final String ENVIRONMENT = "environment";
    private static final String DESCRIPTION = "description";
    private static final String LINK = "link";
    private static final String TITLE = "title";
    private static final String CUSTOM_FIELDS = "customfields";
    private static final String CUSTOM_FIELD = "customfield";
    private static final String CUSTOM_FIELD_NAME = "customfieldname";
    private static final String CUSTOM_FIELD_VALUES = "customfieldvalues";
    private static final String CUSTOM_FIELD_VALUE = "customfieldvalue";
    private static final String ISSUE_LINKS = "issuelinks";
    private static final String ISSUE_LINK_TYPE = "issuelinktype";
    private static final String ISSUE_LINK_NAME = "name";
    private static final String INWARD_LINKS = "inwardlinks";
    private static final String OUTWARD_LINKS = "outwardlinks";
    private static final String ISSUE_LINK = "issuelink";
    private static final String ISSUE_KEY = "issuekey";
    private static final String SECURITY = "security";
    private static final int START = 0;
    private static final int LOOKING_FOR_CHANNEL = 1;
    private static final int LOOKING_FOR_ITEM = 2;
    private static final int IN_ITEM = 3;
    private static final int IN_COMMENTS = 4;
    private static final int IN_CUSTOM_FIELDS = 5;
    private static final int IN_CUSTOM_FIELD = 6;
    private static final int IN_CUSTOM_FIELD_VALUES = 7;
    private static final int IN_ISSUE_LINKS = 8;
    private static final int IN_ISSUE_LINK_TYPE = 9;
    private static final int IN_XWARDS_LINKS = 10;
    private static final int IN_XWARDS_ISSUE_LINK = 12;
    private static final int IN_ATTACHMENTS = 14;
    private static final int IN_CUSTOM_FIELD_NAME = 15;
    private static final int IN_CUSTOM_FIELD_VALUE = 16;
    private static final int IN_SUBTASKS = 17;
    private final SimpleDateFormat XML_DATE_FORMAT = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z (zz)", Locale.US);
    int state = 0;
    private StringBuilder currentElementText;
    private final JiraClient client;
    private final IssueCollector collector;
    private JiraIssue currentIssue;
    private String commentAuthor;
    private String commentLevel;
    private Date commentDate;
    private final ArrayList<Comment> currentComments = new ArrayList();
    private final ArrayList<Version> currentFixVersions = new ArrayList();
    private final ArrayList<Version> currentReportedVersions = new ArrayList();
    private final ArrayList<Component> currentComponents = new ArrayList();
    private final ArrayList<Attachment> currentAttachments = new ArrayList();
    private final ArrayList<CustomField> currentCustomFields = new ArrayList();
    private String currentSubtaskId;
    private final ArrayList<Subtask> currentSubtasks = new ArrayList();
    private String currentIssueLinkTypeId;
    private String currentIssueLinkTypeName;
    private String currentIssueLinkInwardDescription;
    private String currentIssueLinkOutwardDescription;
    private String currentIssueLinkIssueId;
    private final ArrayList<IssueLink> currentIssueLinks = new ArrayList();
    private String customFieldId;
    private String customFieldKey;
    private String customFieldName;
    private final ArrayList<String> customFieldValues = new ArrayList();
    private String attachmentId;
    private String attachmentName;
    private long attachmentSize;
    private String attachmentAuthor;
    private Date attachmentCreated;
    private boolean markupDetected;

    public static SimpleDateFormat getDateTimeFormat() {
        return new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss", Locale.US);
    }

    public JiraRssHandler(JiraClient client, IssueCollector collector, String baseUrl) {
        this.client = client;
        this.collector = collector;
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = 0;
        this.currentElementText = new StringBuilder(256);
        this.collector.start();
    }

    @Override
    public void endDocument() throws SAXException {
        this.collector.done();
        this.currentElementText = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currentElementText.setLength(0);
        if (this.collector.isCancelled()) {
            throw new OperationCanceledException();
        }
        switch (this.state) {
            case 0: {
                if (!RSS.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!CHANNEL.equals(localName)) break;
                this.state = 2;
                break;
            }
            case 2: {
                if (!ITEM.equals(localName)) break;
                this.state = 3;
                this.currentIssue = new JiraIssue();
                break;
            }
            case 3: {
                if ("key".equals(localName)) {
                    this.currentIssue.setId(attributes.getValue(ID_ATTR));
                } else if (PARENT.equals(localName)) {
                    this.currentIssue.setParentId(attributes.getValue(ID_ATTR));
                } else if (TYPE.equals(localName)) {
                    if (this.currentIssue.getProject() != null && this.currentIssue.getProject().getIssueTypeById(attributes.getValue(ID_ATTR)) != null) {
                        this.currentIssue.setType(this.currentIssue.getProject().getIssueTypeById(attributes.getValue(ID_ATTR)));
                    } else {
                        this.currentIssue.setType(this.client.getCache().getIssueTypeById(attributes.getValue(ID_ATTR)));
                    }
                } else if (PRIORITY.equals(localName)) {
                    this.currentIssue.setPriority(this.client.getCache().getPriorityById(attributes.getValue(ID_ATTR)));
                } else if (STATUS.equals(localName)) {
                    this.currentIssue.setStatus(this.client.getCache().getStatusById(attributes.getValue(ID_ATTR)));
                } else if (ASSIGNEE.equals(localName)) {
                    String assigneeName = attributes.getValue(USERNAME_ATTR);
                    this.currentIssue.setAssignee(assigneeName);
                } else if (REPORTER.equals(localName)) {
                    String reporterName = attributes.getValue(USERNAME_ATTR);
                    this.currentIssue.setReporter(reporterName);
                } else if (RESOLUTION.equals(localName)) {
                    String resolutionId = attributes.getValue(ID_ATTR);
                    this.currentIssue.setResolution(resolutionId != null ? this.client.getCache().getResolutionById(resolutionId) : null);
                } else if (ORIGINAL_ESTIMATE.equals(localName)) {
                    this.currentIssue.setInitialEstimate(Long.parseLong(attributes.getValue(SECONDS_ATTR)));
                } else if (CURRENT_ESTIMATE.equals(localName)) {
                    this.currentIssue.setEstimate(Long.parseLong(attributes.getValue(SECONDS_ATTR)));
                } else if (ACTUAL.equals(localName)) {
                    this.currentIssue.setActual(Long.parseLong(attributes.getValue(SECONDS_ATTR)));
                } else if (SECURITY.equals(localName)) {
                    SecurityLevel securityLevel = new SecurityLevel();
                    securityLevel.setId(attributes.getValue(ID_ATTR));
                    this.currentIssue.setSecurityLevel(securityLevel);
                }
                if (COMMENTS.equals(localName)) {
                    this.state = 4;
                    break;
                }
                if (ISSUE_LINKS.equals(localName)) {
                    this.state = 8;
                    break;
                }
                if (SUBTASKS.equals(localName)) {
                    this.state = 17;
                    break;
                }
                if (CUSTOM_FIELDS.equals(localName)) {
                    this.state = 5;
                    break;
                }
                if (!ATTACHMENTS.equals(localName)) break;
                this.state = 14;
                break;
            }
            case 4: {
                if (!COMMENT.equals(localName)) break;
                this.commentAuthor = attributes.getValue(AUTHOR_ATTR);
                this.commentLevel = attributes.getValue(LEVEL_ATTR);
                this.commentDate = this.convertToDate(attributes.getValue("created"));
                break;
            }
            case 8: {
                if (!ISSUE_LINK_TYPE.equals(localName)) break;
                this.state = 9;
                this.currentIssueLinkTypeId = attributes.getValue(ID_ATTR);
                break;
            }
            case 9: {
                if ("name".equals(localName)) break;
                if (INWARD_LINKS.equals(localName)) {
                    this.currentIssueLinkInwardDescription = attributes.getValue(DESCRIPTION);
                    this.state = 10;
                    break;
                }
                if (!OUTWARD_LINKS.equals(localName)) break;
                this.currentIssueLinkOutwardDescription = attributes.getValue(DESCRIPTION);
                this.state = 10;
                break;
            }
            case 10: {
                if (!ISSUE_LINK.equals(localName)) break;
                this.state = 12;
                break;
            }
            case 12: {
                if (!ISSUE_KEY.equals(localName)) break;
                this.currentIssueLinkIssueId = attributes.getValue(ID_ATTR);
                break;
            }
            case 5: {
                if (!CUSTOM_FIELD.equals(localName)) break;
                this.customFieldId = attributes.getValue(ID_ATTR);
                this.customFieldKey = attributes.getValue("key");
                this.state = 6;
                break;
            }
            case 6: {
                if (CUSTOM_FIELD_NAME.equals(localName)) {
                    this.state = 15;
                    break;
                }
                if (!CUSTOM_FIELD_VALUES.equals(localName)) break;
                this.state = 7;
                break;
            }
            case 7: {
                if (!CUSTOM_FIELD_VALUE.equals(localName)) break;
                this.state = 16;
                break;
            }
            case 14: {
                if (!ATTACHMENT.equals(localName)) break;
                this.attachmentId = attributes.getValue(ID_ATTR);
                this.attachmentName = attributes.getValue("name");
                this.attachmentSize = Long.parseLong(attributes.getValue(SIZE_ATTR));
                this.attachmentAuthor = attributes.getValue(AUTHOR_ATTR);
                this.attachmentCreated = this.convertToDate(attributes.getValue("created"));
                break;
            }
            case 17: {
                if (!SUBTASK.equals(localName)) break;
                this.currentSubtaskId = attributes.getValue(ID_ATTR);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (this.state) {
            case 17: {
                if (SUBTASK.equals(localName)) {
                    this.currentSubtasks.add(new Subtask(this.currentSubtaskId, this.getCurrentElementText()));
                    this.currentSubtaskId = null;
                    break;
                }
                if (!SUBTASKS.equals(localName)) break;
                this.state = 3;
                break;
            }
            case 14: {
                if (ATTACHMENTS.equals(localName)) {
                    this.state = 3;
                    break;
                }
                if (!ATTACHMENT.equals(localName)) break;
                Attachment attachment = new Attachment(this.attachmentId, this.attachmentName, this.attachmentSize, this.attachmentAuthor, this.attachmentCreated);
                this.currentAttachments.add(attachment);
                break;
            }
            case 16: {
                if (!CUSTOM_FIELD_VALUE.equals(localName)) break;
                this.customFieldValues.add(this.getCurrentElementText());
                this.state = 7;
                break;
            }
            case 7: {
                if (!CUSTOM_FIELD_VALUES.equals(localName)) break;
                if (this.customFieldValues.size() == 0) {
                    String text = this.getCurrentElementTextEscapeHtml();
                    this.customFieldValues.add(text.trim());
                }
                this.state = 6;
                break;
            }
            case 15: {
                if (!CUSTOM_FIELD_NAME.equals(localName)) break;
                this.customFieldName = this.getCurrentElementText();
                this.state = 6;
                break;
            }
            case 6: {
                if (!CUSTOM_FIELD.equals(localName)) break;
                boolean customFieldMarkupDetected = false;
                if (CUSTOM_FIELD_TYPE_TEXTAREA.equals(this.customFieldKey)) {
                    int i = this.customFieldValues.size() - 1;
                    while (i >= 0) {
                        String value = this.customFieldValues.get(i);
                        if (JiraRssHandler.hasMarkup(value)) {
                            customFieldMarkupDetected = true;
                        } else {
                            this.customFieldValues.set(i, JiraRssHandler.stripTags(value));
                        }
                        --i;
                    }
                }
                this.markupDetected |= customFieldMarkupDetected;
                CustomField customField = new CustomField(this.customFieldId, this.customFieldKey, this.customFieldName, this.customFieldValues);
                customField.setMarkupDetected(customFieldMarkupDetected);
                this.currentCustomFields.add(customField);
                this.customFieldId = null;
                this.customFieldKey = null;
                this.customFieldName = null;
                this.customFieldValues.clear();
                this.state = 5;
                break;
            }
            case 5: {
                if (!CUSTOM_FIELDS.equals(localName)) break;
                this.state = 3;
                break;
            }
            case 12: {
                if (!ISSUE_LINK.equals(localName)) break;
                String key = this.getCurrentElementText().trim();
                IssueLink link = new IssueLink(this.currentIssueLinkIssueId, key, this.currentIssueLinkTypeId, this.currentIssueLinkTypeName, this.currentIssueLinkInwardDescription, this.currentIssueLinkOutwardDescription);
                this.currentIssueLinks.add(link);
                this.currentIssueLinkIssueId = null;
                this.state = 10;
                break;
            }
            case 10: {
                if (!OUTWARD_LINKS.equals(localName) && !INWARD_LINKS.equals(localName)) break;
                this.state = 9;
                this.currentIssueLinkOutwardDescription = null;
                this.currentIssueLinkInwardDescription = null;
                break;
            }
            case 9: {
                if (ISSUE_LINK_TYPE.equals(localName)) {
                    this.currentIssueLinkTypeName = null;
                    this.state = 8;
                    break;
                }
                if (!"name".equals(localName)) break;
                this.currentIssueLinkTypeName = this.getCurrentElementText().trim();
                break;
            }
            case 8: {
                if (!ISSUE_LINKS.equals(localName)) break;
                this.state = 3;
                break;
            }
            case 4: {
                if (COMMENTS.equals(localName)) {
                    this.state = 3;
                    break;
                }
                if (!COMMENT.equals(localName)) break;
                boolean commentMarkupDetected = false;
                if (JiraRssHandler.hasMarkup(this.currentElementText.toString())) {
                    commentMarkupDetected = true;
                }
                Comment comment = new Comment(this.getCurrentElementTextEscapeHtml(), this.commentAuthor, this.commentLevel, this.commentDate);
                comment.setMarkupDetected(commentMarkupDetected);
                this.currentComments.add(comment);
                break;
            }
            case 3: {
                if (CHANNEL.equals(localName)) {
                    this.state = 1;
                    break;
                }
                if (ITEM.equals(localName)) {
                    if (this.currentReportedVersions.size() > 0) {
                        this.currentIssue.setReportedVersions(this.currentReportedVersions.toArray(new Version[this.currentReportedVersions.size()]));
                    }
                    if (this.currentFixVersions.size() > 0) {
                        this.currentIssue.setFixVersions(this.currentFixVersions.toArray(new Version[this.currentFixVersions.size()]));
                    }
                    if (this.currentComponents.size() > 0) {
                        this.currentIssue.setComponents(this.currentComponents.toArray(new Component[this.currentComponents.size()]));
                    }
                    this.currentIssue.setComments(this.currentComments.toArray(new Comment[this.currentComments.size()]));
                    this.currentIssue.setAttachments(this.currentAttachments.toArray(new Attachment[this.currentAttachments.size()]));
                    this.currentIssue.setCustomFields(this.currentCustomFields.toArray(new CustomField[this.currentCustomFields.size()]));
                    this.currentIssue.setSubtasks(this.currentSubtasks.toArray(new Subtask[this.currentSubtasks.size()]));
                    this.currentIssue.setIssueLinks(this.currentIssueLinks.toArray(new IssueLink[this.currentIssueLinks.size()]));
                    this.currentIssue.setMarkupDetected(this.markupDetected);
                    this.collector.collectIssue(this.currentIssue);
                    this.currentIssue = null;
                    this.currentIssueLinks.clear();
                    this.currentSubtasks.clear();
                    this.currentCustomFields.clear();
                    this.currentAttachments.clear();
                    this.currentComments.clear();
                    this.currentFixVersions.clear();
                    this.currentReportedVersions.clear();
                    this.currentComponents.clear();
                    this.markupDetected = false;
                    this.state = 2;
                    break;
                }
                if (TITLE.equals(localName) || LINK.equals(localName)) break;
                if (DESCRIPTION.equals(localName)) {
                    this.currentIssue.setDescription(this.getCurrentElementTextEscapeHtml());
                    break;
                }
                if (ENVIRONMENT.equals(localName)) {
                    this.currentIssue.setEnvironment(this.getCurrentElementTextEscapeHtml());
                    break;
                }
                if ("key".equals(localName)) {
                    String key = this.getCurrentElementText();
                    this.currentIssue.setKey(key);
                    this.currentIssue.setUrl(String.valueOf(this.client.getBaseUrl()) + "/browse/" + key);
                    int i = key.lastIndexOf(45);
                    if (i == -1) break;
                    String projectKey = key.substring(0, i);
                    Project project = this.client.getCache().getProjectByKey(projectKey);
                    if (project == null) break;
                    if (!project.hasDetails()) {
                        try {
                            this.client.getCache().refreshProjectDetails(project.getId(), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (JiraException jiraException) {
                            break;
                        }
                    }
                    this.currentIssue.setProject(project);
                    break;
                }
                if (PARENT.equals(localName)) {
                    this.currentIssue.setParentKey(this.getCurrentElementText());
                    break;
                }
                if (SUMMARY.equals(localName)) {
                    this.currentIssue.setSummary(this.getCurrentElementText());
                    break;
                }
                if ("created".equals(localName)) {
                    this.currentIssue.setCreated(this.convertToDate(this.getCurrentElementText()));
                    break;
                }
                if (UPDATED.equals(localName)) {
                    this.currentIssue.setUpdated(this.convertToDate(this.getCurrentElementText()));
                    break;
                }
                if (VERSION.equals(localName)) {
                    if (this.currentIssue.getProject() == null || this.addVersionTo(this.currentReportedVersions, this.getCurrentElementText())) break;
                    break;
                }
                if (FIX_VERSION.equals(localName)) {
                    if (this.currentIssue.getProject() == null || this.addVersionTo(this.currentFixVersions, this.getCurrentElementText())) break;
                    break;
                }
                if (COMPONENT.equals(localName)) {
                    if (this.currentIssue.getProject() == null || this.addComponentTo(this.currentComponents, this.getCurrentElementText())) break;
                    break;
                }
                if (DUE.equals(localName)) {
                    this.currentIssue.setDue(this.convertToSimpleDate(this.getCurrentElementText()));
                    break;
                }
                if (VOTES.equals(localName)) {
                    if (this.getCurrentElementText().length() <= 0) break;
                    try {
                        this.currentIssue.setVotes(Integer.parseInt(this.getCurrentElementText()));
                    }
                    catch (NumberFormatException e) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", "Error parsing number of votes", (Throwable)e));
                    }
                    break;
                }
                if (SECURITY.equals(localName)) {
                    SecurityLevel securityLevel = this.currentIssue.getSecurityLevel();
                    if (securityLevel == null) break;
                    securityLevel.setName(this.getCurrentElementText());
                    break;
                }
                if (TYPE.equals(localName) || PRIORITY.equals(localName) || STATUS.equals(localName)) break;
                if (ASSIGNEE.equals(localName)) {
                    this.currentIssue.setAssigneeName(this.getCurrentElementText());
                    break;
                }
                if (REPORTER.equals(localName)) {
                    this.currentIssue.setReporterName(this.getCurrentElementText());
                    break;
                }
                if (RESOLUTION.equals(localName) || ORIGINAL_ESTIMATE.equals(localName) || CURRENT_ESTIMATE.equals(localName)) break;
                ACTUAL.equals(localName);
                break;
            }
            case 2: {
                if (!CHANNEL.equals(localName)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (!RSS.equals(localName)) break;
                this.state = 0;
            }
        }
    }

    private boolean addVersionTo(ArrayList<Version> versions, String currentElementText) {
        Version version = this.currentIssue.getProject().getVersion(currentElementText);
        if (version != null) {
            versions.add(version);
            return true;
        }
        try {
            this.client.getCache().refreshProjectDetails(this.currentIssue.getProject().getId(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JiraException jiraException) {
            return false;
        }
        this.currentIssue.setProject(this.client.getCache().getProjectById(this.currentIssue.getProject().getId()));
        version = this.currentIssue.getProject().getVersion(currentElementText);
        if (version != null) {
            versions.add(version);
            return true;
        }
        return false;
    }

    private boolean addComponentTo(ArrayList<Component> versions, String currentElementText) {
        Component version = this.currentIssue.getProject().getComponent(currentElementText);
        if (version != null) {
            versions.add(version);
            return true;
        }
        try {
            this.client.getCache().refreshProjectDetails(this.currentIssue.getProject().getId(), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JiraException jiraException) {
            return false;
        }
        this.currentIssue.setProject(this.client.getCache().getProjectById(this.currentIssue.getProject().getId()));
        version = this.currentIssue.getProject().getComponent(currentElementText);
        if (version != null) {
            versions.add(version);
            return true;
        }
        return false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentElementText.append(ch, start, length);
    }

    private Date convertToDate(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return this.XML_DATE_FORMAT.parse(value);
        }
        catch (ParseException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", "Error parsing date: \"" + value + "\"", (Throwable)e));
            return null;
        }
    }

    private Date convertToSimpleDate(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        try {
            return JiraRssHandler.getDateTimeFormat().parse(value);
        }
        catch (ParseException e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.internal.jira.core", "Error parsing due date: \"" + value + "\"", (Throwable)e));
            return null;
        }
    }

    private String getCurrentElementText() {
        String unescaped = this.currentElementText.toString();
        unescaped = StringEscapeUtils.unescapeXml((String)unescaped);
        return unescaped;
    }

    private String getCurrentElementTextEscapeHtml() {
        String unescaped = this.currentElementText.toString();
        if (JiraRssHandler.hasMarkup(unescaped)) {
            this.markupDetected = true;
        } else {
            unescaped = JiraRssHandler.stripTags(unescaped);
        }
        return unescaped;
    }

    public static String stripTags(String text) {
        int len;
        char[] chars;
        block4: {
            if (text == null || text.length() == 0) {
                return "";
            }
            StringReader stringReader = new StringReader(text);
            HTML2TextReader html2TextReader = new HTML2TextReader(stringReader);
            try {
                chars = new char[text.length()];
                len = html2TextReader.read(chars, 0, text.length());
                if (len != -1) break block4;
                return "";
            }
            catch (IOException iOException) {
                return text;
            }
        }
        return new String(chars, 0, len);
    }

    public static boolean hasMarkup(String unescaped) {
        int i = unescaped.indexOf("<");
        while (i != -1) {
            if (!(unescaped.regionMatches(i + 1, "br/>", 0, 4) || unescaped.regionMatches(i + 1, "a ", 0, 1) || unescaped.regionMatches(i + 1, "/a>", 0, 3))) {
                return true;
            }
            i = unescaped.indexOf("<", i + 1);
        }
        return false;
    }
}

