/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import java.text.ParseException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.editor.Messages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class JiraEditorUtil {
    private static final String DECORATOR_KEY = "DECORATOR";

    public static void setTimeSpentDecorator(Text toDecorate, boolean isZeroValid, TaskRepository repository) {
        boolean invalid = false;
        try {
            long amount = JiraUtil.getTimeFormat((TaskRepository)repository).parse(toDecorate.getText());
            invalid = isZeroValid ? amount < 0L : amount < 1L;
        }
        catch (ParseException parseException) {
            invalid = true;
        }
        if (toDecorate == null || toDecorate.isDisposed()) {
            return;
        }
        String decorationId = "DEC_ERROR";
        ControlDecoration amountTextControlDecoration = null;
        if (toDecorate.getData(DECORATOR_KEY) instanceof ControlDecoration) {
            amountTextControlDecoration = (ControlDecoration)toDecorate.getData(DECORATOR_KEY);
        }
        if (amountTextControlDecoration == null) {
            amountTextControlDecoration = new ControlDecoration((Control)toDecorate, 16512);
            toDecorate.setData(DECORATOR_KEY, (Object)amountTextControlDecoration);
            amountTextControlDecoration.setShowOnlyOnFocus(false);
            amountTextControlDecoration.setDescriptionText(NLS.bind((String)Messages.JiraEditorUtil_Time_Spent_Error_Decorator_Hover, (Object)JiraUtil.getWorkDaysPerWeek((TaskRepository)repository), (Object)JiraUtil.getWorkHoursPerDay((TaskRepository)repository)));
        }
        FieldDecoration errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration(decorationId);
        amountTextControlDecoration.setImage(errorImage.getImage());
        if (invalid) {
            amountTextControlDecoration.show();
        } else {
            amountTextControlDecoration.hide();
        }
    }
}

