/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.editor;

import java.util.Set;
import org.eclipse.mylyn.internal.jira.core.JiraFieldType;
import org.eclipse.mylyn.internal.jira.core.JiraTaskDataHandler;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.editor.DateTimeAttributeEditor;
import org.eclipse.mylyn.internal.jira.ui.editor.TimeSpanAttributeEditor;
import org.eclipse.mylyn.internal.jira.ui.editor.WorkLogPart;
import org.eclipse.mylyn.internal.tasks.ui.editors.CheckboxMultiSelectAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JiraTaskEditorPage
extends AbstractTaskEditorPage {
    public JiraTaskEditorPage(TaskEditor editor) {
        super(editor, "jira");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(true);
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set parts = super.createPartDescriptors();
        if (this.getModel().getTaskData().getRoot().getAttribute("attribute.jira.worklog-not-supported") == null) {
            parts.add(new TaskEditorPartDescriptor("org.eclipse.mylyn.jira.worklog"){

                public AbstractTaskEditorPart createPart() {
                    return new WorkLogPart();
                }
            }.setPath("org.eclipse.mylyn.tasks.ui.editors.parts.attributes/planning"));
        }
        return parts;
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        AttributeEditorFactory factory = new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                if (JiraTaskDataHandler.isTimeSpanAttribute((TaskAttribute)taskAttribute)) {
                    return new TimeSpanAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute);
                }
                if (JiraUtil.isCustomDateTimeAttribute((TaskAttribute)taskAttribute)) {
                    String metaType = taskAttribute.getMetaData().getValue("type");
                    if (JiraFieldType.DATETIME.getKey().equals(metaType)) {
                        return new DateTimeAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute, true);
                    }
                    if (JiraFieldType.DATE.getKey().equals(metaType)) {
                        return new DateTimeAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute, false);
                    }
                }
                if ("multiSelect".equals(type)) {
                    CheckboxMultiSelectAttributeEditor attributeEditor = new CheckboxMultiSelectAttributeEditor(JiraTaskEditorPage.this.getModel(), taskAttribute);
                    attributeEditor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.SINGLE));
                    return attributeEditor;
                }
                return super.createEditor(type, taskAttribute);
            }
        };
        return factory;
    }
}

