/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jira.ui.wizards;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.jira.core.JiraClientFactory;
import org.eclipse.mylyn.internal.jira.core.model.JiraFilter;
import org.eclipse.mylyn.internal.jira.core.model.NamedFilter;
import org.eclipse.mylyn.internal.jira.core.service.JiraClient;
import org.eclipse.mylyn.internal.jira.core.service.JiraException;
import org.eclipse.mylyn.internal.jira.core.util.JiraUtil;
import org.eclipse.mylyn.internal.jira.ui.wizards.JiraFilterDefinitionPage;
import org.eclipse.mylyn.internal.jira.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class JiraNamedFilterPage
extends AbstractRepositoryQueryPage {
    private Button buttonCustom;
    private Button buttonSaved;
    private List filterList;
    private NamedFilter[] filters = null;
    private JiraFilterDefinitionPage filterDefinitionPage;
    private Button updateButton = null;
    private final NamedFilter workingCopy;

    public JiraNamedFilterPage(TaskRepository repository) {
        this(repository, null);
    }

    public JiraNamedFilterPage(TaskRepository repository, IRepositoryQuery query) {
        super(Messages.JiraNamedFilterPage_New_Jira_Query, repository, query);
        this.workingCopy = this.getFilter(query);
        this.setTitle(Messages.JiraNamedFilterPage_New_Jira_Query);
        this.setDescription(Messages.JiraNamedFilterPage_Please_select_a_query_type);
        this.setPageComplete(false);
    }

    private NamedFilter getFilter(IRepositoryQuery query) {
        NamedFilter filter = null;
        if (query != null) {
            filter = JiraUtil.getNamedFilter((IRepositoryQuery)query);
        }
        if (filter == null) {
            filter = new NamedFilter();
        }
        return filter;
    }

    public void applyTo(IRepositoryQuery query) {
        NamedFilter filter = this.getSelectedFilter();
        query.setSummary(filter.getName());
        JiraUtil.setQuery((TaskRepository)this.getTaskRepository(), (IRepositoryQuery)query, (JiraFilter)filter);
    }

    public boolean canFlipToNextPage() {
        return this.buttonCustom.getSelection();
    }

    public void createControl(Composite parent) {
        IRepositoryQuery query = this.getQuery();
        boolean isCustom = query == null || JiraUtil.isFilterDefinition((IRepositoryQuery)query);
        Composite innerComposite = new Composite(parent, 0);
        innerComposite.setLayoutData((Object)new GridData());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        innerComposite.setLayout((Layout)gl);
        this.buttonCustom = new Button(innerComposite, 16);
        this.buttonCustom.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonCustom.setText(Messages.JiraNamedFilterPage_Create_query_using_form);
        this.buttonCustom.setSelection(isCustom);
        this.buttonSaved = new Button(innerComposite, 16);
        this.buttonSaved.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.buttonSaved.setText(Messages.JiraNamedFilterPage_Use_saved_filter_from_the_repository);
        this.buttonSaved.setSelection(!isCustom);
        this.buttonSaved.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                boolean selection = JiraNamedFilterPage.this.buttonSaved.getSelection();
                if (JiraNamedFilterPage.this.filters != null) {
                    JiraNamedFilterPage.this.filterList.setEnabled(selection);
                }
                JiraNamedFilterPage.this.updateButton.setEnabled(selection);
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.filterList = new List(innerComposite, 2560);
        this.filterList.add(Messages.JiraNamedFilterPage_Downloading_);
        this.filterList.deselectAll();
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 15;
        this.filterList.setLayoutData((Object)data);
        this.filterList.setEnabled(false);
        this.filterList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.getContainer().updateButtons();
            }
        });
        this.updateButton = new Button(innerComposite, 16392);
        GridData gridData = new GridData(4, 128, false, true);
        this.updateButton.setLayoutData((Object)gridData);
        this.updateButton.setText(Messages.JiraNamedFilterPage_Update_from_Repository);
        this.updateButton.setEnabled(isCustom);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JiraNamedFilterPage.this.setErrorMessage(null);
                JiraNamedFilterPage.this.filterList.setEnabled(false);
                JiraNamedFilterPage.this.filterList.removeAll();
                JiraNamedFilterPage.this.filterList.add(Messages.JiraNamedFilterPage_Downloading_);
                JiraNamedFilterPage.this.filterList.deselectAll();
                JiraNamedFilterPage.this.getContainer().updateButtons();
                JiraNamedFilterPage.this.updateButton.setEnabled(false);
                JiraNamedFilterPage.this.downloadFilters();
            }
        });
        Dialog.applyDialogFont((Control)innerComposite);
        this.setControl((Control)innerComposite);
        this.downloadFilters();
    }

    public void displayFilters(NamedFilter[] filters, IStatus status) {
        if (!status.isOK()) {
            this.setMessage(status.getMessage(), 3);
        }
        this.filterList.removeAll();
        if (filters.length == 0) {
            this.filterList.setEnabled(false);
            this.filterList.add(Messages.JiraNamedFilterPage_No_filters_found);
            this.filterList.deselectAll();
            if (status.isOK()) {
                this.setMessage(Messages.JiraNamedFilterPage_No_saved_filters_found, 2);
            }
            this.setPageComplete(false);
            return;
        }
        int n = 0;
        int i = 0;
        while (i < filters.length) {
            this.filterList.add(filters[i].getName());
            if (filters[i].getId().equals(this.workingCopy.getId())) {
                n = i;
            }
            ++i;
        }
        this.filterList.select(n);
        this.filterList.showSelection();
        this.filterList.setEnabled(this.buttonSaved.getSelection());
        this.setPageComplete(status.isOK());
    }

    protected void downloadFilters() {
        Job job = new Job(Messages.JiraNamedFilterPage_Downloading_Filter_Names){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.JiraNamedFilterPage_Downloading_list_of_filters, -1);
                NamedFilter[] loadedFilters = new NamedFilter[]{};
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        JiraClient jiraServer = JiraClientFactory.getDefault().getJiraClient(JiraNamedFilterPage.this.getTaskRepository());
                        loadedFilters = jiraServer.getNamedFilters(monitor);
                        JiraNamedFilterPage.this.filters = loadedFilters;
                    }
                    catch (JiraException e) {
                        status = RepositoryStatus.createStatus((String)JiraNamedFilterPage.this.getTaskRepository().getRepositoryUrl(), (int)4, (String)"org.eclipse.mylyn.internal.jira.core", (String)(String.valueOf(Messages.JiraNamedFilterPage_Could_not_update_filters) + e.getMessage() + "\n"));
                        IStatus iStatus = Status.CANCEL_STATUS;
                        this.showFilters(loadedFilters, status);
                        monitor.done();
                        return iStatus;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        this.showFilters(loadedFilters, status);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    this.showFilters(loadedFilters, status);
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            private void showFilters(final NamedFilter[] loadedFilters, final IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!JiraNamedFilterPage.this.filterList.isDisposed()) {
                            JiraNamedFilterPage.this.displayFilters(loadedFilters, status);
                        }
                        if (!JiraNamedFilterPage.this.updateButton.isDisposed() && !JiraNamedFilterPage.this.buttonSaved.isDisposed()) {
                            JiraNamedFilterPage.this.updateButton.setEnabled(JiraNamedFilterPage.this.buttonSaved.getSelection());
                        }
                    }
                });
            }
        };
        job.schedule();
    }

    public IWizardPage getNextPage() {
        if (!this.buttonCustom.getSelection()) {
            return null;
        }
        if (this.filterDefinitionPage == null) {
            this.filterDefinitionPage = new JiraFilterDefinitionPage(this.getTaskRepository(), this.getQuery());
            if (this.getWizard() instanceof Wizard) {
                ((Wizard)this.getWizard()).addPage((IWizardPage)this.filterDefinitionPage);
            }
        }
        return this.filterDefinitionPage;
    }

    public String getQueryTitle() {
        return this.getSelectedFilter() != null ? this.getSelectedFilter().getName() : null;
    }

    private NamedFilter getSelectedFilter() {
        if (this.filters != null && this.filters.length > 0) {
            return this.filters[this.filterList.getSelectionIndex()];
        }
        return null;
    }

    public boolean isPageComplete() {
        return this.buttonCustom.getSelection() ? false : this.filterList.getSelectionCount() == 1 && super.isPageComplete();
    }
}

