/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.wizards;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.core.ZipFileUtil;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventLogger;
import org.eclipse.mylyn.internal.monitor.usage.MonitorFileRolloverJob;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.UsageDataException;
import org.eclipse.mylyn.internal.monitor.usage.wizards.Messages;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageDataOverviewPage;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageFileSelectionWizardPage;
import org.eclipse.mylyn.internal.monitor.usage.wizards.UsageUploadWizardPage;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.usage.AbstractStudyBackgroundPage;
import org.eclipse.mylyn.monitor.usage.AbstractStudyQuestionnairePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsageSubmissionWizard
extends Wizard
implements INewWizard {
    public static final String LOG = "log";
    public static final String STATS = "usage";
    private boolean displayBackgroundPage = false;
    private boolean displayFileSelectionPage = false;
    private int uid;
    private final File monitorFile = UiUsageMonitorPlugin.getDefault().getMonitorLogFile();
    private static int processedFileCount = 1;
    private UsageUploadWizardPage uploadPage;
    private UsageFileSelectionWizardPage fileSelectionPage;
    private AbstractStudyQuestionnairePage questionnairePage;
    private AbstractStudyBackgroundPage backgroundPage;
    private UsageDataOverviewPage dataOverviewPage;
    private boolean performUpload = true;
    private List<String> backupFilesToUpload;
    private final StudyParameters studyParameters = UiUsageMonitorPlugin.getDefault().getStudyParameters();
    private File questionnaireFile = null;
    private File backgroundFile = null;

    public UsageSubmissionWizard() {
        this.setTitles();
        this.setNeedsProgressMonitor(true);
        this.init(true);
    }

    private void setTitles() {
        super.setDefaultPageImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.monitor.usage", (String)"icons/wizban/banner-user.gif"));
        super.setWindowTitle(NLS.bind((String)Messages.UsageSubmissionWizard_X_Feedback, (Object)this.studyParameters.getStudyName()));
    }

    private void init(boolean performUpload) {
        Object page;
        this.performUpload = performUpload;
        this.setNeedsProgressMonitor(true);
        this.uid = UiUsageMonitorPlugin.getDefault().getPreferenceStore().getInt(this.studyParameters.getUserIdPreferenceId());
        if (this.uid == 0 || this.uid == -1) {
            this.addBackgroundPage();
            final int[] newUid = new int[1];
            try {
                IWizardContainer service = this.getContainer();
                if (service == null) {
                    service = PlatformUI.getWorkbench().getProgressService();
                }
                service.run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            newUid[0] = UiUsageMonitorPlugin.getDefault().getUploadManager().getNewUid(UsageSubmissionWizard.this.studyParameters, monitor);
                        }
                        catch (UsageDataException e) {
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e.getMessage(), (Throwable)e));
                            newUid[0] = -1;
                        }
                    }
                });
            }
            catch (InvocationTargetException e1) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
            }
            catch (InterruptedException e1) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", e1.getMessage(), (Throwable)e1));
            }
            this.uid = newUid[0];
            UiUsageMonitorPlugin.getDefault().getPreferenceStore().setValue(this.studyParameters.getUserIdPreferenceId(), this.uid);
        }
        if (this.uid == 0 || this.uid == -1) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)Messages.UsageSubmissionWizard_Error_Getting_User_Id, (String)Messages.UsageSubmissionWizard_Unable_To_Get_New_User_Id);
                }
            });
        }
        this.uploadPage = new UsageUploadWizardPage(this, this.studyParameters);
        this.fileSelectionPage = new UsageFileSelectionWizardPage(this, this.studyParameters);
        if (this.studyParameters.isBackgroundEnabled()) {
            this.backgroundPage = page = this.studyParameters.getBackgroundPage();
        }
        if (this.studyParameters.isQuestionnaireEnabled() && performUpload) {
            page = this.studyParameters.getQuestionnairePage();
            this.questionnairePage = page;
        }
        this.dataOverviewPage = new UsageDataOverviewPage(this, this.studyParameters);
        super.setForcePreviousAndNextButtons(true);
    }

    public boolean performFinish() {
        if (!this.performUpload) {
            return true;
        }
        if (this.studyParameters.isQuestionnaireEnabled() && this.performUpload && this.questionnairePage != null) {
            this.questionnaireFile = this.questionnairePage.createFeedbackFile();
        }
        if (this.studyParameters.isBackgroundEnabled() && this.performUpload && this.displayBackgroundPage && this.backgroundPage != null) {
            this.backgroundFile = this.backgroundPage.createFeedbackFile();
        }
        if (this.displayFileSelectionPage) {
            this.backupFilesToUpload = this.fileSelectionPage.getZipFilesSelected();
        }
        Job j = new Job(Messages.UsageSubmissionWizard_Upload_User_Statistics){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(Messages.UsageSubmissionWizard_Uploading_User_Statistics, 3);
                    UsageSubmissionWizard.this.performUpload(monitor);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.mylyn.monitor.usage", 4, "Error uploading statistics", (Throwable)e);
                    StatusHandler.log((IStatus)status);
                    return status;
                }
            }
        };
        j.setPriority(50);
        j.schedule();
        return true;
    }

    public void performUpload(IProgressMonitor monitor) {
        File zipFile;
        String servletUrl = this.studyParameters.getUploadServletUrl();
        MultiStatus uploadStatus = new MultiStatus("org.eclipse.mylyn.monitor.usage", 0, "Error uploading usage data", null);
        if (this.studyParameters.isBackgroundEnabled() && this.performUpload && this.backgroundFile != null) {
            uploadStatus.add(UiUsageMonitorPlugin.getDefault().getUploadManager().uploadFile(servletUrl, this.backgroundFile, this.uid, monitor));
            if (this.backgroundFile.exists()) {
                this.backgroundFile.delete();
            }
        }
        if (this.studyParameters.isQuestionnaireEnabled() && this.performUpload && this.questionnaireFile != null) {
            uploadStatus.add(UiUsageMonitorPlugin.getDefault().getUploadManager().uploadFile(servletUrl, this.questionnaireFile, this.uid, monitor));
            if (this.questionnaireFile.exists()) {
                this.questionnaireFile.delete();
            }
        }
        if ((zipFile = this.zipFilesForUpload()) == null) {
            return;
        }
        uploadStatus.add(UiUsageMonitorPlugin.getDefault().getUploadManager().uploadFile(servletUrl, zipFile, this.uid, monitor));
        if (zipFile.exists()) {
            zipFile.delete();
        }
        if (uploadStatus.isOK()) {
            UiUsageMonitorPlugin.getDefault().resetEventsSinceUpload();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UsageSubmissionWizard_Successful_Upload, (String)Messages.UsageSubmissionWizard_Your_Usage_Statistics_Have_Been_Uploaded);
                }
            });
        } else {
            StatusHandler.log((IStatus)uploadStatus);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Messages.UsageSubmissionWizard_Error_Uploading_Usage_Data, (String)Messages.UsageSubmissionWizard_Error_While_Uploading);
                }
            });
        }
        UiUsageMonitorPlugin.getDefault().getInteractionLogger().startMonitoring();
        UiUsageMonitorPlugin.setPerformingUpload(false);
    }

    public boolean performCancel() {
        UiUsageMonitorPlugin.getDefault().userCancelSubmitFeedback(new Date(), true);
        return true;
    }

    public boolean canFinish() {
        if (!this.performUpload) {
            return true;
        }
        return this.getContainer().getCurrentPage() == this.uploadPage || !this.performUpload;
    }

    public UsageUploadWizardPage getUploadPage() {
        return this.uploadPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        if (this.studyParameters.isQuestionnaireEnabled() && this.performUpload && this.questionnairePage != null) {
            this.addPage((IWizardPage)this.questionnairePage);
        }
        if (this.performUpload) {
            if (UsageFileSelectionWizardPage.unsubmittedLogsExist()) {
                this.addPage((IWizardPage)this.fileSelectionPage);
                this.displayFileSelectionPage = true;
            }
            this.addPage((IWizardPage)this.dataOverviewPage);
            this.addPage((IWizardPage)this.uploadPage);
        }
    }

    public void addBackgroundPage() {
        if (this.studyParameters.isBackgroundEnabled() && this.backgroundPage != null) {
            this.addPage(this.backgroundPage);
            this.displayBackgroundPage = true;
        }
    }

    public String getMonitorFileName() {
        return this.monitorFile.getAbsolutePath();
    }

    public int getUid() {
        return this.uid;
    }

    private File processMonitorFile(File monitorFile) {
        File processedFile = new File(monitorFile.getParent(), "processed-monitor-log-" + this.studyParameters.getCustomizingPlugin() + "-" + processedFileCount++ + ".xml");
        if (processedFile.exists()) {
            processedFile.delete();
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.monitor.usage", "Processed file already exists, overwriting", (Throwable)new Exception()));
        }
        InteractionEventLogger logger = new InteractionEventLogger(processedFile);
        logger.startMonitoring();
        List<InteractionEvent> eventList = logger.getHistoryFromFile(monitorFile);
        Collection<String> filteredIds = this.studyParameters.getFilteredIds();
        if (eventList.size() > 0) {
            for (InteractionEvent event : eventList) {
                if (!this.shouldIncludeEvent(event, filteredIds)) continue;
                logger.interactionObserved(event);
            }
        }
        logger.stopMonitoring();
        return processedFile;
    }

    private boolean shouldIncludeEvent(InteractionEvent event, Collection<String> filteredIds) {
        if (filteredIds.size() == 0) {
            return true;
        }
        for (String filterId : filteredIds) {
            if (!event.getOriginId().startsWith(filterId)) continue;
            return true;
        }
        return false;
    }

    private void addToSubmittedLogFile(String fileName) {
        File submissionLogFile = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath(), "submittedUsageLogs.txt");
        try {
            FileWriter fileWriter = new FileWriter(submissionLogFile, true);
            fileWriter.append(String.valueOf(fileName) + "\n");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Error unzipping backup monitor log files", (Throwable)e));
        }
    }

    private File zipFilesForUpload() {
        UiUsageMonitorPlugin.setPerformingUpload(true);
        UiUsageMonitorPlugin.getDefault().getInteractionLogger().stopMonitoring();
        ArrayList<File> files = new ArrayList<File>();
        File monitorFile = UiUsageMonitorPlugin.getDefault().getMonitorLogFile();
        File fileToUpload = this.processMonitorFile(monitorFile);
        files.add(fileToUpload);
        if (this.displayFileSelectionPage && this.backupFilesToUpload.size() > 0) {
            for (String currFilePath : this.backupFilesToUpload) {
                File file = new File(MonitorFileRolloverJob.getZippedMonitorFileDirPath(), currFilePath);
                if (!file.exists()) continue;
                try {
                    List unzippedFiles = ZipFileUtil.unzipFiles((File)file, (String)System.getProperty("java.io.tmpdir"), (IProgressMonitor)new NullProgressMonitor());
                    if (unzippedFiles.size() <= 0) continue;
                    for (File f : unzippedFiles) {
                        files.add(this.processMonitorFile(f));
                        this.addToSubmittedLogFile(currFilePath);
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Error unzipping backup monitor log files", (Throwable)e));
                }
            }
        }
        UiUsageMonitorPlugin.getDefault().getInteractionLogger().startMonitoring();
        try {
            File zipFile = File.createTempFile(String.valueOf(this.uid) + ".", ".zip");
            ZipFileUtil.createZipFile((File)zipFile, files);
            return zipFile;
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Error uploading", (Throwable)e));
            return null;
        }
    }

    public List<String> getBackupFilesToUpload() {
        return this.backupFilesToUpload;
    }

    public void setBackupFilesToUpload(List<String> backupFilesToUpload) {
        this.backupFilesToUpload = backupFilesToUpload;
    }
}

