/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedPattern {
    private final List<String> groups = new ArrayList<String>();
    private final Pattern pattern;

    public NamedPattern(String namedRegex, int flags) {
        this.pattern = Pattern.compile(this.prepare(namedRegex), flags);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Matcher matcher(CharSequence input) {
        return this.pattern.matcher(input);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String groupName(int i) {
        return this.groups.get(i);
    }

    public String group(String name, Matcher m) {
        int n = this.groups.indexOf(name);
        return n == -1 ? null : m.group(n + 1);
    }

    private String prepare(String namedRegex) {
        StringBuilder regex = new StringBuilder();
        Matcher m = Pattern.compile("\\((\\{(\\S+?)})").matcher(namedRegex);
        int pos = 0;
        while (m.find()) {
            this.groups.add(m.group(2));
            regex.append(namedRegex.substring(pos, m.start(1)));
            pos = m.end();
        }
        return regex.append(namedRegex.substring(pos)).toString();
    }
}

