/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.eclipse.mylyn.internal.xplanner.core.Messages;
import org.eclipse.mylyn.internal.xplanner.core.XPlannerClientListener;
import org.eclipse.mylyn.internal.xplanner.core.service.CachedXPlannerClient;
import org.eclipse.mylyn.internal.xplanner.core.service.XPlannerClient;
import org.eclipse.mylyn.internal.xplanner.core.service.exceptions.AuthenticationException;
import org.eclipse.mylyn.internal.xplanner.core.service.exceptions.ServiceUnavailableException;
import org.xml.sax.SAXException;

public class XPlannerClientManager {
    private final File cacheLocation;
    private final Map<String, XPlannerClient> clientByName = new HashMap<String, XPlannerClient>();
    private final List<XPlannerClientListener> listeners = new ArrayList<XPlannerClientListener>();

    public XPlannerClientManager(File cacheLocation) {
        this.cacheLocation = cacheLocation;
    }

    /*
     * Unable to fully structure code
     */
    protected void start() {
        this.cacheLocation.mkdirs();
        var5_2 = clients = this.cacheLocation.listFiles();
        var4_3 = clients.length;
        var3_4 = 0;
        while (var3_4 < var4_3) {
            block18: {
                clientCache = var5_2[var3_4];
                clientFile = new File(clientCache, "server.ser");
                ois = null;
                try {
                    ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(clientFile)));
                    client = (XPlannerClient)ois.readObject();
                    this.clientByName.put(clientCache.getName(), client);
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException v0) {}
                    }
                    break block18;
                }
                catch (ClassNotFoundException e) {
                    try {
                        e.printStackTrace();
                        ** if (ois == null) goto lbl-1000
                    }
                    catch (Throwable var9_11) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (IOException v2) {}
                        }
                        throw var9_11;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            ois.close();
                        }
                        catch (IOException v1) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block18;
                    }
                }
                if (ois == null) break block18;
                try {
                    ois.close();
                }
                catch (IOException v3) {}
            }
            ++var3_4;
        }
    }

    protected void stop() {
        for (XPlannerClient client : this.clientByName.values()) {
            ObjectOutputStream oos = null;
            try {
                try {
                    File cacheDir = new File(this.cacheLocation, client.getName());
                    cacheDir.mkdirs();
                    oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(cacheDir, "server.ser"))));
                    oos.writeObject(client);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (oos == null) continue;
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (oos != null) {
                    try {
                        oos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (oos == null) continue;
            try {
                oos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String testConnection(String baseUrl, String username, String password, Proxy proxy, String httpUser, String httpPassword) throws AuthenticationException, ServiceUnavailableException {
        if (baseUrl == null || baseUrl.length() == 0) {
            throw new AuthenticationException(Messages.ClientManager_CLIENT_URL_CANNOT_BE_EMPTY);
        }
        XPlannerClient client = null;
        try {
            try {
                new URL(baseUrl).openConnection();
                client = this.createClient("Connection Test", baseUrl, false, username, password, false, proxy, httpUser, httpPassword);
                client.getTask(-1);
            }
            catch (RemoteException re) {
                if (re instanceof AxisFault) {
                    String message = re.getMessage().trim();
                    if (message.startsWith("(401)")) {
                        message = Messages.ClientManager_INVALID_USERNAME_PASSWORD;
                    } else {
                        if (re.getCause() instanceof SocketException) {
                            throw new ServiceUnavailableException(re.getCause().getMessage());
                        }
                        if (re.getCause() instanceof SAXException) {
                            message = "";
                        } else {
                            if (re.getCause() != null) {
                                message = re.getCause().getMessage();
                            }
                            message = message.startsWith(";") ? message.substring(1).trim() : message;
                        }
                    }
                    throw new AuthenticationException(message);
                }
                throw new ServiceUnavailableException(re.getMessage());
            }
            catch (Exception e) {
                throw new ServiceUnavailableException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (client != null) {
                this.removeClient(client);
            }
            throw throwable;
        }
        if (client != null) {
            this.removeClient(client);
        }
        return "XPlanner";
    }

    public XPlannerClient getClient(String name) {
        return this.clientByName.get(name);
    }

    public XPlannerClient[] getAllClients() {
        return this.clientByName.values().toArray(new XPlannerClient[this.clientByName.size()]);
    }

    public XPlannerClient createClient(String name, String baseUrl, boolean hasSlowConnection, String username, String password, boolean useCompression, Proxy proxy, String httpUser, String httpPassword) {
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        CachedXPlannerClient client = new CachedXPlannerClient(name, baseUrl, hasSlowConnection, username, password, useCompression, proxy, httpUser, httpPassword);
        return client;
    }

    public void addClient(XPlannerClient client) {
        if (this.clientByName.containsKey(client.getName())) {
            this.removeClient(client);
        }
        this.clientByName.put(client.getName(), client);
        this.fireClientAddded(client);
    }

    public void removeClient(XPlannerClient client) {
        this.clientByName.remove(client.getName());
        File clientCache = new File(this.cacheLocation, client.getName());
        if (clientCache.exists()) {
            this.recursiveDelete(clientCache);
        }
        this.fireClientRemoved(client);
    }

    public void updateClientDetails(String name, String baseURL, boolean hasSlowConnection, String username, String password) {
        CachedXPlannerClient client = (CachedXPlannerClient)this.clientByName.get(name);
        this.fireClientRemoved(client);
        client.setBaseURL(baseURL);
        client.setSlowConnection(hasSlowConnection);
        client.setCurrentUserName(username);
        client.setCurrentPassword(password);
        this.fireClientAddded(client);
    }

    public void addClientListener(XPlannerClientListener listener) {
        this.listeners.add(listener);
    }

    public void removeClientListener(XPlannerClientListener listener) {
        this.listeners.remove(listener);
    }

    private void fireClientRemoved(XPlannerClient client) {
        for (XPlannerClientListener listener : this.listeners) {
            listener.clientRemoved(client);
        }
    }

    private void fireClientAddded(XPlannerClient client) {
        for (XPlannerClientListener listener : this.listeners) {
            listener.clientAdded(client);
        }
    }

    private void recursiveDelete(File baseFile) {
        if (baseFile.isFile()) {
            baseFile.delete();
        } else {
            File[] children;
            File[] fileArray = children = baseFile.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.recursiveDelete(file);
                ++n2;
            }
            baseFile.delete();
        }
    }
}

