/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.mylyn.internal.monitor.usage.Messages;
import org.eclipse.mylyn.monitor.usage.AbstractStudyBackgroundPage;
import org.eclipse.mylyn.monitor.usage.AbstractStudyQuestionnairePage;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudyParameters {
    private static final String PREF_USER_ID_PREFIX = "org.eclipse.mylyn.user.id";
    private String title;
    private String description;
    private AbstractStudyQuestionnairePage questionnairePage = null;
    private AbstractStudyBackgroundPage backgroundPage = null;
    private long transmitPromptPeriod = 1814400000L;
    private boolean promptForSubmission = false;
    private String acceptedUrlList;
    private String useContactField;
    private String formsConsent;
    private String version;
    private String uploadServletUrl;
    private String idServletUrl;
    private String customizingPlugin;
    private boolean forceObfuscation = false;
    private String usagePageUrl;
    private String studyName;
    private String moreInformationUrl;
    private final Collection<String> filteredIds = new HashSet<String>();

    public String getUploadServletUrl() {
        return this.uploadServletUrl;
    }

    public void setUploadServletUrl(String servletServerUrl) {
        if (servletServerUrl != null) {
            this.uploadServletUrl = servletServerUrl;
        }
    }

    public String getUserIdServletUrl() {
        return this.idServletUrl;
    }

    public void setUserIdServletUrl(String servletUserId) {
        if (servletUserId != null) {
            this.idServletUrl = servletUserId;
        }
    }

    public String getFormsConsent() {
        return this.formsConsent;
    }

    public void setFormsConsent(String formsConsent) {
        if (formsConsent != null) {
            this.formsConsent = formsConsent;
        }
    }

    public long getTransmitPromptPeriod() {
        return this.transmitPromptPeriod;
    }

    public void setTransmitPromptPeriod(long transmitPromptPeriod) {
        this.transmitPromptPeriod = transmitPromptPeriod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description != null) {
            this.description = description;
        }
    }

    public AbstractStudyQuestionnairePage getQuestionnairePage() {
        return this.questionnairePage;
    }

    public void setQuestionnairePage(AbstractStudyQuestionnairePage questionnairePage) {
        if (questionnairePage != null) {
            this.questionnairePage = questionnairePage;
        }
    }

    public AbstractStudyBackgroundPage getBackgroundPage() {
        return this.backgroundPage;
    }

    public void setBackgroundPage(AbstractStudyBackgroundPage backgroundPage) {
        if (backgroundPage != null) {
            this.backgroundPage = backgroundPage;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getAcceptedUrlList() {
        return this.acceptedUrlList;
    }

    public void setAcceptedUrlList(String acceptedUrlList) {
        if (acceptedUrlList != null) {
            this.acceptedUrlList = acceptedUrlList;
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (version != null) {
            this.version = version;
        }
    }

    public String getUseContactField() {
        return this.useContactField;
    }

    public void setUseContactField(String useContactField) {
        if (useContactField != null) {
            this.useContactField = useContactField;
        }
    }

    public void setCustomizingPlugin(String name) {
        this.customizingPlugin = name;
    }

    public String getCustomizingPlugin() {
        return this.customizingPlugin;
    }

    public boolean isBackgroundEnabled() {
        return this.backgroundPage != null;
    }

    public boolean isQuestionnaireEnabled() {
        return this.questionnairePage != null;
    }

    public String getCustomizedByMessage() {
        return NLS.bind((String)Messages.StudyParameters_Previously_Downloaded_X_Monitor, (Object)this.getStudyName(), (Object)this.getCustomizingPlugin());
    }

    public boolean usingContactField() {
        return this.getUseContactField().equals("true");
    }

    public boolean isComplete() {
        return this.title != null && this.description != null && this.uploadServletUrl != null && this.idServletUrl != null;
    }

    public boolean isEmpty() {
        return this.title == null && this.description == null && this.uploadServletUrl == null && this.idServletUrl == null;
    }

    public boolean forceObfuscation() {
        return this.forceObfuscation;
    }

    public void setForceObfuscation(boolean forceObfuscation) {
        this.forceObfuscation = forceObfuscation;
    }

    public String getUploadFileLabel() {
        return "USAGE";
    }

    public void setUsagePageUrl(String usagePageUrl) {
        this.usagePageUrl = usagePageUrl;
    }

    public String getUsagePageUrl() {
        return this.usagePageUrl;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public Collection<String> getFilteredIds() {
        return Collections.unmodifiableCollection(this.filteredIds);
    }

    public void addFilteredIdPattern(String id) {
        if (id != null && id.trim().length() > 0) {
            this.filteredIds.add(id.trim());
        }
    }

    public String getFilteredIdSubmissionText() {
        Collection<String> filteredIds = this.getFilteredIds();
        if (filteredIds.size() != 0) {
            String filteredIdsString = "";
            for (String id : filteredIds) {
                filteredIdsString = String.valueOf(filteredIdsString) + id + "* ";
            }
            return NLS.bind((String)Messages.StudyParameters_Only_Events_From_X_Submitted_To_Y, (Object)filteredIdsString, (Object)this.getStudyName());
        }
        return NLS.bind((String)Messages.StudyParameters_All_Events_Submitted_To_Y, (Object)this.getStudyName());
    }

    public String getUserIdPreferenceId() {
        String preferenceId = PREF_USER_ID_PREFIX;
        if (this.getCustomizingPlugin() != null) {
            preferenceId = String.valueOf(preferenceId) + "." + this.getCustomizingPlugin();
        }
        return preferenceId;
    }

    public void setPromptForSubmission(boolean promptForSubmission) {
        this.promptForSubmission = promptForSubmission;
    }

    public boolean shouldPromptForSubmission() {
        return this.promptForSubmission;
    }

    public void setMoreInformationUrl(String moreInformationUrl) {
        if (moreInformationUrl != null) {
            this.moreInformationUrl = moreInformationUrl;
        }
    }

    public String getMoreInformationUrl() {
        return this.moreInformationUrl;
    }
}

