/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.highlighters;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.context.ui.HighlighterImageDescriptor;
import org.eclipse.mylyn.internal.sandbox.ui.SandboxUiPlugin;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.EditHighlightersAction;
import org.eclipse.mylyn.internal.sandbox.ui.highlighters.Highlighter;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskHighlighterMenuContributor
implements IDynamicSubMenuContributor {
    private static final String CHOOSE_HIGHLIGHTER = "Highlighter";

    public MenuManager getSubMenuManager(final List<IRepositoryElement> selectedElements) {
        MenuManager subMenuManager = new MenuManager(CHOOSE_HIGHLIGHTER);
        for (final Highlighter highlighter : SandboxUiPlugin.getDefault().getHighlighters()) {
            Action action = new Action(){

                public void run() {
                    AbstractTask task = null;
                    for (IRepositoryElement selectedElement : selectedElements) {
                        if (selectedElement instanceof ITask) {
                            task = (AbstractTask)selectedElement;
                        }
                        if (task == null) continue;
                        SandboxUiPlugin.getDefault().setHighlighterMapping(task.getHandleIdentifier(), highlighter.getName());
                        TasksUiInternal.getTaskList().notifyElementChanged((IRepositoryElement)task);
                    }
                }
            };
            if (highlighter.isGradient()) {
                action.setImageDescriptor((ImageDescriptor)new HighlighterImageDescriptor(highlighter.getBase(), highlighter.getHighlightColor()));
            } else {
                action.setImageDescriptor((ImageDescriptor)new HighlighterImageDescriptor(highlighter.getHighlightColor(), highlighter.getHighlightColor()));
            }
            action.setText(highlighter.toString());
            subMenuManager.add((IAction)action);
        }
        subMenuManager.add((IContributionItem)new Separator());
        subMenuManager.add((IAction)new EditHighlightersAction());
        return subMenuManager;
    }
}

