/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.planner;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.provisional.commons.ui.DatePicker;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskElementLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskActivityWizardPage
extends WizardPage {
    private static final int DEFAULT_DAYS = 1;
    private static final String TITLE = "Mylyn Task Activity Report";
    private static final String DESCRIPTION = "Summarizes task activity and assists planning future tasks.";
    private final long DAY = 86400000L;
    protected String[] columnNames = new String[]{"", "Description"};
    private Date reportStartDate = null;
    private Date reportEndDate = null;
    private Button daysRadioButton = null;
    private Button dateRadioButton = null;
    private Text numDays;
    private int numDaysToReport = 0;
    private Table filtersTable;
    private final TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);

    public TaskActivityWizardPage() {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 1;
        this.createReportPeriodGroup(container);
        Label spacer = new Label(container, 0);
        spacer.setText(" ");
        this.createCategorySelectionGroup(container);
        this.setControl((Control)container);
        this.numDays.setFocus();
    }

    private void createReportPeriodGroup(Composite parent) {
        Group reportPeriodGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        reportPeriodGroup.setLayout((Layout)layout);
        reportPeriodGroup.setLayoutData((Object)new GridData(768));
        reportPeriodGroup.setText("Report Period");
        reportPeriodGroup.setFont(parent.getFont());
        this.daysRadioButton = new Button((Composite)reportPeriodGroup, 540688);
        this.daysRadioButton.setText("Number of days prior: ");
        this.daysRadioButton.setSelection(true);
        this.numDays = new Text((Composite)reportPeriodGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = 50;
        this.numDays.setLayoutData((Object)gd);
        this.numDays.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    TaskActivityWizardPage.this.numDaysToReport = Integer.parseInt(TaskActivityWizardPage.this.numDays.getText());
                    TaskActivityWizardPage.this.setErrorMessage(null);
                }
                catch (Exception exception) {
                    TaskActivityWizardPage.this.setErrorMessage("Must be integer");
                    TaskActivityWizardPage.this.numDaysToReport = 0;
                }
            }
        });
        this.numDays.setText("1");
        this.numDaysToReport = 1;
        Label spacer = new Label((Composite)reportPeriodGroup, 0);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)spacer);
        this.dateRadioButton = new Button((Composite)reportPeriodGroup, 540688);
        this.dateRadioButton.setText("Date range        Start:");
        final DatePicker datePicker = new DatePicker((Composite)reportPeriodGroup, 2048, "<start date>", true, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        datePicker.setEnabled(false);
        Calendar startCal = Calendar.getInstance();
        TaskActivityUtil.snapStartOfDay((Calendar)startCal);
        this.reportStartDate = startCal.getTime();
        datePicker.setDate(startCal);
        datePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (datePicker.getDate() != null) {
                    TaskActivityWizardPage.this.reportStartDate = datePicker.getDate().getTime();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label((Composite)reportPeriodGroup, 0).setText("End:");
        final DatePicker endDatePicker = new DatePicker((Composite)reportPeriodGroup, 2048, "<end date>", true, TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour"));
        endDatePicker.setEnabled(false);
        Calendar endCal = Calendar.getInstance();
        TaskActivityUtil.snapEndOfWorkDay((Calendar)endCal);
        this.reportEndDate = endCal.getTime();
        endDatePicker.setDate(endCal);
        endDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (datePicker.getDate() != null) {
                    TaskActivityWizardPage.this.reportEndDate = endDatePicker.getDate().getTime();
                }
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskActivityWizardPage.this.numDays.setEnabled(TaskActivityWizardPage.this.daysRadioButton.getSelection());
                datePicker.setEnabled(TaskActivityWizardPage.this.dateRadioButton.getSelection());
                endDatePicker.setEnabled(TaskActivityWizardPage.this.dateRadioButton.getSelection());
                if (TaskActivityWizardPage.this.daysRadioButton.getSelection()) {
                    TaskActivityWizardPage.this.numDays.setFocus();
                }
                if (TaskActivityWizardPage.this.dateRadioButton.getSelection()) {
                    datePicker.setFocus();
                }
            }
        };
        this.daysRadioButton.addSelectionListener((SelectionListener)radioListener);
        this.dateRadioButton.addSelectionListener((SelectionListener)radioListener);
    }

    private void createCategorySelectionGroup(Composite composite) {
        Group categorySelectionGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        categorySelectionGroup.setLayout((Layout)layout);
        categorySelectionGroup.setLayoutData((Object)new GridData(1808));
        categorySelectionGroup.setText("Category Selection");
        categorySelectionGroup.setFont(composite.getFont());
        this.createFilterTable((Composite)categorySelectionGroup, true);
        ArrayList containers = new ArrayList();
        containers.addAll(TasksUiInternal.getTaskList().getCategories());
        containers.addAll(TasksUiInternal.getTaskList().getQueries());
        Collections.sort(containers, new Comparator<AbstractTaskContainer>(){

            @Override
            public int compare(AbstractTaskContainer c1, AbstractTaskContainer c2) {
                if (c1.equals((Object)TasksUiPlugin.getTaskList().getDefaultCategory())) {
                    return -1;
                }
                if (c2.equals((Object)TasksUiPlugin.getTaskList().getDefaultCategory())) {
                    return 1;
                }
                return c1.getSummary().compareToIgnoreCase(c2.getSummary());
            }
        });
        for (IRepositoryElement container : containers) {
            TableItem item = new TableItem(this.filtersTable, 0);
            item.setImage(this.labelProvider.getImage((Object)container));
            item.setText(container.getSummary());
            item.setData((Object)container);
        }
        int i = 0;
        while (i < this.columnNames.length) {
            this.filtersTable.getColumn(i).pack();
            ++i;
        }
        this.createButtonsGroup((Composite)categorySelectionGroup);
        this.setChecked(true);
    }

    private final void createButtonsGroup(Composite parent) {
        Font font = parent.getFont();
        new Label(parent, 0);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(272));
        Button selectButton = new Button(buttonComposite, 0);
        selectButton.setText("Select All");
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskActivityWizardPage.this.setChecked(true);
            }
        });
        selectButton.setFont(font);
        this.setButtonLayoutData(selectButton);
        Button deselectButton = new Button(buttonComposite, 0);
        deselectButton.setText("Deselect All");
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskActivityWizardPage.this.setChecked(false);
            }
        });
        deselectButton.setFont(font);
        this.setButtonLayoutData(deselectButton);
    }

    private void setChecked(boolean checked) {
        TableItem[] tableItemArray = this.filtersTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(checked);
            ++n2;
        }
    }

    private void createFilterTable(Composite composite, boolean enabled) {
        Font font = composite.getFont();
        this.filtersTable = new Table(composite, 2850);
        this.filtersTable.setEnabled(enabled);
        GridData data = new GridData();
        data.heightHint = this.filtersTable.getItemHeight();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.filtersTable.setLayoutData((Object)data);
        this.filtersTable.setFont(font);
        String[] stringArray = this.columnNames;
        int n = this.columnNames.length;
        int n2 = 0;
        while (n2 < n) {
            String columnName = stringArray[n2];
            TableColumn column = new TableColumn(this.filtersTable, 0);
            column.setText(columnName);
            ++n2;
        }
    }

    public Set<AbstractTaskContainer> getSelectedContainers() {
        TableItem[] items;
        HashSet<AbstractTaskContainer> result = new HashSet<AbstractTaskContainer>();
        TableItem[] tableItemArray = items = this.filtersTable.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked() && item.getData() instanceof ITaskContainer) {
                result.add((AbstractTaskContainer)item.getData());
            }
            ++n2;
        }
        return result;
    }

    public Date getReportStartDate() {
        if (this.dateRadioButton.getSelection() && this.reportStartDate != null) {
            return this.reportStartDate;
        }
        long today = new Date().getTime();
        long lastDay = (long)this.numDaysToReport * 86400000L;
        int offsetToday = Calendar.getInstance().get(10) * 60 * 60 * 1000 + Calendar.getInstance().get(12) * 60 * 1000 + Calendar.getInstance().get(13) * 1000;
        return new Date(today - (long)offsetToday - lastDay);
    }

    public Date getReportEndDate() {
        if (this.dateRadioButton.getSelection() && this.reportEndDate != null) {
            return this.reportEndDate;
        }
        return new Date();
    }
}

