/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.context.ui.ContextUi;
import org.eclipse.mylyn.internal.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.internal.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.DoiOrderSorter;
import org.eclipse.mylyn.internal.context.ui.views.QuickOutlinePatternAndInterestFilter;
import org.eclipse.mylyn.internal.sandbox.ui.DelegatingContextLabelProvider;
import org.eclipse.mylyn.internal.sandbox.ui.views.ContextContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.StringMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedElementsPopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    public static final String ID = "org.eclipse.mylyn.context.ui.navigator.context.related";
    private TreeViewer viewer;
    private Text fFilterText;
    private StringMatcher fStringMatcher;
    private QuickOutlinePatternAndInterestFilter namePatternFilter;
    private final DelegatingContextLabelProvider labelProvider = new DelegatingContextLabelProvider();
    private final DegreeZeroAction zero = new DegreeZeroAction();
    private final DegreeOneAction one = new DegreeOneAction();
    private final DegreeTwoAction two = new DegreeTwoAction();
    private final DegreeThreeAction three = new DegreeThreeAction();
    private final DegreeFourAction four = new DegreeFourAction();
    private final DegreeFiveAction five = new DegreeFiveAction();
    private int degree = 2;
    private boolean syncExecForTesting = true;
    private final AbstractContextListener REFRESH_UPDATE_LISTENER = new AbstractContextListener(){

        public void interestChanged(List<IInteractionElement> nodes) {
            RelatedElementsPopupDialog.this.refresh(nodes.get(nodes.size() - 1), false);
        }

        public void contextActivated(IInteractionContext taskscape) {
            RelatedElementsPopupDialog.this.refreshRelatedElements();
            RelatedElementsPopupDialog.this.refresh(null, true);
        }

        public void contextDeactivated(IInteractionContext taskscape) {
            RelatedElementsPopupDialog.this.refresh(null, true);
        }

        public void contextCleared(IInteractionContext context) {
            RelatedElementsPopupDialog.this.refresh(null, true);
        }

        public void landmarkAdded(IInteractionElement node) {
            RelatedElementsPopupDialog.this.refresh(null, true);
        }

        public void landmarkRemoved(IInteractionElement node) {
            RelatedElementsPopupDialog.this.refresh(null, true);
        }

        public void elementsDeleted(List<IInteractionElement> elements) {
            RelatedElementsPopupDialog.this.refresh(null, true);
        }
    };

    public RelatedElementsPopupDialog(Shell parent, int shellStyle) {
        super(parent, shellStyle, true, true, true, true, true, null, "Context Search");
        ContextCore.getContextManager().addListener(this.REFRESH_UPDATE_LISTENER);
        for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
            provider.setEnabled(true);
        }
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        this.createViewer(parent);
        this.createUIListenersTreeViewer();
        this.addDisposeListener(this);
        return this.viewer.getControl();
    }

    private void createViewer(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ContextContentProvider(this.viewer.getTree(), parent.getShell(), true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new DoiOrderSorter());
        try {
            this.viewer.getControl().setRedraw(false);
            this.viewer.setInput((Object)this.getShell());
        }
        finally {
            this.refreshRelatedElements();
            this.viewer.getControl().setRedraw(true);
        }
    }

    private void createUIListenersTreeViewer() {
        final Tree tree = this.viewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    RelatedElementsPopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                RelatedElementsPopupDialog.this.handleTreeViewerMouseUp(tree, e);
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RelatedElementsPopupDialog.this.gotoSelectedElement();
            }
        });
    }

    private void handleTreeViewerMouseUp(Tree tree, MouseEvent e) {
        if (tree.getSelectionCount() < 1 || e.button != 1 || !tree.equals(e.getSource())) {
            return;
        }
        TreeItem object = tree.getItem(new Point(e.x, e.y));
        TreeItem selection = tree.getSelection()[0];
        if (selection.equals(object)) {
            this.gotoSelectedElement();
        }
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        IInteractionElement node = null;
        if (selectedElement instanceof IInteractionElement) {
            node = (IInteractionElement)selectedElement;
        } else if (!(selectedElement instanceof IInteractionRelation)) {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)selectedElement);
            String handle = bridge.getHandleIdentifier(selectedElement);
            node = ContextCore.getContextManager().getElement(handle);
        }
        if (node != null) {
            ContextUi.getUiBridge((String)node.getContentType()).open(node);
        }
        this.dispose();
    }

    private Object getSelectedElement() {
        if (this.viewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public boolean isFocusControl() {
        return this.viewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.viewer.refresh();
        this.viewer.getControl().setFocus();
        this.fFilterText.setFocus();
        this.getShell().forceFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        if (!this.getPersistLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.viewer != null && this.viewer.getInput() != null;
    }

    public void setInput(Object input) {
        if (input != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(input));
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.viewer = null;
        this.fFilterText = null;
    }

    protected Control createTitleControl(Composite parent) {
        this.createUIWidgetFilterText(parent);
        this.createUIListenersFilterText();
        return this.fFilterText;
    }

    private void createUIWidgetFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(768);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
    }

    private void createUIListenersFilterText() {
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    RelatedElementsPopupDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    RelatedElementsPopupDialog.this.viewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    RelatedElementsPopupDialog.this.viewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    RelatedElementsPopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                int length = text.length();
                if (length > 0) {
                    if (text.charAt(length - 1) != '*') {
                        text = String.valueOf(text) + '*';
                    }
                    if (text.charAt(0) != '*') {
                        text = String.valueOf('*') + text;
                    }
                }
                RelatedElementsPopupDialog.this.setMatcherString(text, true);
            }
        });
    }

    private void setMatcherString(String pattern, boolean update) {
        this.fStringMatcher = pattern.length() == 0 ? null : new StringMatcher(pattern, true, false);
        this.namePatternFilter.setStringMatcher(this.fStringMatcher);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private void stringMatcherUpdated() {
        this.viewer.getControl().setRedraw(false);
        this.viewer.refresh();
        this.viewer.expandAll();
        this.selectFirstMatch();
        this.viewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        Tree tree = this.viewer.getTree();
        Object element = this.findFirstMatchToPattern(tree.getItems());
        if (element != null) {
            this.viewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findFirstMatchToPattern(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findFirstMatchToPattern(item.getItems());
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    void refresh(final IInteractionElement node, final boolean updateLabels) {
        if (!this.syncExecForTesting) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        RelatedElementsPopupDialog.this.internalRefresh(node, updateLabels);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.sandbox.ui", "Context search refresh failed", t));
                    }
                }
            });
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        RelatedElementsPopupDialog.this.internalRefresh(node, updateLabels);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.sandbox.ui", "Context search refresh failed", t));
                    }
                }
            });
        }
    }

    private void internalRefresh(IInteractionElement node, boolean updateLabels) {
        Object toRefresh = null;
        if (node != null) {
            AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((String)node.getContentType());
            toRefresh = bridge.getObjectForHandle(node.getHandleIdentifier());
        }
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getControl().setRedraw(false);
            if (toRefresh != null && this.containsNode(this.viewer.getTree(), toRefresh)) {
                this.viewer.refresh(toRefresh, updateLabels);
            } else if (node == null) {
                this.viewer.refresh();
            }
            this.viewer.expandAll();
            this.viewer.getControl().setRedraw(true);
        }
    }

    private boolean containsNode(Tree tree, Object object) {
        boolean contains = false;
        int i = 0;
        while (i < tree.getItems().length) {
            TreeItem item = tree.getItems()[i];
            if (object.equals(item.getData())) {
                contains = true;
            }
            ++i;
        }
        return contains;
    }

    public void refreshRelatedElements() {
        try {
            for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
                ArrayList<AbstractRelationProvider> providerList = new ArrayList<AbstractRelationProvider>();
                providerList.add(provider);
                this.updateDegreesOfSeparation(providerList, provider.getCurrentDegreeOfSeparation());
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.sandbox.ui", "Could not refresh related elements", t));
        }
    }

    public void updateDegreesOfSeparation(Collection<AbstractRelationProvider> providers, int degreeOfSeparation) {
        for (AbstractRelationProvider provider : providers) {
            this.updateDegreeOfSeparation(provider, degreeOfSeparation);
        }
    }

    public void updateDegreeOfSeparation(AbstractRelationProvider provider, int degreeOfSeparation) {
        ContextCorePlugin.getContextManager().resetLandmarkRelationshipsOfKind(provider.getId());
        ContextUiPlugin.getDefault().getPreferenceStore().setValue(provider.getGenericId(), degreeOfSeparation);
        provider.setDegreeOfSeparation(degreeOfSeparation);
        for (IInteractionElement element : ContextCore.getContextManager().getActiveContext().getInteresting()) {
            if (!element.getInterest().isLandmark()) continue;
            provider.landmarkAdded(element);
        }
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        MenuManager degMenu = new MenuManager("Degree of Separation");
        degMenu.add((IAction)this.zero);
        degMenu.add((IAction)this.one);
        degMenu.add((IAction)this.two);
        degMenu.add((IAction)this.three);
        degMenu.add((IAction)this.four);
        degMenu.add((IAction)this.five);
        this.check(this.getDegree());
        dialogMenu.add((IContributionItem)degMenu);
        dialogMenu.add((IContributionItem)new Separator());
        ShowQualifiedNamesAction qualifyElements = new ShowQualifiedNamesAction(this);
        dialogMenu.add((IAction)qualifyElements);
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    public void setQualifiedNameMode(boolean qualifiedNameMode) {
        DelegatingContextLabelProvider.setQualifyNamesMode(qualifiedNameMode);
        this.refresh(null, true);
    }

    private void refreshAction(int degOfSep) {
        try {
            for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
                ArrayList<AbstractRelationProvider> providerList = new ArrayList<AbstractRelationProvider>();
                providerList.add(provider);
                if (provider.getCurrentDegreeOfSeparation() == degOfSep) continue;
                this.updateDegreesOfSeparation(providerList, degOfSep);
                this.degree = provider.getCurrentDegreeOfSeparation();
            }
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.sandbox.ui", "Could not refresh related elements", t));
        }
    }

    private int getDegree() {
        Iterator iterator = ContextCorePlugin.getDefault().getRelationProviders().iterator();
        if (iterator.hasNext()) {
            AbstractRelationProvider provider = (AbstractRelationProvider)iterator.next();
            this.degree = provider.getCurrentDegreeOfSeparation();
        }
        return this.degree;
    }

    private void check(int degree) {
        this.zero.setChecked(false);
        this.one.setChecked(false);
        this.two.setChecked(false);
        this.three.setChecked(false);
        this.four.setChecked(false);
        this.five.setChecked(false);
        switch (degree) {
            case 0: {
                this.zero.setChecked(true);
                break;
            }
            case 1: {
                this.one.setChecked(true);
                break;
            }
            case 2: {
                this.two.setChecked(true);
                break;
            }
            case 3: {
                this.three.setChecked(true);
                break;
            }
            case 4: {
                this.four.setChecked(true);
                break;
            }
            default: {
                this.five.setChecked(true);
            }
        }
    }

    public void setSyncExecForTesting(boolean asyncRefreshMode) {
        this.syncExecForTesting = asyncRefreshMode;
    }

    public void dispose() {
        ContextCore.getContextManager().removeListener(this.REFRESH_UPDATE_LISTENER);
        super.close();
    }

    protected Point getInitialSize() {
        return new Point(400, 500);
    }

    private class DegreeFiveAction
    extends Action {
        DegreeFiveAction() {
            super(JFaceResources.getString((String)"5: Entire Workspace (slow)"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(5);
            RelatedElementsPopupDialog.this.refreshAction(5);
        }
    }

    private class DegreeFourAction
    extends Action {
        DegreeFourAction() {
            super(JFaceResources.getString((String)"4: Project Dependencies"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(4);
            RelatedElementsPopupDialog.this.refreshAction(4);
        }
    }

    private class DegreeOneAction
    extends Action {
        DegreeOneAction() {
            super(JFaceResources.getString((String)"1: Landmark Resources"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(1);
            RelatedElementsPopupDialog.this.refreshAction(1);
        }
    }

    private class DegreeThreeAction
    extends Action {
        DegreeThreeAction() {
            super(JFaceResources.getString((String)"3: Interesting Projects"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(3);
            RelatedElementsPopupDialog.this.refreshAction(3);
        }
    }

    private class DegreeTwoAction
    extends Action {
        DegreeTwoAction() {
            super(JFaceResources.getString((String)"2: Interesting Resources"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(2);
            RelatedElementsPopupDialog.this.refreshAction(2);
        }
    }

    private class DegreeZeroAction
    extends Action {
        DegreeZeroAction() {
            super(JFaceResources.getString((String)"0: Disabled"), 2);
        }

        public void run() {
            RelatedElementsPopupDialog.this.check(0);
            RelatedElementsPopupDialog.this.refreshAction(0);
        }
    }

    private class ShowQualifiedNamesAction
    extends Action {
        public static final String LABEL = "Qualify Member Names";
        public static final String ID = "org.eclipse.mylyn.ui.views.elements.qualify";
        private final RelatedElementsPopupDialog dialog;

        public ShowQualifiedNamesAction(RelatedElementsPopupDialog dialog) {
            super(LABEL, 2);
            this.dialog = dialog;
            this.setId(ID);
            this.setText(LABEL);
            this.setToolTipText(LABEL);
            this.setImageDescriptor(ContextUiImages.QUALIFY_NAMES);
            this.update(ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(ID));
        }

        public void update(boolean on) {
            this.dialog.setQualifiedNameMode(on);
            this.setChecked(on);
            ContextUiPlugin.getDefault().getPreferenceStore().setValue(ID, on);
        }

        public void run() {
            this.update(!ContextUiPlugin.getDefault().getPreferenceStore().getBoolean(ID));
        }
    }
}

