/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiPlugin;
import org.eclipse.mylyn.internal.bugzilla.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BugzillaAttachmentWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "AttachmentDetailPage";
    private static final String DIALOG_SETTING_RUN_IN_BACKGROUND = "run-in-background";
    private static final String DIALOG_SETTINGS_SECTION_BUGZILLA_ATTACHMENTS_WIZARD = "bugzilla-attachments-wizard";
    private final AttributeEditorFactory factory;
    private final TaskAttribute attachmentAttribute;
    private FormToolkit toolkit;
    private static final int LABEL_WIDTH = 120;
    private static final int COLUMN_GAP = 5;
    private static final int MULTI_ROW_HEIGHT = 55;
    private static final int COLUMN_WIDTH = 100;
    private static final int MULTI_COLUMN_WIDTH = 335;
    private AbstractAttributeEditor commentEditor;
    private ExpandableComposite flagExpandComposite;
    private Button runInBackgroundButton;
    private ScrolledComposite scrolledComposite;
    private Composite scrolledBodyComposite;

    public BugzillaAttachmentWizardPage(Shell parentShell, AttributeEditorFactory factory, TaskAttribute attachmentAttribute, String taskID) {
        super(PAGE_NAME);
        this.setTitle(Messages.BugzillaAttachmentWizardPage_Titel);
        this.setDescription(MessageFormat.format(Messages.BugzillaAttachmentWizardPage_Description, attachmentAttribute.getValue(), taskID));
        this.setImageDescriptor(BugzillaAttachmentWizardPage.createImageDescriptor());
        this.factory = factory;
        this.attachmentAttribute = attachmentAttribute;
    }

    private static ImageDescriptor createImageDescriptor() {
        return ImageDescriptor.createFromURL((URL)BugzillaAttachmentWizardPage.makeIconFileURL());
    }

    private static URL makeIconFileURL() {
        URL baseURL = BugzillaUiPlugin.getDefault().getBundle().getEntry("/icons/");
        if (baseURL == null) {
            return null;
        }
        try {
            return new URL(baseURL, "wizban/banner-attachment-update.gif");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        Composite pageArea = new Composite(parent, 0);
        pageArea.setBackground(parent.getBackground());
        pageArea.setForeground(parent.getDisplay().getSystemColor(24));
        pageArea.setLayout((Layout)new GridLayout(1, false));
        SashForm bottomForm = new SashForm(pageArea, 0);
        bottomForm.setOrientation(512);
        GridLayout bottomLayout = new GridLayout();
        bottomLayout.numColumns = 1;
        bottomForm.setLayout((Layout)bottomLayout);
        GridData bottomLayoutData = new GridData(4, 4, true, true, 1, 1);
        bottomLayoutData.heightHint = 119;
        bottomLayoutData.widthHint = 200;
        bottomForm.setLayoutData((Object)bottomLayoutData);
        int currentColumn = 1;
        int columnCount = 4;
        this.scrolledComposite = new ScrolledComposite((Composite)bottomForm, 768){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(64, 64);
            }
        };
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledBodyComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledBodyComposite.setBackground(pageArea.getBackground());
        this.scrolledBodyComposite.setForeground(this.scrolledBodyComposite.getDisplay().getSystemColor(24));
        GridLayout layout = new GridLayout(4, false);
        this.scrolledBodyComposite.setLayout((Layout)layout);
        this.scrolledComposite.setContent((Control)this.scrolledBodyComposite);
        Composite commentArea = new Composite((Composite)bottomForm, 0);
        commentArea.setBackground(pageArea.getBackground());
        commentArea.setForeground(commentArea.getDisplay().getSystemColor(24));
        layout = new GridLayout(4, false);
        commentArea.setLayout((Layout)layout);
        this.createAttributeEditors(currentColumn, columnCount, this.scrolledBodyComposite);
        this.createCommentEditor(currentColumn, columnCount, commentArea);
        this.createFlagSection(this.scrolledBodyComposite);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.url"), currentColumn, columnCount, this.scrolledBodyComposite);
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).span(4, -1).applyTo((Control)this.scrolledBodyComposite);
        this.runInBackgroundButton = new Button(pageArea, 32);
        this.runInBackgroundButton.setText(Messages.BugzillaAttachmentWizardPage_RunInBackground);
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection(DIALOG_SETTINGS_SECTION_BUGZILLA_ATTACHMENTS_WIZARD);
        if (attachmentsSettings != null) {
            this.runInBackgroundButton.setSelection(attachmentsSettings.getBoolean(DIALOG_SETTING_RUN_IN_BACKGROUND));
        }
        this.setControl((Control)pageArea);
        Dialog.applyDialogFont((Control)pageArea);
        bottomForm.setWeights(new int[]{75, 25});
        this.scrolledComposite.setMinSize(this.scrolledBodyComposite.computeSize(-1, -1, true));
    }

    private void createAttributeEditor(TaskAttribute attribute, int currentColumn, int columnCount, Composite attributeArea) {
        String type = attribute.getMetaData().getType();
        if (type != null) {
            AbstractAttributeEditor editor = this.factory.createEditor(type, attribute);
            if (attribute.getId().equals(BugzillaAttribute.TOKEN.getKey()) || attribute.getId().equals("size") || attribute.getId().equals("task.common.attachment.url")) {
                editor.setReadOnly(true);
            } else {
                editor.setReadOnly(false);
            }
            if (editor.hasLabel() && !"task.common.attachment.patch".equals(attribute.getId())) {
                editor.createLabelControl(attributeArea, this.toolkit);
                Label label = editor.getLabelControl();
                label.setBackground(attributeArea.getBackground());
                label.setForeground(attributeArea.getForeground());
                String labelString = editor.getLabel();
                if (labelString != null && !labelString.equals("")) {
                    GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(120, -1).create();
                    if (currentColumn > 1) {
                        gd.horizontalIndent = 5;
                        gd.widthHint = 125;
                    }
                    label.setLayoutData((Object)gd);
                    ++currentColumn;
                }
            }
            editor.createControl(attributeArea, this.toolkit);
            GridData gd = new GridData(4, 0x1000000, false, false);
            if (BugzillaAttribute.CTYPE.getKey().equals(attribute.getId())) {
                gd.horizontalSpan = 2;
                gd.widthHint = 240;
            } else {
                gd.horizontalSpan = "task.common.attachment.patch".equals(attribute.getId()) ? 1 : (type.equals("boolean") || type.equals("shortText") || type.equals("url") ? 3 : 1);
            }
            editor.getControl().setLayoutData((Object)gd);
            editor.getControl().setBackground(attributeArea.getBackground());
            editor.getControl().setForeground(attributeArea.getForeground());
            currentColumn += gd.horizontalSpan;
            currentColumn %= columnCount;
        }
    }

    private void createAttributeEditors(int currentColumn, int columnCount, Composite attributeArea) {
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.description"), currentColumn, columnCount, attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("filename"), currentColumn, columnCount, attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.size"), currentColumn, columnCount, attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.ctype"), currentColumn, columnCount, attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.patch"), currentColumn, columnCount, attributeArea);
        this.createAttributeEditor(this.attachmentAttribute.getMappedAttribute("task.common.attachment.deprecated"), currentColumn, columnCount, attributeArea);
    }

    private void createCommentEditor(int currentColumn, int columnCount, Composite attributeArea) {
        TaskAttribute commentAttribute = this.attachmentAttribute.getAttribute("comment");
        if (commentAttribute == null) {
            return;
        }
        String type = commentAttribute.getMetaData().getType();
        if (type != null) {
            this.commentEditor = this.factory.createEditor(type, commentAttribute);
            String labelString = this.commentEditor.getLabel();
            if (this.commentEditor.hasLabel()) {
                this.commentEditor.createLabelControl(attributeArea, this.toolkit);
                if (!labelString.equals("")) {
                    Label label = this.commentEditor.getLabelControl();
                    label.setBackground(attributeArea.getBackground());
                    label.setForeground(attributeArea.getForeground());
                    GridData gd = GridDataFactory.fillDefaults().align(131072, 128).hint(120, -1).create();
                    if (currentColumn > 1) {
                        gd.horizontalIndent = 5;
                        gd.widthHint = 125;
                    }
                    label.setLayoutData((Object)gd);
                }
            }
            this.commentEditor.createControl(attributeArea, this.toolkit);
            this.commentEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = 55;
            gd.widthHint = 335;
            gd.horizontalSpan = 3;
            this.commentEditor.getControl().setLayoutData((Object)gd);
            this.commentEditor.getControl().setForeground(attributeArea.getForeground());
            this.toolkit.paintBordersFor(attributeArea);
        }
    }

    private void createFlagSection(Composite container) {
        boolean flagFound = false;
        for (TaskAttribute attribute : this.attachmentAttribute.getAttributes().values()) {
            if (!attribute.getId().startsWith("task.common.kind.flag")) continue;
            flagFound = true;
            break;
        }
        if (!flagFound) {
            return;
        }
        this.flagExpandComposite = this.toolkit.createExpandableComposite(container, 290);
        this.flagExpandComposite.setFont(container.getFont());
        this.flagExpandComposite.setBackground(container.getBackground());
        this.flagExpandComposite.setText(Messages.BugzillaAttachmentWizardPage_Advanced);
        this.flagExpandComposite.setLayout((Layout)new GridLayout(4, false));
        GridDataFactory.fillDefaults().indent(0, 5).grab(true, false).span(4, -1).applyTo((Control)this.flagExpandComposite);
        this.flagExpandComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                BugzillaAttachmentWizardPage.this.scrolledComposite.setMinSize(BugzillaAttachmentWizardPage.this.scrolledBodyComposite.computeSize(-1, -1, true));
                BugzillaAttachmentWizardPage.this.getControl().getShell().pack();
            }
        });
        Composite flagBodyComposite = new Composite((Composite)this.flagExpandComposite, 0);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(2).applyTo(flagBodyComposite);
        flagBodyComposite.setBackground(container.getBackground());
        this.createFlagEditors(2, flagBodyComposite);
        this.flagExpandComposite.setClient((Control)flagBodyComposite);
    }

    private void createFlagEditors(int columnCount, Composite flagBodyComposite) {
        int currentFlagColumn = 1;
        for (TaskAttribute attribute : this.attachmentAttribute.getAttributes().values()) {
            String type;
            if (!attribute.getId().startsWith("task.common.kind.flag") || (type = attribute.getMetaData().getType()) == null) continue;
            AbstractAttributeEditor editor = this.factory.createEditor(type, attribute);
            if (editor.hasLabel()) {
                editor.createLabelControl(flagBodyComposite, this.toolkit);
                Label label = editor.getLabelControl();
                label.setBackground(flagBodyComposite.getBackground());
                label.setForeground(flagBodyComposite.getForeground());
                GridData gd = GridDataFactory.fillDefaults().align(131072, 0x1000000).hint(100, -1).create();
                if (currentFlagColumn > 1) {
                    gd.horizontalIndent = 5;
                    gd.widthHint = 125;
                } else {
                    gd.horizontalIndent = 15;
                }
                label.setLayoutData((Object)gd);
                ++currentFlagColumn;
            }
            editor.createControl(flagBodyComposite, this.toolkit);
            GridData gd = new GridData(4, 0x1000000, false, false);
            gd.widthHint = 335;
            editor.getControl().setLayoutData((Object)gd);
            currentFlagColumn += gd.horizontalSpan;
            currentFlagColumn %= columnCount;
            editor.getControl().setBackground(flagBodyComposite.getBackground());
            editor.getControl().setForeground(flagBodyComposite.getForeground());
        }
    }

    public void dispose() {
        IDialogSettings settings = BugzillaUiPlugin.getDefault().getDialogSettings();
        IDialogSettings attachmentsSettings = settings.getSection(DIALOG_SETTINGS_SECTION_BUGZILLA_ATTACHMENTS_WIZARD);
        if (attachmentsSettings == null) {
            attachmentsSettings = settings.addNewSection(DIALOG_SETTINGS_SECTION_BUGZILLA_ATTACHMENTS_WIZARD);
        }
        attachmentsSettings.put(DIALOG_SETTING_RUN_IN_BACKGROUND, this.runInBackgroundButton.getSelection());
        super.dispose();
    }

    public boolean runInBackground() {
        return this.runInBackgroundButton.getSelection();
    }
}

