/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.provisional.commons.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.internal.provisional.commons.ui.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.SearchHistoryPopUpDialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSearchControl
extends Composite {
    private static final String FIND_TEXT_MEMENTO_ELEMENT = "text";
    private static final String FIND_MEMENTO_ELEMENT = "historyItem";
    private static final String FIND_MEMENTO_TYPE = "filteredTreeFindHistory";
    private static final int MAX_HISTORY_ITEMS = 50;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String FIND_ICON = "org.eclipse.ui.internal.dialogs.FIND_ICON";
    public static final int ICON_SEARCH = 512;
    public static final int ICON_CANCEL = 256;
    private final Text textControl;
    private Control clearControl;
    private Control findControl;
    private final boolean automaticFind;
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private Collection<String> searchHistory = new LinkedHashSet<String>();
    private boolean hasHistorySupport;
    private static Boolean useNativeSearchField;

    static {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
        }
        if ((descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.commons.ui", (String)"$nl$/icons/etool16/find.png")) != null) {
            JFaceResources.getImageRegistry().put(FIND_ICON, descriptor);
        }
    }

    public TextSearchControl(Composite parent, boolean automaticFind, SearchHistoryPopUpDialog historyDialog) {
        super(parent, TextSearchControl.getCompositeStyle(automaticFind, parent));
        this.automaticFind = automaticFind;
        int textStyle = 4;
        int numColumns = 1;
        if (TextSearchControl.useNativeSearchField(automaticFind, parent)) {
            textStyle = automaticFind ? (textStyle |= 0x180) : (textStyle |= 0x380);
        } else {
            super.setBackground(this.getDisplay().getSystemColor(25));
            super.setFont(parent.getFont());
            numColumns = 2;
            if (!automaticFind) {
                ++numColumns;
            }
        }
        GridLayoutFactory.swtDefaults().margins(0, 0).extendedMargins(0, 0, 0, 0).spacing(0, 1).numColumns(numColumns).applyTo((Composite)this);
        this.textControl = new Text((Composite)this, textStyle);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.textControl.setLayoutData((Object)gridData);
        if (useNativeSearchField == null || !useNativeSearchField.booleanValue()) {
            this.findControl = this.createLabelButtonControl(this, this.textControl, JFaceResources.getImageRegistry().getDescriptor(FIND_ICON), Messages.TextControl_AccessibleListenerFindButton, Messages.TextControl_FindToolTip, 512);
            this.clearControl = this.createLabelButtonControl(this, this.textControl, JFaceResources.getImageRegistry().getDescriptor(CLEAR_ICON), WorkbenchMessages.FilteredTree_ClearToolTip, WorkbenchMessages.FilteredTree_ClearToolTip, 256);
            this.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TextSearchControl.this.updateButtonVisibilityAndEnablement();
                }
            });
            this.updateButtonVisibilityAndEnablement();
        }
        if (historyDialog != null) {
            historyDialog.attach(this);
            this.hasHistorySupport = true;
        }
        this.registerListeners();
    }

    public boolean hasHistorySupport() {
        return this.hasHistorySupport;
    }

    private void registerListeners() {
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (TextSearchControl.this.textControl != null && !TextSearchControl.this.textControl.isDisposed()) {
                    TextSearchControl.this.addToSearchHistory(TextSearchControl.this.textControl.getText());
                }
            }
        });
        this.textControl.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (TextSearchControl.this.textControl != null && !TextSearchControl.this.textControl.isDisposed()) {
                    TextSearchControl.this.addToSearchHistory(TextSearchControl.this.textControl.getText());
                }
            }
        });
    }

    private static int getCompositeStyle(boolean automaticFind, Composite parent) {
        if (TextSearchControl.useNativeSearchField(automaticFind, parent)) {
            return 0;
        }
        return 2048;
    }

    private static boolean useNativeSearchField(boolean automaticFind, Composite parent) {
        if (parent != null) {
            if (useNativeSearchField == null) {
                useNativeSearchField = Boolean.FALSE;
                Text testText = null;
                try {
                    int style = 384;
                    if (automaticFind) {
                        style |= 0x200;
                    }
                    useNativeSearchField = new Boolean(((testText = new Text(parent, style)).getStyle() & 0x100) != 0 && (!automaticFind || (testText.getStyle() & 0x200) != 0));
                }
                finally {
                    if (testText != null) {
                        testText.dispose();
                    }
                }
            }
        } else {
            useNativeSearchField = Boolean.FALSE;
        }
        return useNativeSearchField;
    }

    private Control createLabelButtonControl(Composite parent, final Text textControl, ImageDescriptor activeImageDescriptor, final String accessibilityText, String toolTipText, final int detail) {
        Image inactiveImage;
        final Image nativeImage = parent.getDisplay().getSystemImage(detail);
        final Image activeImage = nativeImage != null ? nativeImage : activeImageDescriptor.createImage();
        final Image pressedImage = inactiveImage = new Image((Device)parent.getDisplay(), activeImage, 2);
        final Label labelButton = new Label(parent, 0);
        labelButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelButton.setImage(inactiveImage);
        labelButton.setBackground(parent.getDisplay().getSystemColor(25));
        labelButton.setToolTipText(toolTipText);
        labelButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (nativeImage == null && activeImage != null && !activeImage.isDisposed()) {
                    activeImage.dispose();
                }
                if (inactiveImage != null && !inactiveImage.isDisposed()) {
                    inactiveImage.dispose();
                }
                if (pressedImage != null && !pressedImage.isDisposed()) {
                    pressedImage.dispose();
                }
            }
        });
        labelButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            public void mouseDown(MouseEvent e) {
                labelButton.setImage(pressedImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            labelButton.setImage(mouseInButton ? pressedImage : inactiveImage);
                        }
                    }
                };
                labelButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    labelButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    labelButton.setImage(mouseInButton ? activeImage : inactiveImage);
                    if (mouseInButton && textControl.isEnabled() && textControl.getText().length() > 0) {
                        TextSearchControl.this.notifySelectionChanged(detail);
                    }
                }
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = labelButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        labelButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                if (labelButton.getImage() != activeImage) {
                    labelButton.setImage(activeImage);
                }
            }

            public void mouseExit(MouseEvent e) {
                if (labelButton.getImage() != inactiveImage) {
                    labelButton.setImage(inactiveImage);
                }
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        labelButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = accessibilityText;
            }
        });
        labelButton.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }
        });
        return labelButton;
    }

    public void addTraverseListener(TraverseListener listener) {
        this.textControl.addTraverseListener(listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.textControl.removeTraverseListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.textControl.addSelectionListener(listener);
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.textControl.removeSelectionListener(listener);
        this.selectionListeners.remove(listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.textControl.addModifyListener(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.textControl.removeModifyListener(listener);
    }

    private void notifySelectionChanged(int detail) {
        if (useNativeSearchField != null && useNativeSearchField.booleanValue()) {
            return;
        }
        Event event = new Event();
        event.detail = detail;
        event.widget = this.textControl;
        event.display = this.textControl.getDisplay();
        SelectionEvent e = new SelectionEvent(event);
        for (SelectionListener element : this.selectionListeners) {
            element.widgetDefaultSelected(e);
        }
    }

    private void updateButtonVisibilityAndEnablement() {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            boolean hasText = this.textControl.getText().length() > 0;
            this.setFindButtonVisibility(!hasText || !this.automaticFind);
            this.setClearButtonVisibility(hasText);
        }
    }

    private void setFindButtonVisibility(boolean visible) {
        if (this.findControl != null && !this.findControl.isDisposed()) {
            this.findControl.setVisible(visible);
            if (this.findControl.getLayoutData() instanceof GridData) {
                ((GridData)this.findControl.getLayoutData()).exclude = !visible;
                this.findControl.getParent().layout();
            }
        }
    }

    private void setClearButtonVisibility(boolean visible) {
        if (this.clearControl != null && !this.clearControl.isDisposed()) {
            this.clearControl.setVisible(visible);
            if (this.clearControl.getLayoutData() instanceof GridData) {
                ((GridData)this.clearControl.getLayoutData()).exclude = !visible;
                this.clearControl.getParent().layout();
            }
        }
    }

    public Text getTextControl() {
        return this.textControl;
    }

    public String getText() {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            return this.textControl.getText();
        }
        return "";
    }

    public void setText(String text) {
        if (this.textControl != null && !this.textControl.isDisposed()) {
            this.textControl.setText(text);
        }
    }

    public void setBackground(Color color) {
        if (useNativeSearchField != null && useNativeSearchField.booleanValue()) {
            super.setBackground(color);
        }
    }

    public Collection<String> getSearchHistory() {
        return Collections.unmodifiableCollection(this.searchHistory);
    }

    void addToSearchHistory(String searchString) {
        if (searchString != null && searchString.trim().length() > 0) {
            this.searchHistory.remove(searchString);
            this.searchHistory.add(searchString);
        }
    }

    public void saveState(IMemento memento) {
        if (memento == null) {
            return;
        }
        IMemento rootMemento = memento.createChild(FIND_MEMENTO_TYPE);
        int i = 0;
        for (String text : this.searchHistory) {
            IMemento child = rootMemento.createChild(FIND_MEMENTO_ELEMENT);
            child.putString(FIND_TEXT_MEMENTO_ELEMENT, text);
            if (++i > 50) break;
        }
    }

    public void restoreState(IMemento memento) {
        IMemento[] children;
        if (memento == null) {
            return;
        }
        ArrayList<String> history = new ArrayList<String>();
        IMemento rootMemento = memento.getChild(FIND_MEMENTO_TYPE);
        if (rootMemento != null && (children = rootMemento.getChildren(FIND_MEMENTO_ELEMENT)) != null && children.length > 0) {
            IMemento[] iMementoArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String historyItem = child.getString(FIND_TEXT_MEMENTO_ELEMENT);
                history.add(history.size(), historyItem);
                ++n2;
            }
        }
        if (history != null) {
            this.searchHistory = history;
        }
    }
}

