/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.core;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextChangeEvent {
    private final String contextHandle;
    private final IInteractionContext context;
    private final ContextChangeKind eventKind;
    private final List<IInteractionElement> elements;
    private final boolean isExplicitManipulation;

    public ContextChangeEvent(ContextChangeKind eventKind, String contextHandle, IInteractionContext context, List<IInteractionElement> elements) {
        this(eventKind, contextHandle, context, elements, false);
    }

    public ContextChangeEvent(ContextChangeKind eventKind, String contextHandle, IInteractionContext context, List<IInteractionElement> elements, boolean isExplicitManipulation) {
        Assert.isNotNull((Object)((Object)eventKind));
        this.contextHandle = contextHandle;
        this.context = context;
        this.eventKind = eventKind;
        this.elements = elements == null ? Collections.emptyList() : elements;
        this.isExplicitManipulation = isExplicitManipulation;
    }

    public ContextChangeKind getEventKind() {
        return this.eventKind;
    }

    public List<IInteractionElement> getElements() {
        return this.elements;
    }

    public String getContextHandle() {
        return this.contextHandle;
    }

    public IInteractionContext getContext() {
        return this.context;
    }

    public boolean isActiveContext() {
        IInteractionContext activeContext = ContextCore.getContextManager().getActiveContext();
        return activeContext != null && activeContext.getHandleIdentifier() != null && activeContext.getHandleIdentifier().equals(this.contextHandle);
    }

    public boolean isExplicitManipulation() {
        return this.isExplicitManipulation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextChangeKind {
        PRE_ACTIVATED,
        ACTIVATED,
        DEACTIVATED,
        CLEARED,
        INTEREST_CHANGED,
        LANDMARKS_ADDED,
        LANDMARKS_REMOVED,
        ELEMENTS_DELETED;

    }
}

