/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.usage.StudyParameters;
import org.eclipse.mylyn.internal.monitor.usage.UiUsageMonitorPlugin;
import org.eclipse.mylyn.internal.monitor.usage.preferences.Messages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonColors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class UsageDataPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = Messages.UsageDataPreferencePage_If_Enabled_Mylyn_Monitors;
    private static final long DAYS_IN_MS = 86400000L;
    private Button enableMonitoring;
    private Button enableObfuscation;
    private Button enableSubmission;
    private Text logFileText;
    private Text uploadUrl;
    private Text submissionTime;
    private final StudyParameters studyParameters;

    public UsageDataPreferencePage() {
        this.setPreferenceStore(UiUsageMonitorPlugin.getDefault().getPreferenceStore());
        this.setDescription(DESCRIPTION);
        this.studyParameters = UiUsageMonitorPlugin.getDefault().getStudyParameters();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        if (this.studyParameters.getCustomizingPlugin() != null) {
            Label label = new Label(parent, 0);
            label.setText(this.studyParameters.getCustomizedByMessage());
            label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            if (this.studyParameters.getMoreInformationUrl() != null) {
                ImageHyperlink link = new ImageHyperlink(parent, 0);
                link.setText(Messages.UsageDataPreferencePage_Learn_More);
                link.setForeground(CommonColors.HYPERLINK_WIDGET);
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        UsageDataPreferencePage.this.openMoreInformaionInBrowser();
                    }
                });
            }
        }
        this.createLogFileSection(container);
        this.createUsageSection(container);
        this.updateEnablement();
        return container;
    }

    private void openMoreInformaionInBrowser() {
        String moreInformationUrl = this.studyParameters.getMoreInformationUrl();
        try {
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(new URL(moreInformationUrl));
                }
                catch (Exception e) {
                    StatusHandler.fail((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not open url", (Throwable)e));
                }
            } else {
                IWebBrowser browser = null;
                int flags = 0;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(new URL(moreInformationUrl));
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser init error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.UsageDataPreferencePage_Url_Not_Found, (String)NLS.bind((String)Messages.UsageDataPreferencePage_Unable_To_Open_X, (Object)moreInformationUrl));
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void updateEnablement() {
        if (!this.enableMonitoring.getSelection()) {
            this.logFileText.setEnabled(false);
            this.enableSubmission.setEnabled(false);
            this.submissionTime.setEnabled(false);
        } else {
            this.logFileText.setEnabled(true);
            this.enableSubmission.setEnabled(true);
            if (!this.enableSubmission.getSelection()) {
                this.submissionTime.setEnabled(false);
            } else {
                this.submissionTime.setEnabled(true);
            }
        }
    }

    private void createLogFileSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.UsageDataPreferencePage_Monitoring);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.enableMonitoring = new Button((Composite)group, 32);
        this.enableMonitoring.setText(Messages.UsageDataPreferencePage_Enable_Logging_To);
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled"));
        this.enableMonitoring.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataPreferencePage.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        String logFilePath = UiUsageMonitorPlugin.getDefault().getMonitorLogFile().getPath();
        logFilePath = logFilePath.replaceAll("\\\\", "/");
        this.logFileText = new Text((Composite)group, 2048);
        this.logFileText.setText(logFilePath);
        this.logFileText.setEditable(false);
        this.logFileText.setLayoutData((Object)new GridData(768));
        this.enableObfuscation = new Button((Composite)group, 32);
        this.enableObfuscation.setText(Messages.UsageDataPreferencePage_Obfuscate_Elements_Using);
        this.enableObfuscation.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.obfuscate"));
        if (this.studyParameters.forceObfuscation()) {
            this.enableObfuscation.setSelection(true);
            this.enableObfuscation.setEnabled(false);
        }
        Label obfuscationLablel = new Label((Composite)group, 0);
        obfuscationLablel.setText("SHA" + Messages.UsageDataPreferencePage_Message_Digest_One_Way_Hash);
    }

    private void createUsageSection(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.UsageDataPreferencePage_Usage_Feedback);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.UsageDataPreferencePage_Upload_Url);
        this.uploadUrl = new Text((Composite)group, 2048);
        this.uploadUrl.setEditable(false);
        this.uploadUrl.setLayoutData((Object)new GridData(768));
        this.uploadUrl.setText(this.studyParameters.getUploadServletUrl());
        Label events = new Label((Composite)group, 0);
        events.setText(Messages.UsageDataPreferencePage_Total_Events);
        Label logged = new Label((Composite)group, 0);
        logged.setText("" + this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed"));
        events = new Label((Composite)group, 0);
        events.setText(Messages.UsageDataPreferencePage_Events_Since_Upload);
        logged = new Label((Composite)group, 0);
        logged.setText("" + this.getPreferenceStore().getInt("org.eclipse.mylyn.monitor.ui.events.observed.last.upload"));
        Composite enableSubmissionComposite = new Composite((Composite)group, 0);
        GridLayout submissionGridLayout = new GridLayout(4, false);
        submissionGridLayout.marginWidth = 0;
        submissionGridLayout.marginHeight = 0;
        enableSubmissionComposite.setLayout((Layout)submissionGridLayout);
        this.enableSubmission = new Button(enableSubmissionComposite, 32);
        this.enableSubmission.setText(Messages.UsageDataPreferencePage_Enable_Submission_Every);
        this.enableSubmission.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.enable.submission"));
        this.enableSubmission.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                UsageDataPreferencePage.this.updateEnablement();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.submissionTime = new Text(enableSubmissionComposite, 133120);
        GridData gridData = new GridData();
        gridData.widthHint = 15;
        this.submissionTime.setLayoutData((Object)gridData);
        long submissionFreq = 1814400000L;
        if (UiUsageMonitorPlugin.getDefault().getPreferenceStore().contains("org.eclipse.mylyn.monitor.submission.frequency")) {
            submissionFreq = this.getPreferenceStore().getLong("org.eclipse.mylyn.monitor.submission.frequency");
        }
        long submissionFreqInDays = submissionFreq / 86400000L;
        this.submissionTime.setText("" + submissionFreqInDays);
        this.submissionTime.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        });
        Label label2 = new Label(enableSubmissionComposite, 0);
        label2.setText(Messages.UsageDataPreferencePage_Days);
    }

    public void performDefaults() {
        super.performDefaults();
        this.logFileText.setText(UiUsageMonitorPlugin.getDefault().getMonitorLogFile().getPath());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.obfuscate", this.enableObfuscation.getSelection());
        if (this.enableMonitoring.getSelection()) {
            UiUsageMonitorPlugin.getDefault().startMonitoring();
        } else {
            UiUsageMonitorPlugin.getDefault().stopMonitoring();
        }
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.enable.submission", this.enableSubmission.getSelection());
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.ui.enabled", this.enableMonitoring.getSelection());
        long transmitFrequency = 1814400000L;
        String submissionFrequency = this.submissionTime.getText();
        try {
            transmitFrequency = Integer.parseInt(submissionFrequency);
            transmitFrequency *= 86400000L;
        }
        catch (NumberFormatException numberFormatException) {}
        this.getPreferenceStore().setValue("org.eclipse.mylyn.monitor.submission.frequency", transmitFrequency);
        this.studyParameters.setTransmitPromptPeriod(transmitFrequency);
        return true;
    }

    public boolean performCancel() {
        this.enableMonitoring.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.enabled"));
        this.enableObfuscation.setSelection(this.getPreferenceStore().getBoolean("org.eclipse.mylyn.monitor.ui.obfuscate"));
        return true;
    }
}

