/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.sandbox.ui.SandboxUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SandboxUiPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enableErrorInterest;
    private Button incomingOverlaysButton;
    private Button activateOnOpen;
    private Button showTaskTrimButton;
    private Button useStrikethrough;

    public SandboxUiPreferencePage() {
        this.setPreferenceStore(ContextUiPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createTaskNavigationGroup(container);
        this.createTaskListGroup(container);
        this.createJavaGroup(container);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    private void createTaskNavigationGroup(Composite parent) {
        Group navigationGroup = new Group(parent, 0);
        navigationGroup.setText("Task Navigation");
        navigationGroup.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        navigationGroup.setLayout((Layout)new GridLayout());
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.showTaskTrimButton = new Button((Composite)navigationGroup, 32);
        this.showTaskTrimButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.showTaskTrimButton.setText("Show Task Trim widget");
        this.showTaskTrimButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
    }

    private void createTaskListGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Task List");
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.incomingOverlaysButton = new Button((Composite)group, 32);
        this.incomingOverlaysButton.setText("Use Synchronize View style incoming overlays and placement");
        this.incomingOverlaysButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight"));
        this.activateOnOpen = new Button((Composite)group, 32);
        this.activateOnOpen.setText("Activate tasks on open");
        this.activateOnOpen.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened"));
        this.useStrikethrough = new Button((Composite)group, 32);
        this.useStrikethrough.setText("Use strikethrough for completed tasks");
        this.useStrikethrough.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed"));
    }

    private void createJavaGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        group.setText("Java");
        GridLayout gl = new GridLayout(1, false);
        group.setLayout((Layout)gl);
        this.enableErrorInterest = new Button((Composite)group, 32);
        this.enableErrorInterest.setText("Enable predicted interest of errors (significantly increases view refresh).");
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
    }

    public boolean performOk() {
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.show.trim", this.showTaskTrimButton.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed", this.useStrikethrough.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.activate.when.opened", this.activateOnOpen.getSelection());
        uiPreferenceStore.setValue("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight", this.incomingOverlaysButton.getSelection());
        SandboxUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.java.ui.interest.prediction.errors", this.enableErrorInterest.getSelection());
        return true;
    }

    public boolean performCancel() {
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
        this.useStrikethrough.setSelection(TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed"));
        IPreferenceStore uiPreferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        this.activateOnOpen.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.activate.when.opened"));
        this.showTaskTrimButton.setSelection(uiPreferenceStore.getBoolean("org.eclipse.mylyn.tasks.ui.show.trim"));
        return true;
    }

    public void performDefaults() {
        super.performDefaults();
        this.enableErrorInterest.setSelection(SandboxUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors"));
        this.useStrikethrough.setSelection(TasksUiPlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.tasks.ui.strikethrough.for.completed"));
    }
}

