/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.MultipleQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerQueryWizardUtils;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;

public class EditXPlannerQueryWizard
extends RepositoryQueryWizard {
    private AbstractXPlannerQueryWizardPage queryPage;
    private final IRepositoryQuery query;

    public EditXPlannerQueryWizard(TaskRepository repository, IRepositoryQuery query) {
        super(repository);
        this.setForcePreviousAndNextButtons(true);
        this.query = query;
    }

    public void addPages() {
        this.queryPage = XPlannerQueryWizardUtils.addQueryWizardFirstPage((Wizard)this, this.getTaskRepository(), this.query);
    }

    public boolean performFinish() {
        List<Object> queries = new ArrayList();
        TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)this.query);
        if (this.queryPage instanceof MultipleQueryPage) {
            queries = ((MultipleQueryPage)((Object)this.queryPage)).getQueries();
        } else {
            IRepositoryQuery iRepositoryQuery = this.queryPage.getQuery();
            if (iRepositoryQuery != null) {
                queries.add(iRepositoryQuery);
            }
        }
        for (IRepositoryQuery iRepositoryQuery : queries) {
            this.updateQuery(iRepositoryQuery);
        }
        return true;
    }

    private void updateQuery(IRepositoryQuery query) {
        String queryName;
        String handleIdentifier;
        TasksUiInternal.getTaskList().deleteQuery((RepositoryQuery)query);
        if (query.getConnectorKind().equals("xplanner") && !(handleIdentifier = ((RepositoryQuery)query).getHandleIdentifier()).equals(queryName = query.getSummary())) {
            ((RepositoryQuery)query).setHandleIdentifier(queryName);
        }
        TasksUiInternal.getTaskList().addQuery((RepositoryQuery)query);
        AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.getTaskRepository().getConnectorKind());
        if (connector != null) {
            TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)connector, (RepositoryQuery)((RepositoryQuery)query), null, (boolean)true);
        }
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.queryPage != null) {
            canFinish = this.queryPage.getNextPage() == null ? this.queryPage.isPageComplete() : this.queryPage.getNextPage().isPageComplete();
        }
        return canFinish;
    }
}

