/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.wizard;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.MultipleQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerQueryWizardUtils;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class NewXPlannerQueryWizard
extends Wizard {
    private static final String TITLE = Messages.NewXPlannerQueryWizard_NEW_XPLANNER_QUERY;
    private final TaskRepository repository;
    private AbstractXPlannerQueryWizardPage queryPage;

    public NewXPlannerQueryWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void addPages() {
        this.queryPage = XPlannerQueryWizardUtils.addQueryWizardFirstPage(this, this.repository, null);
    }

    public boolean performFinish() {
        if (this.queryPage instanceof MultipleQueryPage) {
            List<IRepositoryQuery> queries = ((MultipleQueryPage)((Object)this.queryPage)).getQueries();
            HashSet<RepositoryQuery> queriesSet = new HashSet<RepositoryQuery>();
            for (IRepositoryQuery query : queries) {
                RepositoryQuery tempQuery = (RepositoryQuery)query;
                TasksUiInternal.getTaskList().addQuery(tempQuery);
                queriesSet.add(tempQuery);
            }
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            if (connector != null) {
                TasksUiInternal.synchronizeQueries((AbstractRepositoryConnector)connector, (TaskRepository)this.repository, queriesSet, null, (boolean)true);
            }
        } else {
            RepositoryQuery query = (RepositoryQuery)this.queryPage.getQuery();
            NewXPlannerQueryWizard.addQuery(query, this.repository);
        }
        return true;
    }

    public static void addQuery(RepositoryQuery query, TaskRepository repository) {
        if (query != null) {
            TasksUiInternal.getTaskList().addQuery(query);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
            if (connector != null) {
                TasksUiInternal.synchronizeQuery((AbstractRepositoryConnector)connector, (RepositoryQuery)query, null, (boolean)true);
            }
        }
    }

    public boolean canFinish() {
        boolean canFinish = false;
        if (this.queryPage != null) {
            canFinish = this.queryPage.getNextPage() == null ? this.queryPage.isPageComplete() : this.queryPage.getNextPage().isPageComplete();
        }
        return canFinish;
    }
}

