/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.usage.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.monitor.core.collection.IUsageCollector;
import org.eclipse.mylyn.internal.monitor.usage.InteractionEventSummarySorter;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountContentProvider;
import org.eclipse.mylyn.internal.monitor.usage.common.UsageCountLabelProvider;
import org.eclipse.mylyn.internal.monitor.usage.editors.Messages;
import org.eclipse.mylyn.internal.monitor.usage.editors.UsageEditorPart;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class UserStudyEditorPart
extends UsageEditorPart {
    private Table table;
    private TableViewer tableViewer;
    private final String[] columnNames = new String[]{Messages.UserStudyEditorPart_Kind, Messages.UserStudyEditorPart_Id, Messages.UserStudyEditorPart_Num, Messages.UserStudyEditorPart_Last_Delta, Messages.UserStudyEditorPart_Users};

    public UserStudyEditorPart(String id, String title) {
    }

    protected void addSections(Composite composite, FormToolkit toolkit) {
        if (this.editorInput.getReportGenerator().getLastParsedSummary().getSingleSummaries().size() > 0) {
            this.createUsageSection(this.editorComposite, toolkit);
        }
    }

    private void createUsageSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.UserStudyEditorPart_Usage_Details);
        section.setLayout((Layout)new TableWrapLayout());
        section.setLayoutData((Object)new TableWrapData(256));
        Composite container = toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createTable(container, toolkit);
        this.createTableViewer();
        toolkit.paintBordersFor(container);
    }

    private void createTable(Composite parent, FormToolkit toolkit) {
        int style = 101124;
        this.table = toolkit.createTable(parent, style);
        TableLayout tlayout = new TableLayout();
        this.table.setLayout((Layout)tlayout);
        TableWrapData wd = new TableWrapData(256);
        wd.heightHint = 300;
        wd.grabVertical = true;
        this.table.setLayoutData((Object)wd);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 16384, 0);
        column.setText(this.columnNames[0]);
        column.setWidth(60);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserStudyEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(1));
            }
        });
        column = new TableColumn(this.table, 16384, 1);
        column.setText(this.columnNames[1]);
        column.setWidth(370);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserStudyEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(3));
            }
        });
        column = new TableColumn(this.table, 16384, 2);
        column.setText(this.columnNames[2]);
        column.setWidth(50);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserStudyEditorPart.this.tableViewer.setSorter((ViewerSorter)new InteractionEventSummarySorter(4));
            }
        });
        column = new TableColumn(this.table, 16384, 3);
        column.setText(this.columnNames[3]);
        column.setWidth(60);
        column = new TableColumn(this.table, 16384, 4);
        column.setText(this.columnNames[4]);
        column.setWidth(60);
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(this.columnNames);
        this.tableViewer.setContentProvider((IContentProvider)new UsageCountContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new UsageCountLabelProvider());
        this.tableViewer.setInput((Object)this.editorInput.getReportGenerator());
    }

    protected void exportToCSV() {
        try {
            DirectoryDialog dialog = new DirectoryDialog(this.getSite().getWorkbenchWindow().getShell());
            dialog.setText(Messages.UserStudyEditorPart_Specify_Directory_For_Csv_Files);
            String directoryName = dialog.open();
            String filename = String.valueOf(directoryName) + File.separator + "Usage.csv";
            File outputFile = new File(filename);
            FileOutputStream outputStream = new FileOutputStream(outputFile, false);
            for (IUsageCollector collector : this.editorInput.getReportGenerator().getCollectors()) {
                collector.exportAsCSVFile(directoryName);
            }
            int columnCount = this.table.getColumnCount();
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                int i = 0;
                while (i < columnCount - 1) {
                    outputStream.write((String.valueOf(item.getText(i)) + ",").getBytes());
                    ++i;
                }
                outputStream.write(item.getText(columnCount - 1).getBytes());
                outputStream.write("\n".getBytes());
                ++n2;
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (SWTException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Unable to get directory name", (Throwable)e));
        }
        catch (FileNotFoundException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not resolve file", (Throwable)e));
        }
        catch (IOException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.monitor.usage", "Could not write to file", (Throwable)e));
        }
    }
}

