/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.sandbox.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.sandbox.ui.ActiveSearchViewTracker;
import org.eclipse.mylyn.internal.sandbox.ui.InterestInducingProblemListener;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class SandboxUiPlugin
extends AbstractUIPlugin {
    public static final String HIGHLIGHTER_PREFIX = "org.eclipse.mylyn.ui.interest.highlighters";
    public static final String TASK_HIGHLIGHTER_PREFIX = "org.eclipse.mylyn.ui.interest.highlighters.task.";
    public static final String ID_PLUGIN = "org.eclipse.mylyn.sandbox.ui";
    private static SandboxUiPlugin plugin;
    public static final String OVERLAYS_INCOMING_TIGHT = "org.eclipse.mylyn.tasks.ui.overlays.incoming.tight";
    private final ActiveSearchViewTracker activeSearchViewTracker = new ActiveSearchViewTracker();
    private InterestInducingProblemListener problemListener;

    public SandboxUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.java.ui.interest.prediction.errors", false);
        this.problemListener = new InterestInducingProblemListener();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.problemListener);
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors")) {
            this.problemListener.enable();
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow[] windows;
                    workbench.addWindowListener((IWindowListener)SandboxUiPlugin.this.activeSearchViewTracker);
                    IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
                    int n = windows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage[] pages;
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        window.addPageListener((IPageListener)SandboxUiPlugin.this.activeSearchViewTracker);
                        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
                        int n3 = pages.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IWorkbenchPage page = iWorkbenchPageArray[n4];
                            page.addPartListener((IPartListener2)SandboxUiPlugin.this.activeSearchViewTracker);
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, SandboxUiPlugin.ID_PLUGIN, "Sandbox UI initialization failed", (Throwable)e));
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        IWorkbench workbench;
        if (this.problemListener != null) {
            this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.problemListener);
        }
        if ((workbench = PlatformUI.getWorkbench()) != null) {
            IWorkbenchWindow[] windows;
            workbench.removeWindowListener((IWindowListener)this.activeSearchViewTracker);
            IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
            int n = windows.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] pages = window.getPages();
                window.removePageListener((IPageListener)this.activeSearchViewTracker);
                IWorkbenchPage[] iWorkbenchPageArray = pages;
                int n3 = pages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    page.removePartListener((IPartListener2)this.activeSearchViewTracker);
                    ++n4;
                }
                ++n2;
            }
        }
        plugin = null;
        super.stop(context);
    }

    public static SandboxUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.internal.sandbox", (String)path);
    }
}

