/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.web.tasks;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.mylyn.internal.web.tasks.WebRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebTaskListMigrator
extends AbstractTaskListMigrator {
    private static final String KEY_WEB = "Web";
    private static final String KEY_WEB_QUERY = "WebQuery";
    private static final String KEY_WEB_ISSUE = "WebIssue";
    private static final String KEY_URL_TEMPLATE = "UrlTemplate";
    private static final String KEY_REGEXP = "Regexp";
    private static final String KEY_PREFIX = "TaskPrefix";

    public String getConnectorKind() {
        return "web";
    }

    public String getTaskElementName() {
        return KEY_WEB_ISSUE;
    }

    public Set<String> getQueryElementNames() {
        return Collections.singleton(KEY_WEB_QUERY);
    }

    public void migrateTask(ITask task, Element element) {
        if (element.hasAttribute(KEY_PREFIX)) {
            task.setAttribute("taskPrefix", element.getAttribute(KEY_PREFIX));
        } else {
            task.setTaskKind("RSS");
            task.setTaskKey(null);
        }
    }

    public void migrateQuery(IRepositoryQuery query, Element element) {
        String queryUrlTemplate = element.getAttribute(KEY_URL_TEMPLATE);
        String queryPattern = element.getAttribute(KEY_REGEXP);
        String taskPrefix = element.getAttribute(KEY_PREFIX);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (name.startsWith("param_")) {
                params.put(name, attr.getValue());
                query.setAttribute(name, attr.getValue());
            }
            ++i;
        }
        String queryString = query.getUrl();
        if (queryUrlTemplate == null || queryUrlTemplate.length() == 0) {
            queryUrlTemplate = query.getUrl();
            TaskRepository repository = TasksUi.getRepositoryManager().getRepository("web", query.getRepositoryUrl());
            queryString = WebRepositoryConnector.evaluateParams(queryUrlTemplate, params, repository);
        }
        query.setUrl(queryString);
        query.setAttribute(KEY_URL_TEMPLATE, queryUrlTemplate);
        query.setAttribute(KEY_REGEXP, queryPattern);
        query.setAttribute("taskPrefix", taskPrefix);
    }
}

