/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.xplanner.ui.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.xplanner.ui.XPlannerUiPlugin;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.AbstractXPlannerQueryWizardPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.ErrorQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.Messages;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerCustomQueryPage;
import org.eclipse.mylyn.internal.xplanner.ui.wizard.XPlannerQuerySelectionWizardPage;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class XPlannerQueryWizardUtils {
    private static final boolean SHOW_SELECT_QUERY_PAGE = false;

    private XPlannerQueryWizardUtils() {
    }

    public static boolean isShowSelectQueryPage() {
        return false;
    }

    public static AbstractXPlannerQueryWizardPage addQueryWizardFirstPage(Wizard wizard, TaskRepository repository, IRepositoryQuery existingQuery) {
        AbstractXPlannerQueryWizardPage queryPage = null;
        try {
            queryPage = XPlannerQueryWizardUtils.isShowSelectQueryPage() ? new XPlannerQuerySelectionWizardPage(repository) : new XPlannerCustomQueryPage(repository, existingQuery);
            queryPage.setWizard((IWizard)wizard);
            wizard.addPage((IWizardPage)queryPage);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CoreException) {
                XPlannerUiPlugin.log(e.getCause(), Messages.XPlannerQueryWizardUtils_COULD_NOT_CREATE_QUERY_PAGE_MESSAGE);
                queryPage = new ErrorQueryPage(repository, e.getCause().getMessage());
                queryPage.setWizard((IWizard)wizard);
                wizard.addPage((IWizardPage)queryPage);
            }
            throw e;
        }
        return queryPage;
    }
}

