/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.internal.core.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.util.ProgressUtil;
import org.eclipse.mylyn.builds.internal.core.util.BuildsConstants;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IOperationMonitor;

public abstract class BuildJob
extends Job {
    IStatus status;
    protected final IDelegatingProgressMonitor monitor = new DelegatingProgressMonitor();

    public BuildJob(String name) {
        super(name);
    }

    public IBuildElement getElement() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        IBuildElement element;
        if (adapter == IBuildElement.class && (element = this.getElement()) != null) {
            return element;
        }
        return super.getAdapter(adapter);
    }

    public boolean belongsTo(Object family) {
        return family == BuildsConstants.JOB_FAMILY;
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected void setStatus(IStatus status) {
        this.status = status;
    }

    /*
     * Loose catch block
     */
    public IStatus run(IProgressMonitor jobMonitor) {
        try {
            IStatus iStatus;
            this.monitor.setCanceled(false);
            this.monitor.attach(jobMonitor);
            try {
                IOperationMonitor progress = ProgressUtil.convert((IProgressMonitor)this.monitor);
                if (!this.isUser()) {
                    progress.addFlag(IOperationMonitor.OperationFlag.BACKGROUND);
                }
                iStatus = this.doExecute(progress);
            }
            catch (OperationCanceledException operationCanceledException) {
                IStatus iStatus2 = Status.CANCEL_STATUS;
                this.monitor.done();
                this.monitor.detach(jobMonitor);
                return iStatus2;
                {
                    catch (Throwable throwable) {
                        this.monitor.done();
                        throw throwable;
                    }
                }
            }
            this.monitor.done();
            return iStatus;
        }
        finally {
            this.monitor.detach(jobMonitor);
        }
    }

    protected abstract IStatus doExecute(IOperationMonitor var1);

    public IDelegatingProgressMonitor getMonitor() {
        return this.monitor;
    }
}

