/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.http;

import java.io.IOException;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.auth.DigestScheme;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.commons.core.IOperationMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;

public class CommonHttpClient {
    static final boolean DEBUG_AUTH = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.mylyn.commons.http/debug/authentication"));
    private static final String DEFAULT_USER_AGENT = "Apache XML-RPC/3.0";
    volatile DigestScheme digestScheme;
    final HttpClient httpClient;
    private final AbstractWebLocation location;

    private static HttpClient createHttpClient(String userAgent) {
        HttpClient httpClient = new HttpClient();
        httpClient.setHttpConnectionManager(WebUtil.getConnectionManager());
        httpClient.getParams().setCookiePolicy("rfc2109");
        WebUtil.configureHttpClient((HttpClient)httpClient, (String)userAgent);
        return httpClient;
    }

    public CommonHttpClient(AbstractWebLocation location) {
        this(location, CommonHttpClient.createHttpClient(DEFAULT_USER_AGENT));
    }

    public CommonHttpClient(AbstractWebLocation location, HttpClient client) {
        this.location = location;
        this.httpClient = CommonHttpClient.createHttpClient(DEFAULT_USER_AGENT);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public int execute(HttpMethodBase method, IOperationMonitor monitor) throws IOException {
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.getHttpClient(), (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        return WebUtil.execute((HttpClient)this.getHttpClient(), (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
    }

    public synchronized HostConfiguration getHostConfiguration(IOperationMonitor monitor) throws IOException {
        if (this.location.getUrl() == null) {
            throw new IOException("No URL specified.");
        }
        return WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
    }

    protected void authenticate(IOperationMonitor monitor) throws IOException {
    }

    protected boolean needsReauthentication(int code, IProgressMonitor monitor) throws IOException {
        AuthenticationType authenticationType;
        if (code == 401 || code == 403) {
            authenticationType = AuthenticationType.HTTP;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        try {
            this.location.requestCredentials(authenticationType, null, monitor);
        }
        catch (UnsupportedRequestException e) {
            IOException ioe = new IOException(HttpStatus.getStatusText((int)code));
            ioe.initCause(e);
            throw ioe;
        }
        catch (UnsupportedOperationException e) {
            IOException ioe = new IOException(HttpStatus.getStatusText((int)code));
            ioe.initCause(e);
            throw ioe;
        }
        return true;
    }
}

