/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.core.util.ProgressUtil;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.commons.repositories.RepositoryValidator;

public class BuildServerValidator
extends RepositoryValidator {
    private final IBuildServer server;

    public BuildServerValidator(IBuildServer server) {
        super(server.getLocation());
        this.server = server;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            BuildServerBehaviour behaviour = ((BuildServer)this.server).getBehaviour();
            return behaviour.validate(ProgressUtil.convert((IProgressMonitor)monitor));
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.mylyn.builds.ui", "Server validation failed", (Throwable)e);
        }
    }

    public IBuildServer getServer() {
        return this.server;
    }
}

