/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui;

import java.util.Date;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.IHealthReport;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.builds.ui.spi.BuildConnectorUi;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.view.BuildSummaryLabelProvider;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonFonts;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.RichToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BuildToolTip
extends RichToolTip {
    private static final int MAX_TEXT_WIDTH = 300;
    private static final int MAX_WIDTH = 600;

    public BuildToolTip(Control control) {
        super(control);
    }

    public ViewerCell getData() {
        Object data = super.getData();
        return (ViewerCell)data;
    }

    protected Composite createToolTipArea(Event event, Composite parent) {
        IBuildPlan plan;
        ViewerCell cell = this.getData();
        IBuildElement data = (IBuildElement)cell.getItem().getData();
        parent.setLayout((Layout)new GridLayout(2, false));
        BuildConnectorUi connectorUi = BuildsUi.getConnectorUi(data.getServer());
        if (data instanceof IBuildPlan) {
            StyledString ss = new StyledString();
            ss.append(data.getLabel(), new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = CommonFonts.BOLD;
                    textStyle.foreground = BuildToolTip.this.getTitleColor();
                }
            });
            plan = (IBuildPlan)data;
            if (plan.getStatus() != null) {
                StringBuilder sb = new StringBuilder(" [");
                if (plan.getState() == BuildState.RUNNING) {
                    sb.append(NLS.bind((String)"running, ", null));
                }
                if (plan.getFlags().contains(BuildState.QUEUED)) {
                    sb.append(NLS.bind((String)"queued, ", null));
                }
                switch (plan.getStatus()) {
                    case SUCCESS: {
                        sb.append(NLS.bind((String)"success", null));
                        break;
                    }
                    case FAILED: {
                        sb.append(NLS.bind((String)"failed", null));
                        break;
                    }
                    case UNSTABLE: {
                        sb.append(NLS.bind((String)"unstable", null));
                        break;
                    }
                    case ABORTED: {
                        sb.append(NLS.bind((String)"aborted", null));
                        break;
                    }
                    case DISABLED: {
                        sb.append(NLS.bind((String)"disabled", null));
                        break;
                    }
                }
                sb.append(']');
                ss.append(sb.toString(), StyledString.DECORATIONS_STYLER);
            }
            this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)connectorUi.getImageDescriptor()), ss);
        } else {
            this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)connectorUi.getImageDescriptor()), data.getLabel(), true);
        }
        Date refreshDate = data.getRefreshDate();
        if (refreshDate != null) {
            String refreshString = DateUtil.getRelative((long)refreshDate.getTime());
            this.addIconAndLabel(parent, null, NLS.bind((String)"Refreshed {0}", (Object)refreshString), false);
        }
        if (data instanceof IBuildPlan) {
            plan = (IBuildPlan)data;
            if (plan.getLastBuild() != null) {
                this.addBuild(parent, plan.getLastBuild());
            }
            this.addPlan(parent, plan);
        }
        if (data instanceof IBuildElement && data.getElementStatus() != null) {
            this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)CommonImages.WARNING), data.getElementStatus().getMessage());
        }
        if (data instanceof IBuildServer) {
            int passed = 0;
            int failed = 0;
            int unstable = 0;
            int aborted = 0;
            int disabled = 0;
            List plans = BuildsUiInternal.getModel().getPlans((IBuildServer)((BuildServer)data));
            for (IBuildPlan iBuildPlan : plans) {
                if (!iBuildPlan.isSelected() || iBuildPlan.getStatus() == null) continue;
                switch (iBuildPlan.getStatus()) {
                    case SUCCESS: {
                        ++passed;
                        break;
                    }
                    case FAILED: {
                        ++failed;
                        break;
                    }
                    case UNSTABLE: {
                        ++unstable;
                        break;
                    }
                    case ABORTED: {
                        ++aborted;
                        break;
                    }
                    case DISABLED: {
                        ++disabled;
                        break;
                    }
                }
            }
            if (passed > 0) {
                this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)BuildImages.STATUS_PASSED), NLS.bind((String)"{0} passed builds of a total of {1}", (Object[])new Object[]{passed, plans.size()}));
            }
            if (failed > 0) {
                this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)BuildImages.STATUS_FAILED), NLS.bind((String)"{0} failed builds", (Object[])new Object[]{failed}));
            }
            if (unstable > 0) {
                this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)BuildImages.STATUS_UNSTABLE), NLS.bind((String)"{0} unstable builds", (Object[])new Object[]{unstable}));
            }
            if (disabled > 0) {
                this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)BuildImages.STATUS_DISABLED), NLS.bind((String)"{0} disabled builds", (Object[])new Object[]{disabled}));
            }
            if (unstable > 0) {
                this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)BuildImages.STATUS_DISABLED), NLS.bind((String)"{0} aborted builds", (Object[])new Object[]{unstable}));
            }
        }
        return parent;
    }

    private void addBuild(Composite parent, IBuild build) {
        String text = "";
        String time = DateUtil.getRelative((long)build.getTimestamp());
        if (time.length() > 0) {
            text = NLS.bind((String)"Last built {0}, ", (Object)time);
        }
        this.addLabel(parent, String.valueOf(text) + NLS.bind((String)"took {0}", (Object)DateUtil.getFormattedDurationShort((long)build.getDuration())));
        this.addLabel(parent, NLS.bind((String)"Build {0} [{1}]", (Object)build.getLabel(), (Object)build.getServer().getLabel()));
    }

    private void addPlan(Composite parent, IBuildPlan plan) {
        for (IHealthReport healthReport : plan.getHealthReports()) {
            this.addIconAndLabel(parent, BuildSummaryLabelProvider.getHealthImageDescriptor(healthReport.getHealth()), healthReport.getDescription());
        }
    }

    protected void addLabel(Composite parent, String text) {
        this.addIconAndLabel(parent, null, text, false);
    }

    protected void addIconAndLabel(Composite parent, ImageDescriptor descriptor, String text) {
        this.addIconAndLabel(parent, CommonImages.getImage((ImageDescriptor)descriptor), text, false);
    }

    protected void addIconAndLabel(Composite parent, Image image, String text) {
        this.addIconAndLabel(parent, image, text, false);
    }

    protected void addIconAndLabel(Composite parent, Image image, String text, boolean bold) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setForeground(parent.getDisplay().getSystemColor(28));
        imageLabel.setBackground(parent.getDisplay().getSystemColor(29));
        imageLabel.setLayoutData((Object)new GridData(34));
        imageLabel.setImage(image);
        Label textLabel = new Label(parent, 64);
        if (bold) {
            textLabel.setFont(CommonFonts.BOLD);
        }
        textLabel.setForeground(this.getTitleColor());
        textLabel.setBackground(parent.getDisplay().getSystemColor(29));
        textLabel.setLayoutData((Object)new GridData(772));
        textLabel.setText(CommonUiUtil.toLabel((String)text));
        int width = Math.min(textLabel.computeSize((int)-1, (int)-1).x, 600);
        GridDataFactory.fillDefaults().align(4, 1).hint(width, -1).applyTo((Control)textLabel);
    }

    protected void addIconAndLabel(Composite parent, Image image, StyledString text) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setForeground(parent.getDisplay().getSystemColor(28));
        imageLabel.setBackground(parent.getDisplay().getSystemColor(29));
        imageLabel.setLayoutData((Object)new GridData(34));
        imageLabel.setImage(image);
        StyledText textLabel = new StyledText(parent, 0);
        textLabel.setText(text.getString());
        textLabel.setStyleRanges(text.getStyleRanges());
        textLabel.setBackground(parent.getDisplay().getSystemColor(29));
        textLabel.setLayoutData((Object)new GridData(772));
        int width = Math.min(textLabel.computeSize((int)-1, (int)-1).x, 600);
        GridDataFactory.fillDefaults().align(4, 1).hint(width, -1).applyTo((Control)textLabel);
    }
}

