/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.builds.ui.spi.BuildConnectorUi;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.builds.ui.actions.NewTaskFromBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.RunBuildAction;
import org.eclipse.mylyn.internal.builds.ui.actions.ShowHistoryAction;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildDetailsPage;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorInput;
import org.eclipse.mylyn.internal.builds.ui.view.BuildLabelProvider;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BuildEditor
extends SharedHeaderFormEditor {
    private IBuildPlan plan;

    protected void addPages() {
        BuildDetailsPage buildDetailsPage = new BuildDetailsPage((FormEditor)this, "Details");
        try {
            this.addPage((IFormPage)buildDetailsPage);
        }
        catch (PartInitException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", "Could not create Build editor.", (Throwable)e));
        }
        this.setActivePage(0);
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
        EditorUtil.initializeScrollbars((ScrolledForm)this.getHeaderForm().getForm());
        this.updateHeader();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public BuildEditorInput getEditorInput() {
        return (BuildEditorInput)super.getEditorInput();
    }

    public IBuildPlan getPlan() {
        return this.plan;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof BuildEditorInput)) {
            throw new PartInitException("Unsupported class for editor input ''" + input.getClass() + "''");
        }
        super.init(site, input);
        this.plan = ((BuildEditorInput)input).getPlan();
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    private void updateHeader() {
        BuildEditorInput input = this.getEditorInput();
        if (input.getBuild() != null) {
            this.getHeaderForm().getForm().setImage(CommonImages.getImage((ImageDescriptor)BuildLabelProvider.getImageDescriptor(input.getBuild().getStatus())));
            this.getHeaderForm().getForm().setText(NLS.bind((String)"Build {0}", (Object)input.getBuild().getLabel()));
        } else {
            BuildConnectorUi connectorUi = BuildsUi.getConnectorUi(this.plan.getServer());
            this.getHeaderForm().getForm().setImage(CommonImages.getImage((ImageDescriptor)connectorUi.getImageDescriptor()));
            this.getHeaderForm().getForm().setText("Build");
        }
        this.setTitleToolTip(input.getToolTipText());
        this.setPartName(input.getName());
        this.updateToolBar();
    }

    private void updateToolBar() {
        Form form = this.getHeaderForm().getForm().getForm();
        IToolBarManager toolBarManager = form.getToolBarManager();
        toolBarManager.add((IContributionItem)new GroupMarker("group.file"));
        RunBuildAction runBuildAction = new RunBuildAction();
        runBuildAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getPlan()));
        toolBarManager.add((IAction)runBuildAction);
        ShowHistoryAction historyAction = new ShowHistoryAction();
        historyAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getPlan()));
        toolBarManager.add((IAction)historyAction);
        toolBarManager.add((IContributionItem)new Separator("group.edit"));
        if (this.getEditorInput().getBuild() != null) {
            NewTaskFromBuildAction newTaskFromBuildAction = new NewTaskFromBuildAction();
            newTaskFromBuildAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.getEditorInput().getBuild()));
            toolBarManager.add((IAction)newTaskFromBuildAction);
        }
        toolBarManager.add((IContributionItem)new Separator("group.open"));
        Action openWithBrowserAction = new Action(){

            public void run() {
                WorkbenchUtil.openUrl((String)BuildEditor.this.plan.getUrl());
            }
        };
        openWithBrowserAction.setImageDescriptor(CommonImages.WEB);
        openWithBrowserAction.setToolTipText(Messages.AbstractTaskEditorPage_Open_with_Web_Browser);
        toolBarManager.add((IAction)openWithBrowserAction);
        toolBarManager.update(true);
    }
}

