/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuildPlan;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildStatusFilter
extends ViewerFilter {
    private Set<BuildStatus> filtered = Collections.emptySet();

    public void addFiltered(BuildStatus status) {
        if (this.filtered.isEmpty()) {
            this.filtered = EnumSet.of(status);
        } else {
            this.filtered.add(status);
        }
    }

    public Set<BuildStatus> getFiltered() {
        return this.filtered;
    }

    public void removeFiltered(BuildStatus status) {
        this.filtered.remove(status);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.filtered.isEmpty() && element instanceof IBuildPlan) {
            return !this.filtered.contains(((IBuildPlan)element).getStatus());
        }
        return true;
    }

    public void setFiltered(EnumSet<BuildStatus> statuses) {
        this.filtered = new HashSet<BuildStatus>(statuses);
    }
}

