/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.util.HashMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.builds.ui.BuildsUiUtil;
import org.eclipse.mylyn.internal.builds.ui.view.NewBuildServerAction;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class NewBuildServerMenuAction
extends Action
implements IMenuCreator {
    private static final String VIEWS_SHOW_VIEW_PARM_ID = "org.eclipse.ui.views.showView.viewId";
    private MenuManager manager;
    private Menu menu;

    public NewBuildServerMenuAction() {
        this.setMenuCreator(this);
        this.setToolTipText("New Build Server Location");
        this.setImageDescriptor(TasksUiImages.REPOSITORY_NEW);
    }

    private void addActions(IMenuManager manager) {
        NewBuildServerAction action = new NewBuildServerAction();
        manager.add((IAction)action);
        boolean separatorAdded = false;
        for (final IBuildServer server : BuildsUi.getModel().getServers()) {
            if (!separatorAdded) {
                manager.add((IContributionItem)new Separator());
                separatorAdded = true;
            }
            Action openAction = new Action(){

                public void run() {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            BuildsUiUtil.openPropertiesDialog(server);
                        }
                    });
                }
            };
            openAction.setText(NLS.bind((String)"Properties for {0}", (Object)server.getLocation().getLabel()));
            manager.add((IAction)openAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add(this.createShowRepositoriesViewItem());
    }

    private IContributionItem createShowRepositoriesViewItem() {
        CommandContributionItemParameter parm = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.mylyn.commons.team.navigator.Repositories", "org.eclipse.ui.views.showView", 8);
        HashMap<String, String> targetId = new HashMap<String, String>();
        targetId.put(VIEWS_SHOW_VIEW_PARM_ID, "org.eclipse.mylyn.commons.team.navigator.Repositories");
        parm.parameters = targetId;
        parm.label = "Show Repositories View";
        if (parm.label.length() > 0) {
            parm.mnemonic = parm.label.substring(0, 1);
        }
        return new CommandContributionItem(parm);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.initMenuManager();
        this.menu = this.manager.createContextMenu(parent);
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        this.initMenuManager();
        this.menu = new Menu(parent);
        this.manager.fill(this.menu, 0);
        return this.menu;
    }

    private void initMenuManager() {
        this.dispose();
        this.manager = new MenuManager();
        this.addActions((IMenuManager)this.manager);
    }

    public void run() {
        new NewBuildServerAction().run();
    }
}

