/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.view;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenWithBrowserAction
extends BaseSelectionListenerAction {
    public OpenWithBrowserAction() {
        super("Open with Browser");
        this.setToolTipText("Open with Browser");
        this.setImageDescriptor(CommonImages.BROWSER_OPEN_TASK);
    }

    public void run() {
        List<URI> uris = this.getUris(this.getStructuredSelection());
        for (URI uri : uris) {
            WorkbenchUtil.openUrl((String)uri.toString());
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getUris(selection).size() > 0;
    }

    public List<URI> getUris(IStructuredSelection selection) {
        ArrayList<URI> uris = new ArrayList<URI>(selection.size());
        for (Object object : selection.toList()) {
            IBuildElement element;
            if (!(object instanceof IBuildElement) || (element = (IBuildElement)object).getUrl() == null) continue;
            try {
                uris.add(new URI(element.getUrl()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return uris;
    }
}

