/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.TimeoutInputStream;

public class TimeoutInputStreamTest
extends TestCase {
    volatile int value;
    volatile IOException e;
    InputStream stream = new InputStream(){

        public int read() throws IOException {
            if (TimeoutInputStreamTest.this.e != null) {
                throw TimeoutInputStreamTest.this.e;
            }
            return TimeoutInputStreamTest.this.value;
        }
    };
    private ServerSocket server;

    protected void setUp() throws Exception {
        TimeoutInputStreamTest.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
        this.server = new ServerSocket();
        new Thread(){

            public void run() {
                try {
                    TimeoutInputStreamTest.this.server.accept();
                }
                catch (IOException iOException) {}
            }
        }.start();
    }

    protected void tearDown() throws Exception {
        this.server.close();
    }

    public void testClose() throws Exception {
        TimeoutInputStream in = new TimeoutInputStream(this.stream, 1, 500L, 500L);
        TimeoutInputStreamTest.assertEquals((int)0, (int)in.read());
        this.value = -1;
        in.read();
        TimeoutInputStreamTest.assertEquals((int)-1, (int)in.read());
        in.close();
        Thread.sleep(200L);
        TimeoutInputStreamTest.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
    }

    public void testCloseTimeout() throws Exception {
        block6: {
            this.e = new SocketTimeoutException();
            TimeoutInputStream in = new TimeoutInputStream(this.stream, 1, 500L, 500L);
            try {
                try {
                    in.read();
                    TimeoutInputStreamTest.fail((String)"expected InterruptedIOException");
                }
                catch (InterruptedIOException interruptedIOException) {
                    in.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 30000L && ((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount() > 0) {
            Thread.sleep(500L);
        }
        TimeoutInputStreamTest.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
    }
}

