/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.SSLHandshakeException;
import junit.framework.TestCase;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.commons.tests.support.TestProxy;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.PollingInputStream;
import org.eclipse.mylyn.internal.commons.net.PollingSslProtocolSocketFactory;
import org.eclipse.mylyn.internal.commons.net.TimeoutInputStream;

public class WebUtilTest
extends TestCase {
    private TestProxy testProxy;
    private HttpClient client;
    private InetSocketAddress proxyAddress;

    protected void setUp() throws Exception {
        super.setUp();
        this.testProxy = new TestProxy();
        int proxyPort = this.testProxy.startAndWait();
        assert (proxyPort > 0);
        this.proxyAddress = new InetSocketAddress("localhost", proxyPort);
        this.client = new HttpClient();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testProxy.stop();
    }

    public void testConnectCancelStalledConnect() throws Exception {
        final StubProgressMonitor monitor = new StubProgressMonitor();
        String host = "google.com";
        int port = 9999;
        try {
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    monitor.canceled = true;
                }
            };
            new Thread(runner).start();
            WebUtil.connect((Socket)new Socket(), (InetSocketAddress)new InetSocketAddress(host, port), (int)5000, (IProgressMonitor)monitor);
            WebUtilTest.fail((String)"Expected OperationCanceledException");
        }
        catch (OperationCanceledException operationCanceledException) {
            WebUtilTest.assertTrue((boolean)monitor.isCanceled());
        }
    }

    public void testExecute() throws Exception {
        StubProgressMonitor monitor = new StubProgressMonitor();
        HttpClient client = new HttpClient();
        String url = "http://eclipse.org/";
        WebLocation location = new WebLocation(url);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
        GetMethod method = new GetMethod(url);
        try {
            int result = WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            WebUtilTest.assertEquals((int)200, (int)result);
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    public void testExecuteCancelStalledConnect() throws Exception {
        final StubProgressMonitor monitor = new StubProgressMonitor();
        HttpClient client = new HttpClient();
        String url = "http://google.com:9999/";
        WebLocation location = new WebLocation(url);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
        GetMethod method = new GetMethod(url);
        try {
            try {
                Runnable runner = new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                        monitor.canceled = true;
                    }
                };
                new Thread(runner).start();
                WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                client.executeMethod((HttpMethod)method);
                WebUtilTest.fail((String)"Expected OperationCanceledException");
            }
            catch (OperationCanceledException operationCanceledException) {
                WebUtilTest.assertTrue((boolean)monitor.isCanceled());
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    public void testExecuteAlreadyCancelled() throws Exception {
        StubProgressMonitor monitor = new StubProgressMonitor();
        HttpClient client = new HttpClient();
        String url = "http://eclipse.org/";
        WebLocation location = new WebLocation(url);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)location, (IProgressMonitor)monitor);
        GetMethod method = new GetMethod(url);
        try {
            try {
                monitor.canceled = true;
                WebUtil.execute((HttpClient)client, (HostConfiguration)hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                WebUtilTest.fail((String)"Expected InterruptedIOException");
            }
            catch (OperationCanceledException operationCanceledException) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    public void testConfigureHttpClient() {
        HttpClient client = new HttpClient();
        WebUtil.configureHttpClient((HttpClient)client, (String)"");
        WebUtilTest.assertEquals((Object)WebUtil.getUserAgent((String)""), (Object)client.getParams().getParameter("http.useragent"));
        WebUtil.configureHttpClient((HttpClient)client, null);
        WebUtilTest.assertEquals((Object)WebUtil.getUserAgent((String)""), (Object)client.getParams().getParameter("http.useragent"));
        WebUtil.configureHttpClient((HttpClient)client, (String)"myagent");
        WebUtilTest.assertTrue((-1 != client.getParams().getParameter("http.useragent").toString().indexOf("myagent") ? 1 : 0) != 0);
    }

    public void testCreateHostConfigurationProxy() throws Exception {
        StubProgressMonitor monitor = new StubProgressMonitor();
        HttpClient client = new HttpClient();
        WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)new WebLocation("http://eclipse.org/", null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                WebUtilTest.assertEquals((String)"HTTP", (String)proxyType);
                return null;
            }
        }), (IProgressMonitor)monitor);
        WebUtil.createHostConfiguration((HttpClient)client, (AbstractWebLocation)new WebLocation("https://eclipse.org/", null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                WebUtilTest.assertEquals((String)"HTTPS", (String)proxyType);
                return null;
            }
        }), (IProgressMonitor)monitor);
    }

    public void testReadTimeout() throws Exception {
        block5: {
            WebUtilTest.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
            String url = "http://" + this.proxyAddress.getHostName() + ":" + this.proxyAddress.getPort() + "/";
            WebLocation location = new WebLocation(url, null, null, null);
            HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
            this.testProxy.addResponse(TestProxy.TIMEOUT);
            GetMethod method = new GetMethod("/");
            method.getParams().setSoTimeout(100);
            int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
            WebUtilTest.assertEquals((int)200, (int)statusCode);
            PollingInputStream in = new PollingInputStream((InputStream)new TimeoutInputStream(method.getResponseBodyAsStream(), 8192, 500L, -1L), 1, (IProgressMonitor)new NullProgressMonitor());
            try {
                try {
                    in.read();
                    WebUtilTest.fail((String)"expected InterruptedIOException");
                }
                catch (InterruptedIOException interruptedIOException) {
                    in.close();
                    break block5;
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
        }
        Thread.sleep(500L);
        WebUtilTest.assertEquals((int)0, (int)((ThreadPoolExecutor)CommonsNetPlugin.getExecutorService()).getActiveCount());
    }

    public void testLocationConnect() throws Exception {
        String url = "http://" + this.proxyAddress.getHostName() + ":" + this.proxyAddress.getPort() + "/";
        WebLocation location = new WebLocation(url, null, null, null);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod("/");
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)200, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET / HTTP/1.1", (String)request.request);
    }

    public void testLocationConnectSsl() throws Exception {
        String url = "https://" + this.proxyAddress.getHostName() + ":" + this.proxyAddress.getPort() + "/";
        WebLocation location = new WebLocation(url, null, null, null);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.testProxy.setCloseOnConnect(true);
        GetMethod method = new GetMethod("/");
        try {
            int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
            WebUtilTest.fail((String)("Expected SSLHandshakeException or connection reset, got status: " + statusCode));
        }
        catch (SSLHandshakeException sSLHandshakeException) {
        }
        catch (SocketException e) {
            WebUtilTest.assertEquals((String)"Connection reset", (String)e.getMessage());
        }
        WebUtilTest.assertFalse((boolean)this.testProxy.hasRequest());
    }

    public void testLocationConnectProxy() throws Exception {
        String url = "http://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)url));
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)200, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET http://foo/bar HTTP/1.1", (String)request.request);
    }

    public void testLocationConnectProxyHttpAuth() throws Exception {
        String url = "http://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, "", "", new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        location.setCredentials(AuthenticationType.HTTP, "user", "pass");
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.client.getParams().setAuthenticationPreemptive(true);
        TestProxy.Message response = new TestProxy.Message("HTTP/1.1 401 Authentication required");
        response.headers.add("WWW-Authenticate: Basic realm=\"Foo\"");
        this.testProxy.addResponse(response);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod(url);
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)401, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET http://foo/bar HTTP/1.1", (String)request.request);
        WebUtilTest.assertEquals((String)"Basic dXNlcjpwYXNz", (String)request.getHeaderValue("Authorization"));
    }

    public void testLocationConnectProxyNoProxyCredentials() throws Exception {
        String url = "http://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, "user", "pass", new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        TestProxy.Message response = new TestProxy.Message("HTTP/1.1 407 Proxy authentication required");
        response.headers.add("Proxy-Authenticate: Basic realm=\"Foo\"");
        this.testProxy.addResponse(response);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod(url);
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)407, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET http://foo/bar HTTP/1.1", (String)request.request);
        WebUtilTest.assertFalse((String)"Expected HttpClient to close connection", (boolean)this.testProxy.hasRequest());
    }

    public void testLocationConnectProxyProxyCredentials() throws Exception {
        String url = "http://foo/bar";
        AuthenticatedProxy proxy = new AuthenticatedProxy(Proxy.Type.HTTP, (SocketAddress)this.proxyAddress, "proxyUser", "proxyPass");
        WebLocation location = new WebLocation(url, "user", "pass", new IProxyProvider((Proxy)proxy){
            private final /* synthetic */ Proxy val$proxy;
            {
                this.val$proxy = proxy;
            }

            public Proxy getProxyForHost(String host, String proxyType) {
                return this.val$proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.client.getParams().setAuthenticationPreemptive(true);
        TestProxy.Message response = new TestProxy.Message("HTTP/1.1 407 Proxy authentication required");
        response.headers.add("Proxy-Authenticate: Basic realm=\"Foo\"");
        this.testProxy.addResponse(response);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod(url);
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)407, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET http://foo/bar HTTP/1.1", (String)request.request);
        WebUtilTest.assertEquals((String)"Basic cHJveHlVc2VyOnByb3h5UGFzcw==", (String)request.getHeaderValue("Proxy-Authorization"));
    }

    public void testLocationConnectProxyProxyCredentialsHttpAuth() throws Exception {
        String url = "http://foo/bar";
        AuthenticatedProxy proxy = new AuthenticatedProxy(Proxy.Type.HTTP, (SocketAddress)this.proxyAddress, "proxyUser", "proxyPass");
        WebLocation location = new WebLocation(url, "", "", new IProxyProvider((Proxy)proxy){
            private final /* synthetic */ Proxy val$proxy;
            {
                this.val$proxy = proxy;
            }

            public Proxy getProxyForHost(String host, String proxyType) {
                return this.val$proxy;
            }
        });
        location.setCredentials(AuthenticationType.HTTP, "user", "pass");
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.client.getParams().setAuthenticationPreemptive(true);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod(url);
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)200, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"GET http://foo/bar HTTP/1.1", (String)request.request);
        WebUtilTest.assertEquals((String)"Basic cHJveHlVc2VyOnByb3h5UGFzcw==", (String)request.getHeaderValue("Proxy-Authorization"));
        WebUtilTest.assertEquals((String)"Basic dXNlcjpwYXNz", (String)request.getHeaderValue("Authorization"));
    }

    public void testLocationSslConnectProxy() throws Exception {
        String url = "https://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.testProxy.addResponse(TestProxy.SERVICE_UNVAILABLE);
        GetMethod method = new GetMethod("/");
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)503, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"CONNECT foo:443 HTTP/1.1", (String)request.request);
    }

    public void testLocationSslConnectProxyProxyCredentials() throws Exception {
        String url = "https://foo/bar";
        AuthenticatedProxy proxy = new AuthenticatedProxy(Proxy.Type.HTTP, (SocketAddress)this.proxyAddress, "proxyUser", "proxyPass");
        WebLocation location = new WebLocation(url, null, null, new IProxyProvider((Proxy)proxy){
            private final /* synthetic */ Proxy val$proxy;
            {
                this.val$proxy = proxy;
            }

            public Proxy getProxyForHost(String host, String proxyType) {
                return this.val$proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.client.getParams().setAuthenticationPreemptive(true);
        this.testProxy.addResponse(TestProxy.SERVICE_UNVAILABLE);
        GetMethod method = new GetMethod("/");
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)503, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"CONNECT foo:443 HTTP/1.1", (String)request.request);
        WebUtilTest.assertEquals((String)"Basic cHJveHlVc2VyOnByb3h5UGFzcw==", (String)request.getHeaderValue("Proxy-Authorization"));
    }

    public void testLocationSslConnectProxyNoProxyCredentials() throws Exception {
        String url = "https://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        TestProxy.Message response = new TestProxy.Message("HTTP/1.1 407 Proxy authentication required");
        response.headers.add("Proxy-Authenticate: Basic realm=\"Foo\"");
        this.testProxy.addResponse(response);
        this.testProxy.addResponse(TestProxy.SERVICE_UNVAILABLE);
        GetMethod method = new GetMethod("/");
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)407, (int)statusCode);
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"CONNECT foo:443 HTTP/1.1", (String)request.request);
        WebUtilTest.assertFalse((String)"Expected HttpClient to close connection", (boolean)this.testProxy.hasRequest());
    }

    public void testLocationSslConnectProxyTimeout() throws Exception {
        String url = "https://foo/bar";
        final Proxy proxy = new Proxy(Proxy.Type.HTTP, this.proxyAddress);
        WebLocation location = new WebLocation(url, null, null, new IProxyProvider(){

            public Proxy getProxyForHost(String host, String proxyType) {
                return proxy;
            }
        });
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        this.testProxy.addResponse(TestProxy.OK);
        GetMethod method = new GetMethod("/");
        method.getParams().setParameter("http.method.retry-handler", (Object)new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                return false;
            }
        });
        try {
            int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
            WebUtilTest.fail((String)("Expected SSLHandshakeException, got status: " + statusCode));
        }
        catch (SSLHandshakeException sSLHandshakeException) {
        }
        catch (SocketException socketException) {}
        TestProxy.Message request = this.testProxy.getRequest();
        WebUtilTest.assertEquals((String)"CONNECT foo:443 HTTP/1.1", (String)request.request);
    }

    public void testLocationConnectSslClientCert() throws Exception {
        String url = "https://mylyn.eclipse.org/secure/";
        WebLocation location = new WebLocation(url, null, null, null);
        HostConfiguration hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.client, (AbstractWebLocation)location, null);
        if (!((PollingSslProtocolSocketFactory)hostConfiguration.getProtocol().getSocketFactory()).hasKeyManager()) {
            return;
        }
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)url));
        int statusCode = this.client.executeMethod(hostConfiguration, (HttpMethod)method);
        WebUtilTest.assertEquals((int)200, (int)statusCode);
    }

    public void testGetUserAgent() {
        String userAgent = WebUtil.getUserAgent(null);
        WebUtilTest.assertEquals((String)userAgent, (String)WebUtil.getUserAgent((String)""));
        WebUtilTest.assertEquals((int)-1, (int)userAgent.indexOf("null"));
        WebUtilTest.assertEquals((int)-1, (int)userAgent.indexOf("  "));
        WebUtilTest.assertEquals((int)0, (int)userAgent.indexOf("Mylyn"));
        userAgent = WebUtil.getUserAgent((String)"abc");
        WebUtilTest.assertEquals((int)-1, (int)userAgent.indexOf("null"));
        WebUtilTest.assertEquals((int)-1, (int)userAgent.indexOf("  "));
        WebUtilTest.assertEquals((int)0, (int)userAgent.indexOf("Mylyn"));
        WebUtilTest.assertTrue((boolean)userAgent.contains(" abc "));
    }

    public void testUrlParsers() {
        String url = "https://example.com:444/folder/file.txt";
        WebUtilTest.assertEquals((int)444, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"/folder/file.txt", (String)WebUtil.getRequestPath((String)url));
        url = "http://example.com/";
        WebUtilTest.assertEquals((int)80, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"/", (String)WebUtil.getRequestPath((String)url));
        url = "http://example.com";
        WebUtilTest.assertEquals((int)80, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"", (String)WebUtil.getRequestPath((String)url));
        url = "https://example.com:321";
        WebUtilTest.assertEquals((int)321, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"", (String)WebUtil.getRequestPath((String)url));
        url = "example.com:321";
        WebUtilTest.assertEquals((int)321, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"", (String)WebUtil.getRequestPath((String)url));
        url = "https://example.com:444/folder/file.txt?search=https://example.com:812/folder/file.txt";
        WebUtilTest.assertEquals((int)444, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"/folder/file.txt?search=https://example.com:812/folder/file.txt", (String)WebUtil.getRequestPath((String)url));
        url = "https://example.com/folder/file.txt?search=https://example.com:812/folder/file.txt";
        WebUtilTest.assertEquals((int)443, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"example.com", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"/folder/file.txt?search=https://example.com:812/folder/file.txt", (String)WebUtil.getRequestPath((String)url));
        url = "https://jira.codehaus.org/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?&pid=11093&resolution=-1&sorter/field=updated&sorter/order=DESC&tempMax=1000";
        WebUtilTest.assertEquals((int)443, (int)WebUtil.getPort((String)url));
        WebUtilTest.assertEquals((String)"jira.codehaus.org", (String)WebUtil.getHost((String)url));
        WebUtilTest.assertEquals((String)"/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?&pid=11093&resolution=-1&sorter/field=updated&sorter/order=DESC&tempMax=1000", (String)WebUtil.getRequestPath((String)url));
    }

    public void testGetTitleFromUrl() throws Exception {
        WebUtilTest.assertEquals((String)"Eclipse - The Eclipse Foundation open source community website.", (String)WebUtil.getTitleFromUrl((AbstractWebLocation)new WebLocation("http://eclipse.org"), null));
        String url = "http://" + this.proxyAddress.getHostName() + ":" + this.proxyAddress.getPort() + "/";
        this.testProxy.addResponse(TestProxy.OK);
        WebUtilTest.assertNull((Object)WebUtil.getTitleFromUrl((AbstractWebLocation)new WebLocation(url), null));
    }

    public void testGetTitleFromUrlUtf8() throws Exception {
        String message = "HTTP/1.1 200 OK\nDate: Sat, 03 Jan 2009 14:40:23 GMT\nConnection: close\nContent-Type: text/html; charset=UTF-8\nContent-Length: 30\n\n<html><title>\u00c3\u00bc</title></html>";
        this.testProxy.addResponse(message);
        String url = "http://" + this.proxyAddress.getHostName() + ":" + this.proxyAddress.getPort() + "/";
        WebUtilTest.assertEquals((String)"\u00fc", (String)WebUtil.getTitleFromUrl((AbstractWebLocation)new WebLocation(url), null));
    }

    private class StubProgressMonitor
    implements IProgressMonitor {
        private volatile boolean canceled;

        private StubProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean value) {
            this.canceled = value;
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }
    }
}

