/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.tests.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader;
import org.eclipse.osgi.util.NLS;

public class CommonTestUtil {
    private static final int MAX_RETRY = 5;

    public static String changeSeparator(String path, char oldSeparator, char newSeparator) {
        return path.replace(oldSeparator, newSeparator);
    }

    public static void copy(File source, File dest) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(dest);
            try {
                CommonTestUtil.transferData(in, out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static void copyFolder(File sourceFolder, File targetFolder) throws IOException {
        File[] fileArray = sourceFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File currFile = fileArray[n2];
            if (currFile.isFile()) {
                File destFile = new File(targetFolder, currFile.getName());
                CommonTestUtil.copy(currFile, destFile);
            } else if (currFile.isDirectory()) {
                File destDir = new File(targetFolder, currFile.getName());
                if (!destDir.exists() && !destDir.mkdir()) {
                    throw new IOException("Unable to create destination context folder: " + destDir.getAbsolutePath());
                }
                File[] fileArray2 = currFile.listFiles();
                int n3 = fileArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file = fileArray2[n4];
                    File destFile = new File(destDir, file.getName());
                    if (destFile.exists()) {
                        destFile.delete();
                    }
                    CommonTestUtil.copy(file, destFile);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static File createTempFileInPlugin(Plugin plugin, IPath path) {
        IPath stateLocation = plugin.getStateLocation();
        stateLocation = stateLocation.append(path);
        return stateLocation.toFile();
    }

    public static void delete(File file) {
        if (file.exists()) {
            int i = 0;
            while (i < 5) {
                if (file.delete()) {
                    i = 5;
                } else {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ++i;
            }
        }
    }

    public static void deleteFolder(File path) {
        if (path.isDirectory()) {
            File[] fileArray = path.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            path.delete();
        }
    }

    public static void deleteFolderRecursively(File path) {
        File[] files = path.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    CommonTestUtil.deleteFolderRecursively(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
    }

    public static InputStream getResource(Object source, String filename) throws IOException {
        File file;
        Class<?> clazz = source instanceof Class ? (Class<?>)source : source.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream in = classLoader.getResourceAsStream(filename);
        if (in == null && (file = CommonTestUtil.getFile(source, filename)) != null) {
            return new FileInputStream(file);
        }
        if (in == null) {
            throw new IOException(NLS.bind((String)"Failed to locate ''{0}'' for ''{1}''", (Object)filename, (Object)clazz.getName()));
        }
        return in;
    }

    public static File getFile(Object source, String filename) throws IOException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = source instanceof Class ? (Class<?>)source : source.getClass();
        if (Platform.isRunning()) {
            URL url;
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader instanceof DefaultClassLoader && (url = ((DefaultClassLoader)classLoader).getClasspathManager().getBaseData().getBundle().getEntry(filename)) != null) {
                URL localURL = FileLocator.toFileURL((URL)url);
                return new File(localURL.getFile());
            }
        } else {
            URL localURL = clazz.getResource("");
            String path = URLDecoder.decode(localURL.getFile(), Charset.defaultCharset().name());
            int i = path.indexOf("!");
            if (i != -1) {
                int j = path.lastIndexOf(File.separatorChar, i);
                if (j == -1) {
                    throw new AssertionFailedError("Unable to determine location for '" + filename + "' at '" + path + "'");
                }
                path = String.valueOf(path.substring(0, j)) + File.separator;
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                return new File(String.valueOf(path) + filename);
            }
            String directory = clazz.getName().replaceAll("[^.]", "");
            directory = directory.replaceAll(".", "../");
            if (path.contains("/bin/")) {
                directory = String.valueOf(directory) + "../";
            } else if (path.contains("/target/classes/")) {
                directory = String.valueOf(directory) + "../../";
            }
            filename = String.valueOf(path) + (String.valueOf(directory) + filename).replaceAll("/", Matcher.quoteReplacement(File.separator));
            return new File(filename).getCanonicalFile();
        }
        throw new AssertionFailedError("Could not locate " + filename);
    }

    public static String read(File source) throws IOException {
        FileInputStream in = new FileInputStream(source);
        try {
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                sb.append(new String(buf, 0, len));
            }
            String string = sb.toString();
            return string;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void transferData(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public static void unzip(ZipFile zipFile, File dstDir) throws IOException {
        CommonTestUtil.unzip(zipFile, dstDir, dstDir, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzip(ZipFile zipFile, File rootDstDir, File dstDir, int depth) throws IOException {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        try {
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String entryName = entry.getName();
                File file = new File(dstDir, CommonTestUtil.changeSeparator(entryName, '/', File.separatorChar));
                file.getParentFile().mkdirs();
                InputStream src = null;
                OutputStream dst = null;
                try {
                    src = zipFile.getInputStream(entry);
                    dst = new FileOutputStream(file);
                    CommonTestUtil.transferData(src, dst);
                }
                catch (Throwable throwable) {
                    if (dst != null) {
                        try {
                            dst.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (src == null) throw throwable;
                    try {
                        src.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                if (dst != null) {
                    try {
                        dst.close();
                    }
                    catch (IOException iOException) {}
                }
                if (src == null) continue;
                try {
                    src.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            zipFile.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static void write(String fileName, StringBuffer content) throws IOException {
        FileWriter writer = new FileWriter(fileName);
        try {
            writer.write(content.toString());
        }
        catch (Throwable throwable) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException iOException) {}
    }
}

